(*
 *  Seplog is an implementation of separation logic (an extension of Hoare
 *  logic by John C. Reynolds, Peter W. O'Hearn, and colleagues) in the
 *  Coq proof assistant (version 8, http://coq.inria.fr) together with a
 *  sample verification of the heap manager of the Topsy operating system
 *  (version 2, http://www.topsy.net). More information is available at
 *  http://staff.aist.go.jp/reynald.affeldt/seplog.
 *
 *  Copyright (c) 2005, 2006 Reynald Affeldt and Nicolas Marti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *)

open Extracted

let rec num2pos n = 
    if (n > 1) then (psucc (num2pos (n - 1)))
    else XH

let num2Z n =
  if (n == 0) then
       Z0 
  else 
     if (n < 0) then
          Zneg (num2pos (-n)) 
     else
          Zpos (num2pos n) 


let rec num2Nat n =
    if (n > 0) then (S (num2Nat (n - 1)))
    else O

let rec power2 n =
if (n <= 0) then 1 else (2 * power2 (n-1))

let rec pos2num' p n =
match p with
| XH -> power2 n
| XI p' -> (power2 n) + pos2num' p' (n + 1) 
| XO p' -> pos2num' p' (n + 1)

let pos2num p = pos2num' p 0

let z2num z =
    match z with
        | Z0 -> 0
        | Zneg p -> - (pos2num p)
        | Zpos p -> (pos2num p)

let rec nat2num n =
    match n with
        | O -> 0
        | S n' -> 1 + nat2num n'
