#####################################################################################
# MechSys - A C++ library to simulate (Continuum) Mechanical Systems                #
# Copyright (C) 2005 Dorival de Moraes Pedroso <dorival.pedroso at gmail.com>       #
# Copyright (C) 2005 Raul Dario Durand Farfan  <raul.durand at gmail.com>           #
#                                                                                   #
# This file is part of MechSys.                                                     #
#                                                                                   #
# MechSys is free software; you can redistribute it and/or modify it under the      #
# terms of the GNU General Public License as published by the Free Software         #
# Foundation; either version 2 of the License, or (at your option) any later        #
# version.                                                                          #
#                                                                                   #
# MechSys is distributed in the hope that it will be useful, but WITHOUT ANY        #
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A   #
# PARTICULAR PURPOSE. See the GNU General Public License for more details.          #
#                                                                                   #
# You should have received a copy of the GNU General Public License along with      #
# MechSys; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, #
# Fifth Floor, Boston, MA 02110-1301, USA                                           #
#####################################################################################

#####################################################################################
#  Must be used in the following order                                              #
#                                                                                   #
#  -llapack -lptf77blas -lptcblas -latlas -lgfortran -lpthread                      #
#                                                                                   #
#####################################################################################

SET(ATLAS_LIBRARY_SEARCH_PATH
  $ENV{HOME}/opt/lib
  /usr/lib/sse2
  /usr/lib/altivec
  /usr/lib
  /usr/lib/atlas
  /usr/local/lib
  /usr/local/lib/atlas
  $ENV{HOME}/opt/lib/ATLAS)

OPTION(ATLAS_USE_CUSTOM "Use libraries optimized (customized) by user" OFF)

INCLUDE(FindThreads)

IF(ATLAS_USE_CUSTOM)
	FIND_LIBRARY(ATLAS_LAPACK NAMES custom_lapack PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	FIND_LIBRARY(ATLAS_ATLAS  NAMES custom_atlas  PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	IF(CMAKE_THREAD_LIBS_INIT)
		FIND_LIBRARY(ATLAS_F77BLAS NAMES custom_ptf77blas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
		FIND_LIBRARY(ATLAS_CBLAS   NAMES custom_ptcblas   PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ELSE(CMAKE_THREAD_LIBS_INIT)
		FIND_LIBRARY(ATLAS_F77BLAS NAMES custom_f77blas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
		FIND_LIBRARY(ATLAS_CBLAS   NAMES custom_cblas   PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ENDIF(CMAKE_THREAD_LIBS_INIT)
	IF(NOT ${ATLAS_F77BLAS})
		FIND_LIBRARY(ATLAS_F77BLAS NAMES custom_f77blas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
		FIND_LIBRARY(ATLAS_CBLAS   NAMES custom_cblas   PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ENDIF(NOT ${ATLAS_F77BLAS})
ELSE(ATLAS_USE_CUSTOM)
	FIND_LIBRARY(ATLAS_LAPACK NAMES lapack_atlas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	FIND_LIBRARY(ATLAS_ATLAS  NAMES atlas        PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	IF(CMAKE_THREAD_LIBS_INIT)
		FIND_LIBRARY(ATLAS_F77BLAS NAMES ptf77blas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
		FIND_LIBRARY(ATLAS_CBLAS   NAMES ptcblas   PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ELSE(CMAKE_THREAD_LIBS_INIT)
		FIND_LIBRARY(ATLAS_F77BLAS NAMES f77blas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
		FIND_LIBRARY(ATLAS_CBLAS   NAMES cblas   PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ENDIF(CMAKE_THREAD_LIBS_INIT)
	IF(NOT ${ATLAS_LAPACK})
		FIND_LIBRARY(ATLAS_LAPACK NAMES lapack PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ENDIF(NOT ${ATLAS_LAPACK})
	IF(NOT ${ATLAS_F77BLAS})
		FIND_LIBRARY(ATLAS_F77BLAS NAMES f77blas PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
		FIND_LIBRARY(ATLAS_CBLAS   NAMES cblas   PATHS ${ATLAS_LIBRARY_SEARCH_PATH})
	ENDIF(NOT ${ATLAS_F77BLAS})
ENDIF(ATLAS_USE_CUSTOM)

SET(ATLAS_FOUND 1)
FOREACH(var ATLAS_LAPACK ATLAS_F77BLAS ATLAS_CBLAS ATLAS_ATLAS)
  IF(NOT ${var})
	SET(ATLAS_FOUND 0)
  ENDIF(NOT ${var})
ENDFOREACH(var)

IF(ATLAS_FOUND)
  SET(ATLAS_LIBRARIES ${ATLAS_LAPACK} ${ATLAS_F77BLAS} ${ATLAS_CBLAS} ${ATLAS_ATLAS})
ENDIF(ATLAS_FOUND)
