########################################################################
# SGA - A C++ library to help develop Simple Genetic Algorithms        #
# Copyright (C) 2005 Dorival M. Pedroso                                #
#                                                                      #
# This program is free software: you can redistribute it and/or modify #
# it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or    #
# any later version.                                                   #
#                                                                      #
# This program is distributed in the hope that it will be useful,      #
# but WITHOUT ANY WARRANTY; without even the implied warranty of       #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         #
# GNU General Public License for more details.                         #
#                                                                      #
# You should have received a copy of the GNU General Public License    #
# along with this program. If not, see <http://www.gnu.org/licenses/>  #
########################################################################

SET(FLTK_INCLUDE_SEARCH_PATH
  /usr/include/FL
  /usr/include
  /usr/include/Fl
  /usr/local/include/FL
  /usr/local/include/Fl)

SET(FLTK_LIBRARY_SEARCH_PATH
  /usr/lib
  /usr/local/lib)

FIND_PATH(FLTK_FLTK_H  Fl.H     ${FLTK_INCLUDE_SEARCH_PATH})
FIND_PATH(FLTK_GL_H    GL/gl.h  ${FLTK_INCLUDE_SEARCH_PATH})

FIND_LIBRARY(FLTK_FLTK    NAMES fltk    PATHS ${FLTK_LIBRARY_SEARCH_PATH})
FIND_LIBRARY(FLTK_FLTK_GL NAMES fltk_gl PATHS ${FLTK_LIBRARY_SEARCH_PATH})

SET(FLTK_FOUND 1)
FOREACH(var FLTK_FLTK_H FLTK_GL_H FLTK_FLTK FLTK_FLTK_GL)
  IF(NOT ${var})
	SET(FLTK_FOUND 0)
  ENDIF(NOT ${var})
ENDFOREACH(var)

IF(FLTK_FOUND)
  SET(FLTK_INCLUDE_DIRS ${FLTK_FLTK_H})
  SET(FLTK_LIBRARIES    ${FLTK_FLTK} ${FLTK_FLTK_GL})
ENDIF(FLTK_FOUND)
