/************************************************************************
 * SGA - A C++ library to help develop Simple Genetic Algorithms        *
 * Copyright (C) 2005 Dorival M. Pedroso                                *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation, either version 3 of the License, or    *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program. If not, see <http://www.gnu.org/licenses/>  *
 ************************************************************************/

// STL
#include <iostream>

// SGA
#include "random.h"
#include "multiplot.h"

int main(int argc, char* argv[])
{
	const int N = 1000;

	Rnd::Init(1234);

	MULTIPLOT mp(10,10,800,500);
	mp.show();
	mp.set_scrolling (N);
	mp.set_pointsize (0, 4);

	for (int i=0; i<N; ++i)
		mp.add(0,PLOT_POINT(i,Rnd::T<double>::Gen()));

	mp.draw();
	Fl::run();
}
