/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log.rollover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.grlea.log.rollover.FileSizeRolloverStrategy;
import org.grlea.log.rollover.RolloverStrategy;
import org.grlea.log.rollover.TimeOfDayRolloverStrategy;

public class RolloverManager
extends Writer {
    private static final String KEY_PREFIX = "simplelog.";
    private static final String KEY_ROLLOVER_STRATEGY = "simplelog.rollover";
    private static final String ROLLOVER_STRATEGY_FILESIZE = "fileSize";
    private static final String ROLLOVER_STRATEGY_TIMEOFDAY = "timeOfDay";
    private static final String KEY_ACTIVE_LOG_FILE = "simplelog.logFile";
    private static final String KEY_ROLLOVER_LOG_FILE = "simplelog.rollover.filename";
    private static final String KEY_ROLLOVER_DIRECTORY = "simplelog.rollover.directory";
    private static final String KEY_ROLLOVER_PERIOD = "simplelog.rollover.period";
    private static final String DEFAULT_ROLLOVER_PERIOD = "60";
    private final Object PRINTERS_SEMAPHORE = new Object();
    private int printerCount = 0;
    private final Object WRITER_CHANGE_GATE = new Object();
    private Writer writer;
    private StringWriter tempWriter = new StringWriter(1024);
    private RolloverStrategy strategy;
    private String currentRolloverStrategyName;
    private File currentActiveLogFile;
    private File currentActiveLogFileDirectory;
    private File rolloverDirectory;
    private MessageFormat rolloverLogFileFormat;
    private RandomAccessFile fileOut;
    private boolean strategySetProgramatically = false;
    private long rolloverPeriod;
    private Timer timer;
    private int uniqueFileId = 0;
    private ErrorReporter errorReporter;

    public RolloverManager(Properties properties, ErrorReporter errorReporter) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        this.errorReporter = errorReporter;
        this.configure(properties);
    }

    public void configure(Properties properties) throws IOException {
        this.configureStrategy(properties);
        this.configureWriter(properties);
    }

    private void configureStrategy(Properties properties) throws IOException {
        RolloverStrategy rolloverStrategy;
        boolean bl;
        if (this.strategySetProgramatically) {
            return;
        }
        String string = properties.getProperty(KEY_ROLLOVER_STRATEGY);
        if (string == null) {
            throw new IOException("RolloverManger created, but rollover property not specified.");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IOException("RolloverManger created, but rollover property not specified.");
        }
        boolean bl2 = bl = !string.equals(this.currentRolloverStrategyName);
        if (bl) {
            try {
                if (ROLLOVER_STRATEGY_FILESIZE.equals(string)) {
                    rolloverStrategy = new FileSizeRolloverStrategy();
                }
                if (ROLLOVER_STRATEGY_TIMEOFDAY.equals(string)) {
                    rolloverStrategy = new TimeOfDayRolloverStrategy();
                }
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    if (!(obj instanceof RolloverStrategy)) {
                        throw new IOException(clazz.getName() + " is not a RolloverStrategy");
                    }
                    rolloverStrategy = (RolloverStrategy)obj;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException("Class '" + string + "' not found: " + classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new IOException("Failed to create an instance of " + string + ": " + instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IOException("Failed to create an instance of " + string + ": " + illegalAccessException);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Error creating RolloverStrategy: " + iOException);
            }
        } else {
            rolloverStrategy = this.strategy;
        }
        try {
            rolloverStrategy.configure(Collections.unmodifiableMap(properties));
        }
        catch (IOException iOException) {
            throw new IOException("Error configuring RolloverStrategy: " + iOException);
        }
        this.strategy = rolloverStrategy;
        this.currentRolloverStrategyName = string;
    }

    private void configureWriter(Properties properties) throws IOException {
        boolean bl;
        long l;
        MessageFormat messageFormat;
        String string = properties.getProperty(KEY_ACTIVE_LOG_FILE);
        if (string == null) {
            throw new IOException("RolloverManager created but no active log file name specified.");
        }
        File file = new File(string.trim()).getAbsoluteFile();
        if (file.isDirectory()) {
            throw new IOException("The specified active log file name already exists as a directory.");
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            throw new IOException("Caanot access the active log file's parent directory.");
        }
        file2.mkdirs();
        String string2 = properties.getProperty(KEY_ROLLOVER_LOG_FILE);
        if (string2 == null) {
            string2 = "{1}-" + file.getName();
        }
        string2 = string2.trim();
        try {
            messageFormat = new MessageFormat(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Illegal pattern provided for rollover log file name: " + illegalArgumentException.getMessage());
        }
        String string3 = properties.getProperty(KEY_ROLLOVER_DIRECTORY);
        File file3 = string3 != null ? new File(string3.trim()).getAbsoluteFile() : file2;
        if (file3.exists() && !file3.isDirectory()) {
            throw new IOException("The location specified for storing rolled log files is not a directory: " + file3);
        }
        String string4 = (String)properties.get(KEY_ROLLOVER_PERIOD);
        if (string4 == null) {
            string4 = DEFAULT_ROLLOVER_PERIOD;
        }
        if ((string4 = string4.trim()).length() == 0) {
            string4 = DEFAULT_ROLLOVER_PERIOD;
        }
        try {
            l = Long.parseLong(string4);
            if (l < 1L) {
                throw new NumberFormatException("Must be greater than 0");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid rollover period specified: " + string4 + " (" + numberFormatException.getMessage() + ")");
        }
        Format[] formatArray = messageFormat.getFormatsByArgumentIndex();
        boolean bl2 = bl = formatArray.length > 1;
        if (bl) {
            String[] stringArray = file3.list();
            int n = 0;
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                try {
                    String string6;
                    int n2;
                    Object[] objectArray = messageFormat.parse(string5);
                    if (objectArray.length <= 1 || objectArray[1] == null || (n2 = Integer.parseInt(string6 = (String)objectArray[1], 16)) <= n) continue;
                    n = n2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.uniqueFileId = n + 1;
        }
        this.rolloverDirectory = file3;
        this.rolloverLogFileFormat = messageFormat;
        if (!file.equals(this.currentActiveLogFile)) {
            this.openWriter(file, file2);
            this.currentActiveLogFile = file;
            this.currentActiveLogFileDirectory = file2;
        }
        if (this.timer == null || l != this.rolloverPeriod) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new RolloverTask(), 0L, l * 1000L);
            this.rolloverPeriod = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openWriter(File file, File file2) throws IOException {
        Object object = this.WRITER_CHANGE_GATE;
        synchronized (object) {
            Object object2 = this.PRINTERS_SEMAPHORE;
            synchronized (object2) {
                if (this.printerCount != 0) {
                    try {
                        this.PRINTERS_SEMAPHORE.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IllegalStateException("Interrupted while attempting to configure writer");
                    }
                }
                if (this.writer != this.tempWriter) {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException iOException) {
                            throw new IOException("Failed to close open file: " + iOException);
                        }
                    }
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    long l = fileChannel.size();
                    randomAccessFile.seek(l);
                    Writer writer = Channels.newWriter((WritableByteChannel)randomAccessFile.getChannel(), "UTF-8");
                    this.storeFileCreationTimeIfNecessary(file2, file);
                    this.fileOut = randomAccessFile;
                    this.writer = writer;
                }
            }
        }
    }

    private void storeFileCreationTimeIfNecessary(File file, File file2) throws IOException {
        long l = System.currentTimeMillis();
        try {
            boolean bl;
            File file3 = this.getCreationTimeFile(file, file2);
            boolean bl2 = bl = !file3.exists();
            if (bl) {
                FileWriter fileWriter = new FileWriter(file3);
                fileWriter.write(String.valueOf(l));
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to write file creation time: " + iOException);
        }
    }

    private long readCreationTime() throws IOException {
        try {
            File file = this.getCreationTimeFile(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            if (!file.exists()) {
                this.storeFileCreationTimeIfNecessary(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            }
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            bufferedReader.close();
            return Long.parseLong(string);
        }
        catch (IOException iOException) {
            throw new IOException("Error reading creation time file: " + iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error reading creation time: " + numberFormatException);
        }
    }

    private File getCreationTimeFile(File file, File file2) {
        return new File(file, file2.getName() + "-CREATED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.WRITER_CHANGE_GATE;
        synchronized (object) {
            Object object2 = this.PRINTERS_SEMAPHORE;
            synchronized (object2) {
                if (this.printerCount != 0) {
                    try {
                        this.PRINTERS_SEMAPHORE.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IllegalStateException("Interrupted while attempting to configure writer");
                    }
                }
                this.writer = this.tempWriter;
            }
            this.timer.cancel();
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                this.reportError("Error closing RolloverManager's writer", iOException, true);
            }
            try {
                this.fileOut.close();
            }
            catch (IOException iOException) {
                this.reportError("Error closing RolloverManager's file", iOException, true);
            }
        }
    }

    private void reportError(String string, IOException iOException, boolean bl) {
        if (this.errorReporter != null) {
            this.errorReporter.error(string, iOException, bl);
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.WRITER_CHANGE_GATE;
        // MONITORENTER : object
        // MONITOREXIT : object
        object = this.PRINTERS_SEMAPHORE;
        // MONITORENTER : object
        ++this.printerCount;
        // MONITOREXIT : object
        try {
            this.writer.write(cArray, n, n2);
            this.writer.flush();
            Object var7_5 = null;
            Object object2 = this.PRINTERS_SEMAPHORE;
            // MONITORENTER : object2
            --this.printerCount;
            if (this.printerCount == 0) {
                this.PRINTERS_SEMAPHORE.notifyAll();
            }
            // MONITOREXIT : object2
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Object object3 = this.PRINTERS_SEMAPHORE;
            // MONITORENTER : object3
            --this.printerCount;
            if (this.printerCount == 0) {
                this.PRINTERS_SEMAPHORE.notifyAll();
            }
            // MONITOREXIT : object3
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rolloverIfNecessary() throws IOException {
        FileChannel fileChannel;
        long l;
        long l2 = this.readCreationTime();
        Date date = new Date(l2);
        boolean bl = this.strategy.rolloverNow(date, l = (fileChannel = this.fileOut.getChannel()).size());
        if (bl) {
            Object object;
            Object object2 = this.WRITER_CHANGE_GATE;
            synchronized (object2) {
                object = this.PRINTERS_SEMAPHORE;
                synchronized (object) {
                    if (this.printerCount != 0) {
                        try {
                            this.PRINTERS_SEMAPHORE.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new IllegalStateException("Interrupted while attempting to configure writer");
                        }
                    }
                    this.writer = this.tempWriter;
                }
            }
            int n = this.uniqueFileId++;
            object = new StringBuffer();
            ((StringBuffer)object).append(Integer.toHexString(n).toUpperCase());
            char[] cArray = new char[8 - ((StringBuffer)object).length()];
            Arrays.fill(cArray, '0');
            ((StringBuffer)object).insert(0, cArray);
            String string = this.rolloverLogFileFormat.format(new Object[]{new Date(), ((StringBuffer)object).toString()});
            if (!this.rolloverDirectory.exists()) {
                this.rolloverDirectory.mkdirs();
            }
            File file = new File(this.rolloverDirectory, string);
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileOutputStream.close();
            fileChannel.truncate(0L);
            this.fileOut.seek(0L);
            Writer writer = Channels.newWriter((WritableByteChannel)fileChannel, "UTF-8");
            File file2 = this.getCreationTimeFile(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            file2.delete();
            this.storeFileCreationTimeIfNecessary(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            Object object3 = this.WRITER_CHANGE_GATE;
            synchronized (object3) {
                Object object4 = this.PRINTERS_SEMAPHORE;
                synchronized (object4) {
                    if (this.printerCount != 0) {
                        try {
                            this.PRINTERS_SEMAPHORE.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new IllegalStateException("Interrupted while attempting to configure writer");
                        }
                    }
                    this.writer = writer;
                    StringBuffer stringBuffer = this.tempWriter.getBuffer();
                    writer.write(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                }
            }
        }
    }

    public RolloverStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(RolloverStrategy rolloverStrategy) {
        if (rolloverStrategy == null) {
            throw new IllegalArgumentException("strategy cannot be null.");
        }
        this.strategy = rolloverStrategy;
        this.strategySetProgramatically = true;
    }

    public static Writer createRolloverManager(Properties properties, ErrorReporter errorReporter) throws IOException {
        return new RolloverManager(properties, errorReporter);
    }

    public static interface ErrorReporter {
        public void error(String var1, Throwable var2, boolean var3);
    }

    private final class RolloverTask
    extends TimerTask {
        private RolloverTask() {
        }

        public void run() {
            try {
                RolloverManager.this.rolloverIfNecessary();
            }
            catch (IOException iOException) {
                RolloverManager.this.reportError("SimpleLog ERROR: Failed to check or attempt rollover", iOException, true);
            }
        }
    }
}

