/*
 * $Id: mega128.h,v 1.4 2008/03/19 22:39:03 joerg_wunsch Exp $
 *
 ****************************************************************************
 *
 * simulavr - A simulator for the Atmel AVR family of microcontrollers.
 * Copyright (C) 2004  Theodore A. Roth
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ****************************************************************************
 */

#if defined (IN_DEVSUPP_C)
/* *INDENT-OFF* */

static DevSuppDefn defn_atmega128 = {
    .name           = "atmega128",
    .stack_type     = STACK_MEMORY,
    .irq_vect_idx   = VTAB_ATMEGA128,
    .has_ext_io_reg = 1,

    .size = {
        .pc         = 2,
        .stack      = 0,
        .flash      = 128 * 1024,
        .sram       = 4 * 1024,
        .xram       = 65536 - 4 * 1024 - 0x100,
        .eeprom     = 4 * 1024
    },

    .io_reg = {
        {
            .addr = 0x20,
            .name = "PINF",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x21,
            .name = "PINE",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x22,
            .name = "DDRE",
            .ref_addr = 0x21,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x23,
            .name = "PORTE",
            .ref_addr = 0x21,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        { .addr = 0x24, .name = "ADCL", },
        { .addr = 0x25, .name = "ADCH", },
        { .addr = 0x26, .name = "ADCSRA", },
        { .addr = 0x27, .name = "ADMUX", },
        { .addr = 0x28, .name = "ACSR", },
        { .addr = 0x29, .name = "UBRR0L", },
        { .addr = 0x2a, .name = "UCSR0B", },
        { .addr = 0x2b, .name = "UCSR0A", },
        { .addr = 0x2c, .name = "UDR0", },
        { .addr = 0x2d, .name = "SPCR", },
        { .addr = 0x2e, .name = "SPSR", },
        { .addr = 0x2f, .name = "SPDR", },
        {
            .addr = 0x30,
            .name = "PIND",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x31,
            .name = "DDRD",
            .ref_addr = 0x30,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x32,
            .name = "PORTD",
            .ref_addr = 0x30,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x33,
            .name = "PINC",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x34,
            .name = "DDRC",
            .ref_addr = 0x33,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x35,
            .name = "PORTC",
            .ref_addr = 0x33,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x36,
            .name = "PINB",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x37,
            .name = "DDRB",
            .ref_addr = 0x36,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x38,
            .name = "PORTB",
            .ref_addr = 0x36,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x39,
            .name = "PINA",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x3a,
            .name = "DDRA",
            .ref_addr = 0x39,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x3b,
            .name = "PORTA",
            .ref_addr = 0x39,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
	    .addr = 0x3c,
	    .name = "EECR",
	    .vdev_create = eeprom_create,
	    .rd_mask = 0x0f,
	    .wr_mask = 0x0f,
	},
        {
	    .addr = 0x3d,
	    .name = "EEDR",
	    .ref_addr = 0x3c,
	    .rd_mask = 0xff,
	    .wr_mask = 0xff,
	},
        {
	    .addr = 0x3e,
	    .name = "EEARL",
	    .ref_addr = 0x3c,
	    .rd_mask = 0xff,
	    .wr_mask = 0xff,
	},
        {
	    .addr = 0x3f,
	    .name = "EEARH",
	    .ref_addr = 0x3c,
	    .rd_mask = 0x0f,
	    .wr_mask = 0x0f,
	},
        { .addr = 0x40, .name = "SFIOR", },
        { .addr = 0x41, .name = "WDTCR", },
        { .addr = 0x42, .name = "OCDR", },
        { .addr = 0x43, .name = "OCR2", },
        { .addr = 0x44, .name = "TCNT2", },
        { .addr = 0x45, .name = "TCCR2", },
        { .addr = 0x46, .name = "ICR1L", },
        { .addr = 0x47, .name = "ICR1H", },
        { .addr = 0x48, .name = "OCR1BL", },
        { .addr = 0x49, .name = "OCR1BH", },
        { .addr = 0x4a, .name = "OCR1AL", },
        { .addr = 0x4b, .name = "OCR1AH", },
        { .addr = 0x4c, .name = "TCNT1L", },
        { .addr = 0x4d, .name = "TCNT1H", },
        { .addr = 0x4e, .name = "TCCR1B", },
        { .addr = 0x4f, .name = "TCCR1A", },
        { .addr = 0x50, .name = "ASSR", },
        { .addr = 0x51, .name = "OCR0", },
        { .addr = 0x52, .name = "TCNT0", },
        { .addr = 0x53, .name = "TCCR0", },
        { .addr = 0x54, .name = "MCUCSR", },
        { .addr = 0x55, .name = "MCUCR", },
        { .addr = 0x56, .name = "TIFR", },
        { .addr = 0x57, .name = "TIMSK", },
        { .addr = 0x58, .name = "EIFR", },
        { .addr = 0x59, .name = "EIMSK", },
        { .addr = 0x5a, .name = "EICRB", },
        {
            .addr = 0x5b,
            .name = "RAMPZ",
            .vdev_create = rampz_create,
            .reset_value = 0,
            .rd_mask = 0xff,
            .wr_mask = 0x01,
        },
        { .addr = 0x5c, .name = "XDIV", },
        {
            .addr = 0x5d,
            .name = "SPL", 
            .vdev_create = sp_create,
            .reset_value = 0,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x5e,
            .name = "SPH",
            .ref_addr = 0x5d,
            .reset_value = 0,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x5f,
            .name = "SREG",
            .vdev_create = sreg_create,
            .reset_value = 0,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x61,
            .name = "DDRF",
            .ref_addr = 0x20,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x62,
            .name = "PORTF",
            .ref_addr = 0x20,
            .reset_value = 0x00,
            .rd_mask = 0xff,
            .wr_mask = 0xff,
        },
        {
            .addr = 0x63,
            .name = "PING",
            .vdev_create = port_create,
            .reset_value = 0x00,
            .rd_mask = 0x1f,
            .wr_mask = 0x1f,
        },
        {
            .addr = 0x64,
            .name = "DDRG",
            .ref_addr = 0x63,
            .reset_value = 0x00,
            .rd_mask = 0x1f,
            .wr_mask = 0x1f,
        },
        {
            .addr = 0x65,
            .name = "PORTG",
            .ref_addr = 0x63,
            .reset_value = 0x00,
            .rd_mask = 0x1f,
            .wr_mask = 0x1f,
        },
        { .addr = 0x68, .name = "SPMCSR", },
        { .addr = 0x6a, .name = "EICRA", },
        { .addr = 0x6c, .name = "XMCRB", },
        { .addr = 0x6d, .name = "XMCRA", },
        { .addr = 0x6f, .name = "OSCCAL", },
        { .addr = 0x70, .name = "TWBR", },
        { .addr = 0x71, .name = "TWSR", },
        { .addr = 0x72, .name = "TWAR", },
        { .addr = 0x73, .name = "TWDR", },
        { .addr = 0x74, .name = "TWCR", },
        { .addr = 0x78, .name = "OCR1CL", },
        { .addr = 0x79, .name = "OCR1CH", },
        { .addr = 0x7a, .name = "TCCR1C", },
        { .addr = 0x7c, .name = "ETIFR", },
        { .addr = 0x7d, .name = "ETIMSK", },
        { .addr = 0x80, .name = "ICR3L", },
        { .addr = 0x81, .name = "ICR3H", },
        { .addr = 0x82, .name = "OCR3CL", },
        { .addr = 0x83, .name = "OCR3CH", },
        { .addr = 0x84, .name = "OCR3BL", },
        { .addr = 0x85, .name = "OCR3BH", },
        { .addr = 0x86, .name = "OCR3AL", },
        { .addr = 0x87, .name = "OCR3AH", },
        { .addr = 0x88, .name = "TCNT3L", },
        { .addr = 0x89, .name = "TCNT3H", },
        { .addr = 0x8a, .name = "TCCR3B", },
        { .addr = 0x8b, .name = "TCCR3A", },
        { .addr = 0x8c, .name = "TCCR3C", },
        { .addr = 0x90, .name = "UBRR0H", },
        { .addr = 0x95, .name = "UCSR0C", },
        { .addr = 0x98, .name = "UBRR1H", },
        { .addr = 0x99, .name = "UBRR1L", },
        { .addr = 0x9a, .name = "UCSR1B", },
        { .addr = 0x9b, .name = "UCSR1A", },
        { .addr = 0x9c, .name = "UDR1", },
        { .addr = 0x9d, .name = "UCSR1C", },
        IO_REG_DEFN_TERMINATOR
    }
};

/* *INDENT-ON* */
#endif /* IN_DEVSUPP_C */
