/* show the reading & writing of eeprom memory space
 * also show working interrupts after eeprom write finished in
 * mega devices 
 *
 * Status: in work
 */

#include <avr/eeprom.h>
#include <avr/signal.h>
#include <avr/io.h>

#ifndef SIG_COMPARATOR 
#error No comperator interrupt defined
#endif

volatile unsigned char compReady;

unsigned char results[0x5];
int irqCnt=0;


SIGNAL(SIG_COMPARATOR) {
    irqCnt++;
    compReady=0;
}

int main () {
    asm("sei");
    DDRD=0xff;
    PORTD=0x80;         //pin ain1 is high ain0 is low-> ACO must be low

    results[0]= ACSR;

    PORTD=0x40;         //change polarity ACO-> 1
    results[1]= ACSR;   //the port will be visible 1 step later!!!
    results[2]= ACSR;

    //now enable the irq
    compReady=1;
    ACSR|= (1<<ACIE) ;  //every toogle should result in an irq!
    PORTD=0x80;         //pin ain1 is high ain0 is low-> ACO must be low
    while (compReady==1); //wait until the irq is finished :-)
    results[3]= ACSR;   //now irq flag must be cleared

    return 0;
}




