/* show the reading & writing of eeprom memory space
 * also show working interrupts after eeprom write finished in
 * mega devices 
 *
 * Status: in work
 */

#include <avr/eeprom.h>
#include <avr/interrupt.h>
#include <avr/io.h>

#ifndef SIG_EEPROM_READY 
#error No eeprom interrupt 
#endif


unsigned char ee1 __attribute__ ((section (".myeeprom1" ) ));
unsigned char ee2 __attribute__ ((section (".myeeprom2" ) ));


unsigned char ee1=5;
unsigned char ee2=10;

volatile int x;
volatile int y;

volatile int ee_ready=1;

SIGNAL(SIG_EEPROM_READY) {
    ee_ready=0;
}

int main () {
    asm("sei");
    x = eeprom_read_byte(&ee1);
    y = eeprom_read_byte(&ee2);
    
    eeprom_write_byte(&ee1, 0x12);

    while(!eeprom_is_ready()); //wait until last eeprom operation has finished 

    EECR|=1<<EERIE;
    ee_ready=1;

    eeprom_write_byte(&ee2, 0x55);  //function wait on 

    while (ee_ready!=0) ;


    x= eeprom_read_byte( &ee1);
    y= eeprom_read_byte( &ee2);

    return 0;
}




