/* simple sample code, only to demonstrate multiple section loading in
 * sumulavr++. All sections must be visible from gdb and also the trace 
 * must show correct execution of software. The eeprom addresses must
 * be relocated well.
 *
 * Status: OK
 */

#include <avr/eeprom.h>


int fsec1(int a) __attribute__ (( section (".sec1" ) ));
int fsec2(int a) __attribute__ (( section (".sec2" ) )); 
int fsec3(int a) __attribute__ (( section (".sec3" ) )); 

int varInt0= 0x55;
int varInt1= 0x77;
int varInt2= 0x33;

unsigned char ee1 __attribute__ ((section (".myeeprom1" ) ));
unsigned char ee2 __attribute__ ((section (".myeeprom2" ) ));
unsigned char ee3 __attribute__ ((section (".myeeprom1" ) ));
unsigned char ee4 __attribute__ ((section (".myeeprom2" ) ));
unsigned char ee_base __attribute__ ((section (".eeprom" ) ));


unsigned char ee1=5;
unsigned char ee2=10;
unsigned char ee3=20;
unsigned char ee4=55;
unsigned char ee_base=0x77;



int fsec1(int a) {
    return a*10;
}

int fsec2(int a) {
    return a*2;
}

int fsec3(int a) {
    return a*3;
}

volatile int x;
volatile int y;
volatile int z;
volatile int zz;
volatile int zzz;

int main () {
    volatile int a;

    a=fsec1(varInt0);
    a=fsec2(varInt1);
    a=fsec3(varInt2);

    x = eeprom_read_byte(&ee1);
    y = eeprom_read_byte(&ee2);
    z = eeprom_read_byte(&ee3);
    zz = eeprom_read_byte(&ee4);
    zzz = eeprom_read_byte(&ee_base);

    return 0;

}




