/* show the reading & writing of eeprom memory space
 * also show working interrupts after eeprom write finished in
 * mega devices 
 *
 * Status: in work
 */

#include <avr/eeprom.h>
#include <avr/interrupt.h>
#include <avr/io.h>

#ifndef SIG_COMPARATOR 
#error No comperator interrupt defined
#endif

volatile unsigned char compReady;

/*
SIGNAL(SIG_COMPARATOR) {
compReady=0;
}
*/

int main () {
    asm("sei");

    DDRB=0x00;
    DDRD=0xff;

    unsigned char oldState;

    do {

        if (PINB & 0x01) {
            if (oldState!=1) {
                PORTD=0xff;
                oldState=1;
            }
        } else {
            if (oldState!=0) {
                PORTD=0x00;
                oldState=0;
            }
        }
    } while(1);


    return 0;
}




