#!/usr/bin/wish
#set traceFile trace

#we use some itcl :-)
package require Itcl

#load the avr-simulator package
load ../../src/simulavr.so
puts "simulavr loaded"

#now start external generic gui server 
exec wish ../../tests/gui.tcl &

#start the trace output to given filename
#StartTrace $traceFile

#start the user interface client 
set ui [new_UserInterface 7777 ]

#create new device
set dev1 [new_AvrDevice_atmega128]

#load elf file to the device 
AvrDevice_Load $dev1 "./timer.go"

#set the clock cycle time [ns]
AvrDevice_SetClockFreq $dev1 250

#systemclock must know that this device will be stepped from application
#$systemClock Add $dev1
#set sc [GetGlobalSystemClock]
set sc [SystemClock Instance]
$sc Add $dev1

#also the gui updates after each cycle
#$systemClock AddAsyncMember $ui
$sc AddAsyncMember $ui


#create some external pins
ExtPin pb5 $Pin_TRISTATE $ui "_PB5/OC1A" ".x"
ExtPin pb6 $Pin_TRISTATE $ui "_PB6/OC1B" ".x"
ExtPin pb7 $Pin_TRISTATE $ui "_PB7/OC1C" ".x"


#create some nets which connect the pins 
Net na
na Add pb5
na Add [AvrDevice_GetPin $dev1 "B5"]

Net nb
nb Add pb6
nb Add [AvrDevice_GetPin $dev1 "B6"]

Net nc
nc Add pb7
nc Add [AvrDevice_GetPin $dev1 "B7"]

$sc Endless


#exec xterm -e tail -f $traceFile &

 
