#include "io2.h"

.section .eeprom
EEPROM1:
.byte 0x10, 0x20, 0x02, 0x01
.text

.global start
VECTOR_TABLE:
	rjmp start
	rjmp Irq0
	rjmp Irq1
	reti		;1capt
	rjmp cmpa	;compa
	rjmp cmpb	;compb
	reti		;ovf1
	rjmp IrqTov0

cmpa:
	inc r19
	reti

cmpb:
	inc r20
	reti

Irq0:
	nop
	nop
	reti

Irq1:
	nop
	nop
	reti

IrqTov0:
	nop
	nop
	nop
	nop
	reti

start:
	ldi r30, 0xff
	ldi r31, 0xff
	adiw r30, 0x01

//Stack einrichten
	ldi r16, lo8(RAMEND-6)
	out SPL, r16 
	ldi r16, hi8(RAMEND-6)
	out SPH, r16 

//enable irq's 
    sei


//count a bit 
    ldi r16, 0x00

lcnt:
    inc r16
    brne lcnt
	rjmp eecheck

//now we want a irq on a pin (remember! this will fail if write a 1 to GIFR will reset the flag later
//this is only for testing here!!! 
;	ldi r16, 0x40 	//this is irq 0
;	out GIMSK, r16
;	out GIFR, r16	//now we should get the irq!!

	ldi r16, 0x03+0x0c	//rising edge for int0 / int1
	out MCUCR, r16	//rising edge
	ldi r16, 0xc0
	out GIFR, r16	//clear the old flags here (sense L)!
	ldi r16, 0xc0	//int 0 & 1 allowed
	out GIMSK, r16  //


//ldi r16, 0x60
//out TIMSK, r16	//OCRA+B freigeben


	ldi r16, 0xf0
	out DDRD, r16
	ldi r16, 0xff
	out PORTD, r16

x: rjmp x
	in r17, PIND
	in r18, PIND

	ldi r16, 0xff
	out DDRD, r16	


	ldi r16, 0x00
	out OCR1AH, r16
	out OCR1BH, r16
	ldi r16, 0x20
	out OCR1AL, r16
	ldi r16, 0x1a
	out OCR1BL, r16

	ldi r16, 0x50
	out TCCR1A, r16
	ldi r16, 0x09
	out TCCR1B, r16

	ldi r16, (1<<OCIE1A) | (1 <<OCIE1B)
	out TIMSK, r16

xxx: rjmp xxx




	nop
	nop
	nop
	nop
	nop
	nop
	nop
	ldi r16, 0xff
	out PORTD, r16
	nop
	nop
	nop
	nop
	nop


	ldi r16, 0x80 	//this is irq 1
	out GIMSK, r16
	out GIFR, r16	//now we should get the irq!!


//lass uns einen Timer0 testen :-)
	ldi r16, 0xf0
	out TCNT0, r16

	ldi r16, 0x01 ; no prescaler	no prescaler
	out TCCR0, r16 

	ldi r16, 0x02	; TOV0 freigeben 
	out TIMSK, r16

// nun koennen wir hpfen und pushen
	ldi r16, 0x00
	push r16

	ldi r16, 0x01
	push r16

	rcall uprog1

	pop r16
	pop r17


//now we test the eeprom space :-)
eecheck:
	ldi r16, 0x55
	out EEDR, r16
	ldi r16, 0x00
	out EEARH, r16
	ldi r16, 0x10
	out EEARL, r16

	ldi r16, 0x04	//write enable setzen
	out EECR, r16
	ldi r16, 0x02	//write start
	out EECR, r16

wait_eeprom:
	sbic EECR, EEWE
	rjmp wait_eeprom

	ldi r16, 0x20
	out EEARL, r16
	ldi r16, 0x01	; Read EEprom
	out EECR, r16
	in r8, EEDR		; Read Data

	ldi r16, 0x10	; Read again from allready used address
	out EEARL, r16
	ldi r16, 0x01	; Read EEprom
	out EECR, r16
	in r8, EEDR		; Read Data

	ldi r16, 0x00	; Read from space is inserted from eesection via gdb!
	out EEARL, r16
	ldi r16, 0x01	; Read EEprom
	out EECR, r16
	in r8, EEDR		; Read Data

	ldi r16, 0x01	; Read from space is inserted from eesection via gdb!
	out EEARL, r16
	ldi r16, 0x01	; Read EEprom
	out EECR, r16
	in r8, EEDR		; Read Data

	ldi r16, 0x02	; Read from space is inserted from eesection via gdb!
	out EEARL, r16
	ldi r16, 0x01	; Read EEprom
	out EECR, r16
	in r8, EEDR		; Read Data

	ldi r16, 0x03	; Read from space is inserted from eesection via gdb!
	out EEARL, r16
	ldi r16, 0x01	; Read EEprom
	out EECR, r16
	in r8, EEDR		; Read Data





	adc r16,r17

	ldi r16, 0x00
	cpi r16, 0x00

	in r17, SREG

	ldi r17, 0x00
	out SREG, r17

	ldi r16, 0x55
	out PORTA, r16

	ldi r16, 0xf0
	out DDRA, r16


	ldi r16, 0x55
	ldi r17, 0x10
	mov r0, 16

	ldi r18, 0x00
local1:
	inc r18
	cpi r18, 0x20
	brne local1


	out 0x0, r16
	out 0x01, r16
	out 0x02, r17
end_loop:
	rjmp end_loop

uprog1:
	ldi r18, 0x90
	ldi r19, 0x91
	ret	

/*
VectorTable:
	rjmp Reset

Reset:
	ldi r16, 0x00
	mov r17, r16
	ldi r18, hi8(RAMEND)
	out SPH, r18
	ldi r18, lo8(RAMEND)
	out SPL, r18

endless:
	rjmp endless
	*/	
