;;; color.scm -- Color management.
;;;
;;; Copyright 2006, 2007  Ludovic Courts  <ludo@gnu.org>
;;; Copyright 2003, 2004  Erick Gallesio - I3S-CNRS/ESSI <eg@essi.fr>
;;;
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
;;; USA.


(define-module (skribilo color)
  :use-module  (skribilo utils syntax)
  :autoload    (skribilo ast) (search-down)
  :autoload    (srfi srfi-1)  (append-map)
  :autoload    (srfi srfi-60) (bitwise-and arithmetic-shift)
  :export (color->rgb document-used-colors))

(fluid-set! current-reader %skribilo-module-reader)



(define %rgb-alist '(
   ("snow"			. #(255 250 250))
   ("ghostwhite"		. #(248 248 255))
   ("whitesmoke"		. #(245 245 245))
   ("gainsboro"			. #(220 220 220))
   ("floralwhite"		. #(255 250 240))
   ("oldlace"			. #(253 245 230))
   ("linen"			. #(250 240 230))
   ("antiquewhite"		. #(250 235 215))
   ("papayawhip"		. #(255 239 213))
   ("blanchedalmond"		. #(255 235 205))
   ("bisque"			. #(255 228 196))
   ("peachpuff"			. #(255 218 185))
   ("navajowhite"		. #(255 222 173))
   ("moccasin"			. #(255 228 181))
   ("cornsilk"			. #(255 248 220))
   ("ivory"			. #(255 255 240))
   ("lemonchiffon"		. #(255 250 205))
   ("seashell"			. #(255 245 238))
   ("honeydew"			. #(240 255 240))
   ("mintcream"			. #(245 255 250))
   ("azure"			. #(240 255 255))
   ("aliceblue"			. #(240 248 255))
   ("lavender"			. #(230 230 250))
   ("lavenderblush"		. #(255 240 245))
   ("mistyrose"			. #(255 228 225))
   ("white"			. #(255 255 255))
   ("black"			. #(0 0 0))
   ("darkslategrey"		. #(47 79 79))
   ("dimgrey"			. #(105 105 105))
   ("slategrey"			. #(112 128 144))
   ("lightslategrey"		. #(119 136 153))
   ("grey"			. #(190 190 190))
   ("lightgrey"			. #(211 211 211))
   ("midnightblue"		. #(25 25 112))
   ("navy"			. #(0 0 128))
   ("navyblue"			. #(0 0 128))
   ("cornflowerblue"		. #(100 149 237))
   ("darkslateblue"		. #(72 61 139))
   ("slateblue"			. #(106 90 205))
   ("mediumslateblue"		. #(123 104 238))
   ("lightslateblue"		. #(132 112 255))
   ("mediumblue"		. #(0 0 205))
   ("royalblue"			. #(65 105 225))
   ("blue"			. #(0 0 255))
   ("dodgerblue"		. #(30 144 255))
   ("deepskyblue"		. #(0 191 255))
   ("skyblue"			. #(135 206 235))
   ("lightskyblue"		. #(135 206 250))
   ("steelblue"			. #(70 130 180))
   ("lightsteelblue"		. #(176 196 222))
   ("lightblue"			. #(173 216 230))
   ("powderblue"		. #(176 224 230))
   ("paleturquoise"		. #(175 238 238))
   ("darkturquoise"		. #(0 206 209))
   ("mediumturquoise"		. #(72 209 204))
   ("turquoise"			. #(64 224 208))
   ("cyan"			. #(0 255 255))
   ("lightcyan"			. #(224 255 255))
   ("cadetblue"			. #(95 158 160))
   ("mediumaquamarine"		. #(102 205 170))
   ("aquamarine"		. #(127 255 212))
   ("darkgreen"			. #(0 100 0))
   ("darkolivegreen"		. #(85 107 47))
   ("darkseagreen"		. #(143 188 143))
   ("seagreen"			. #(46 139 87))
   ("mediumseagreen"		. #(60 179 113))
   ("lightseagreen"		. #(32 178 170))
   ("palegreen"			. #(152 251 152))
   ("springgreen"		. #(0 255 127))
   ("lawngreen"			. #(124 252 0))
   ("green"			. #(0 255 0))
   ("chartreuse"		. #(127 255 0))
   ("mediumspringgreen"		. #(0 250 154))
   ("greenyellow"		. #(173 255 47))
   ("limegreen"			. #(50 205 50))
   ("yellowgreen"		. #(154 205 50))
   ("forestgreen"		. #(34 139 34))
   ("olivedrab"			. #(107 142 35))
   ("darkkhaki"			. #(189 183 107))
   ("khaki"			. #(240 230 140))
   ("palegoldenrod"		. #(238 232 170))
   ("lightgoldenrodyellow"	. #(250 250 210))
   ("lightyellow"		. #(255 255 224))
   ("yellow"			. #(255 255 0))
   ("gold"			. #(255 215 0))
   ("lightgoldenrod"		. #(238 221 130))
   ("goldenrod"			. #(218 165 32))
   ("darkgoldenrod"		. #(184 134 11))
   ("rosybrown"			. #(188 143 143))
   ("indianred"			. #(205 92 92))
   ("saddlebrown"		. #(139 69 19))
   ("sienna"			. #(160 82 45))
   ("peru"			. #(205 133 63))
   ("burlywood"			. #(222 184 135))
   ("beige"			. #(245 245 220))
   ("wheat"			. #(245 222 179))
   ("sandybrown"		. #(244 164 96))
   ("tan"			. #(210 180 140))
   ("chocolate"			. #(210 105 30))
   ("firebrick"			. #(178 34 34))
   ("brown"			. #(165 42 42))
   ("darksalmon"		. #(233 150 122))
   ("salmon"			. #(250 128 114))
   ("lightsalmon"		. #(255 160 122))
   ("orange"			. #(255 165 0))
   ("darkorange"		. #(255 140 0))
   ("coral"			. #(255 127 80))
   ("lightcoral"		. #(240 128 128))
   ("tomato"			. #(255 99 71))
   ("orangered"			. #(255 69 0))
   ("red"			. #(255 0 0))
   ("hotpink"			. #(255 105 180))
   ("deeppink"			. #(255 20 147))
   ("pink"			. #(255 192 203))
   ("lightpink"			. #(255 182 193))
   ("palevioletred"		. #(219 112 147))
   ("maroon"			. #(176 48 96))
   ("mediumvioletred"		. #(199 21 133))
   ("violetred"			. #(208 32 144))
   ("magenta"			. #(255 0 255))
   ("violet"			. #(238 130 238))
   ("plum"			. #(221 160 221))
   ("orchid"			. #(218 112 214))
   ("mediumorchid"		. #(186 85 211))
   ("darkorchid"		. #(153 50 204))
   ("darkviolet"		. #(148 0 211))
   ("blueviolet"		. #(138 43 226))
   ("purple"			. #(160 32 240))
   ("mediumpurple"		. #(147 112 219))
   ("thistle"			. #(216 191 216))
   ("snow1"			. #(255 250 250))
   ("snow2"			. #(238 233 233))
   ("snow3"			. #(205 201 201))
   ("snow4"			. #(139 137 137))
   ("seashell1"			. #(255 245 238))
   ("seashell2"			. #(238 229 222))
   ("seashell3"			. #(205 197 191))
   ("seashell4"			. #(139 134 130))
   ("antiquewhite1"		. #(255 239 219))
   ("antiquewhite2"		. #(238 223 204))
   ("antiquewhite3"		. #(205 192 176))
   ("antiquewhite4"		. #(139 131 120))
   ("bisque1"			. #(255 228 196))
   ("bisque2"			. #(238 213 183))
   ("bisque3"			. #(205 183 158))
   ("bisque4"			. #(139 125 107))
   ("peachpuff1"		. #(255 218 185))
   ("peachpuff2"		. #(238 203 173))
   ("peachpuff3"		. #(205 175 149))
   ("peachpuff4"		. #(139 119 101))
   ("navajowhite1"		. #(255 222 173))
   ("navajowhite2"		. #(238 207 161))
   ("navajowhite3"		. #(205 179 139))
   ("navajowhite4"		. #(139 121 94))
   ("lemonchiffon1"		. #(255 250 205))
   ("lemonchiffon2"		. #(238 233 191))
   ("lemonchiffon3"		. #(205 201 165))
   ("lemonchiffon4"		. #(139 137 112))
   ("cornsilk1"			. #(255 248 220))
   ("cornsilk2"			. #(238 232 205))
   ("cornsilk3"			. #(205 200 177))
   ("cornsilk4"			. #(139 136 120))
   ("ivory1"			. #(255 255 240))
   ("ivory2"			. #(238 238 224))
   ("ivory3"			. #(205 205 193))
   ("ivory4"			. #(139 139 131))
   ("honeydew1"			. #(240 255 240))
   ("honeydew2"			. #(224 238 224))
   ("honeydew3"			. #(193 205 193))
   ("honeydew4"			. #(131 139 131))
   ("lavenderblush1"		. #(255 240 245))
   ("lavenderblush2"		. #(238 224 229))
   ("lavenderblush3"		. #(205 193 197))
   ("lavenderblush4"		. #(139 131 134))
   ("mistyrose1"		. #(255 228 225))
   ("mistyrose2"		. #(238 213 210))
   ("mistyrose3"		. #(205 183 181))
   ("mistyrose4"		. #(139 125 123))
   ("azure1"			. #(240 255 255))
   ("azure2"			. #(224 238 238))
   ("azure3"			. #(193 205 205))
   ("azure4"			. #(131 139 139))
   ("slateblue1"		. #(131 111 255))
   ("slateblue2"		. #(122 103 238))
   ("slateblue3"		. #(105 89 205))
   ("slateblue4"		. #(71 60 139))
   ("royalblue1"		. #(72 118 255))
   ("royalblue2"		. #(67 110 238))
   ("royalblue3"		. #(58 95 205))
   ("royalblue4"		. #(39 64 139))
   ("blue1"			. #(0 0 255))
   ("blue2"			. #(0 0 238))
   ("blue3"			. #(0 0 205))
   ("blue4"			. #(0 0 139))
   ("dodgerblue1"		. #(30 144 255))
   ("dodgerblue2"		. #(28 134 238))
   ("dodgerblue3"		. #(24 116 205))
   ("dodgerblue4"		. #(16 78 139))
   ("steelblue1"		. #(99 184 255))
   ("steelblue2"		. #(92 172 238))
   ("steelblue3"		. #(79 148 205))
   ("steelblue4"		. #(54 100 139))
   ("deepskyblue1"		. #(0 191 255))
   ("deepskyblue2"		. #(0 178 238))
   ("deepskyblue3"		. #(0 154 205))
   ("deepskyblue4"		. #(0 104 139))
   ("skyblue1"			. #(135 206 255))
   ("skyblue2"			. #(126 192 238))
   ("skyblue3"			. #(108 166 205))
   ("skyblue4"			. #(74 112 139))
   ("lightskyblue1"		. #(176 226 255))
   ("lightskyblue2"		. #(164 211 238))
   ("lightskyblue3"		. #(141 182 205))
   ("lightskyblue4"		. #(96 123 139))
   ("lightsteelblue1"		. #(202 225 255))
   ("lightsteelblue2"		. #(188 210 238))
   ("lightsteelblue3"		. #(162 181 205))
   ("lightsteelblue4"		. #(110 123 139))
   ("lightblue1"		. #(191 239 255))
   ("lightblue2"		. #(178 223 238))
   ("lightblue3"		. #(154 192 205))
   ("lightblue4"		. #(104 131 139))
   ("lightcyan1"		. #(224 255 255))
   ("lightcyan2"		. #(209 238 238))
   ("lightcyan3"		. #(180 205 205))
   ("lightcyan4"		. #(122 139 139))
   ("paleturquoise1"		. #(187 255 255))
   ("paleturquoise2"		. #(174 238 238))
   ("paleturquoise3"		. #(150 205 205))
   ("paleturquoise4"		. #(102 139 139))
   ("cadetblue1"		. #(152 245 255))
   ("cadetblue2"		. #(142 229 238))
   ("cadetblue3"		. #(122 197 205))
   ("cadetblue4"		. #(83 134 139))
   ("turquoise1"		. #(0 245 255))
   ("turquoise2"		. #(0 229 238))
   ("turquoise3"		. #(0 197 205))
   ("turquoise4"		. #(0 134 139))
   ("cyan1"			. #(0 255 255))
   ("cyan2"			. #(0 238 238))
   ("cyan3"			. #(0 205 205))
   ("cyan4"			. #(0 139 139))
   ("aquamarine1"		. #(127 255 212))
   ("aquamarine2"		. #(118 238 198))
   ("aquamarine3"		. #(102 205 170))
   ("aquamarine4"		. #(69 139 116))
   ("darkseagreen1"		. #(193 255 193))
   ("darkseagreen2"		. #(180 238 180))
   ("darkseagreen3"		. #(155 205 155))
   ("darkseagreen4"		. #(105 139 105))
   ("seagreen1"			. #(84 255 159))
   ("seagreen2"			. #(78 238 148))
   ("seagreen3"			. #(67 205 128))
   ("seagreen4"			. #(46 139 87))
   ("palegreen1"		. #(154 255 154))
   ("palegreen2"		. #(144 238 144))
   ("palegreen3"		. #(124 205 124))
   ("palegreen4"		. #(84 139 84))
   ("springgreen1"		. #(0 255 127))
   ("springgreen2"		. #(0 238 118))
   ("springgreen3"		. #(0 205 102))
   ("springgreen4"		. #(0 139 69))
   ("green1"			. #(0 255 0))
   ("green2"			. #(0 238 0))
   ("green3"			. #(0 205 0))
   ("green4"			. #(0 139 0))
   ("chartreuse1"		. #(127 255 0))
   ("chartreuse2"		. #(118 238 0))
   ("chartreuse3"		. #(102 205 0))
   ("chartreuse4"		. #(69 139 0))
   ("olivedrab1"		. #(192 255 62))
   ("olivedrab2"		. #(179 238 58))
   ("olivedrab3"		. #(154 205 50))
   ("olivedrab4"		. #(105 139 34))
   ("darkolivegreen1"		. #(202 255 112))
   ("darkolivegreen2"		. #(188 238 104))
   ("darkolivegreen3"		. #(162 205 90))
   ("darkolivegreen4"		. #(110 139 61))
   ("khaki1"			. #(255 246 143))
   ("khaki2"			. #(238 230 133))
   ("khaki3"			. #(205 198 115))
   ("khaki4"			. #(139 134 78))
   ("lightgoldenrod1"		. #(255 236 139))
   ("lightgoldenrod2"		. #(238 220 130))
   ("lightgoldenrod3"		. #(205 190 112))
   ("lightgoldenrod4"		. #(139 129 76))
   ("lightyellow1"		. #(255 255 224))
   ("lightyellow2"		. #(238 238 209))
   ("lightyellow3"		. #(205 205 180))
   ("lightyellow4"		. #(139 139 122))
   ("yellow1"			. #(255 255 0))
   ("yellow2"			. #(238 238 0))
   ("yellow3"			. #(205 205 0))
   ("yellow4"			. #(139 139 0))
   ("gold1"			. #(255 215 0))
   ("gold2"			. #(238 201 0))
   ("gold3"			. #(205 173 0))
   ("gold4"			. #(139 117 0))
   ("goldenrod1"		. #(255 193 37))
   ("goldenrod2"		. #(238 180 34))
   ("goldenrod3"		. #(205 155 29))
   ("goldenrod4"		. #(139 105 20))
   ("darkgoldenrod1"		. #(255 185 15))
   ("darkgoldenrod2"		. #(238 173 14))
   ("darkgoldenrod3"		. #(205 149 12))
   ("darkgoldenrod4"		. #(139 101 8))
   ("rosybrown1"		. #(255 193 193))
   ("rosybrown2"		. #(238 180 180))
   ("rosybrown3"		. #(205 155 155))
   ("rosybrown4"		. #(139 105 105))
   ("indianred1"		. #(255 106 106))
   ("indianred2"		. #(238 99 99))
   ("indianred3"		. #(205 85 85))
   ("indianred4"		. #(139 58 58))
   ("sienna1"			. #(255 130 71))
   ("sienna2"			. #(238 121 66))
   ("sienna3"			. #(205 104 57))
   ("sienna4"			. #(139 71 38))
   ("burlywood1"		. #(255 211 155))
   ("burlywood2"		. #(238 197 145))
   ("burlywood3"		. #(205 170 125))
   ("burlywood4"		. #(139 115 85))
   ("wheat1"			. #(255 231 186))
   ("wheat2"			. #(238 216 174))
   ("wheat3"			. #(205 186 150))
   ("wheat4"			. #(139 126 102))
   ("tan1"			. #(255 165 79))
   ("tan2"			. #(238 154 73))
   ("tan3"			. #(205 133 63))
   ("tan4"			. #(139 90 43))
   ("chocolate1"		. #(255 127 36))
   ("chocolate2"		. #(238 118 33))
   ("chocolate3"		. #(205 102 29))
   ("chocolate4"		. #(139 69 19))
   ("firebrick1"		. #(255 48 48))
   ("firebrick2"		. #(238 44 44))
   ("firebrick3"		. #(205 38 38))
   ("firebrick4"		. #(139 26 26))
   ("brown1"			. #(255 64 64))
   ("brown2"			. #(238 59 59))
   ("brown3"			. #(205 51 51))
   ("brown4"			. #(139 35 35))
   ("salmon1"			. #(255 140 105))
   ("salmon2"			. #(238 130 98))
   ("salmon3"			. #(205 112 84))
   ("salmon4"			. #(139 76 57))
   ("lightsalmon1"		. #(255 160 122))
   ("lightsalmon2"		. #(238 149 114))
   ("lightsalmon3"		. #(205 129 98))
   ("lightsalmon4"		. #(139 87 66))
   ("orange1"			. #(255 165 0))
   ("orange2"			. #(238 154 0))
   ("orange3"			. #(205 133 0))
   ("orange4"			. #(139 90 0))
   ("darkorange1"		. #(255 127 0))
   ("darkorange2"		. #(238 118 0))
   ("darkorange3"		. #(205 102 0))
   ("darkorange4"		. #(139 69 0))
   ("coral1"			. #(255 114 86))
   ("coral2"			. #(238 106 80))
   ("coral3"			. #(205 91 69))
   ("coral4"			. #(139 62 47))
   ("tomato1"			. #(255 99 71))
   ("tomato2"			. #(238 92 66))
   ("tomato3"			. #(205 79 57))
   ("tomato4"			. #(139 54 38))
   ("orangered1"		. #(255 69 0))
   ("orangered2"		. #(238 64 0))
   ("orangered3"		. #(205 55 0))
   ("orangered4"		. #(139 37 0))
   ("red1"			. #(255 0 0))
   ("red2"			. #(238 0 0))
   ("red3"			. #(205 0 0))
   ("red4"			. #(139 0 0))
   ("deeppink1"			. #(255 20 147))
   ("deeppink2"			. #(238 18 137))
   ("deeppink3"			. #(205 16 118))
   ("deeppink4"			. #(139 10 80))
   ("hotpink1"			. #(255 110 180))
   ("hotpink2"			. #(238 106 167))
   ("hotpink3"			. #(205 96 144))
   ("hotpink4"			. #(139 58 98))
   ("pink1"			. #(255 181 197))
   ("pink2"			. #(238 169 184))
   ("pink3"			. #(205 145 158))
   ("pink4"			. #(139 99 108))
   ("lightpink1"		. #(255 174 185))
   ("lightpink2"		. #(238 162 173))
   ("lightpink3"		. #(205 140 149))
   ("lightpink4"		. #(139 95 101))
   ("palevioletred1"		. #(255 130 171))
   ("palevioletred2"		. #(238 121 159))
   ("palevioletred3"		. #(205 104 137))
   ("palevioletred4"		. #(139 71 93))
   ("maroon1"			. #(255 52 179))
   ("maroon2"			. #(238 48 167))
   ("maroon3"			. #(205 41 144))
   ("maroon4"			. #(139 28 98))
   ("violetred1"		. #(255 62 150))
   ("violetred2"		. #(238 58 140))
   ("violetred3"		. #(205 50 120))
   ("violetred4"		. #(139 34 82))
   ("magenta1"			. #(255 0 255))
   ("magenta2"			. #(238 0 238))
   ("magenta3"			. #(205 0 205))
   ("magenta4"			. #(139 0 139))
   ("orchid1"			. #(255 131 250))
   ("orchid2"			. #(238 122 233))
   ("orchid3"			. #(205 105 201))
   ("orchid4"			. #(139 71 137))
   ("plum1"			. #(255 187 255))
   ("plum2"			. #(238 174 238))
   ("plum3"			. #(205 150 205))
   ("plum4"			. #(139 102 139))
   ("mediumorchid1"		. #(224 102 255))
   ("mediumorchid2"		. #(209 95 238))
   ("mediumorchid3"		. #(180 82 205))
   ("mediumorchid4"		. #(122 55 139))
   ("darkorchid1"		. #(191 62 255))
   ("darkorchid2"		. #(178 58 238))
   ("darkorchid3"		. #(154 50 205))
   ("darkorchid4"		. #(104 34 139))
   ("purple1"			. #(155 48 255))
   ("purple2"			. #(145 44 238))
   ("purple3"			. #(125 38 205))
   ("purple4"			. #(85 26 139))
   ("mediumpurple1"		. #(171 130 255))
   ("mediumpurple2"		. #(159 121 238))
   ("mediumpurple3"		. #(137 104 205))
   ("mediumpurple4"		. #(93 71 139))
   ("thistle1"			. #(255 225 255))
   ("thistle2"			. #(238 210 238))
   ("thistle3"			. #(205 181 205))
   ("thistle4"			. #(139 123 139))
   ("grey0"			. #(0 0 0))
   ("grey1"			. #(3 3 3))
   ("grey2"			. #(5 5 5))
   ("grey3"			. #(8 8 8))
   ("grey4"			. #(10 10 10))
   ("grey5"			. #(13 13 13))
   ("grey6"			. #(15 15 15))
   ("grey7"			. #(18 18 18))
   ("grey8"			. #(20 20 20))
   ("grey9"			. #(23 23 23))
   ("grey10"			. #(26 26 26))
   ("grey11"			. #(28 28 28))
   ("grey12"			. #(31 31 31))
   ("grey13"			. #(33 33 33))
   ("grey14"			. #(36 36 36))
   ("grey15"			. #(38 38 38))
   ("grey16"			. #(41 41 41))
   ("grey17"			. #(43 43 43))
   ("grey18"			. #(46 46 46))
   ("grey19"			. #(48 48 48))
   ("grey20"			. #(51 51 51))
   ("grey21"			. #(54 54 54))
   ("grey22"			. #(56 56 56))
   ("grey23"			. #(59 59 59))
   ("grey24"			. #(61 61 61))
   ("grey25"			. #(64 64 64))
   ("grey26"			. #(66 66 66))
   ("grey27"			. #(69 69 69))
   ("grey28"			. #(71 71 71))
   ("grey29"			. #(74 74 74))
   ("grey30"			. #(77 77 77))
   ("grey31"			. #(79 79 79))
   ("grey32"			. #(82 82 82))
   ("grey33"			. #(84 84 84))
   ("grey34"			. #(87 87 87))
   ("grey35"			. #(89 89 89))
   ("grey36"			. #(92 92 92))
   ("grey37"			. #(94 94 94))
   ("grey38"			. #(97 97 97))
   ("grey39"			. #(99 99 99))
   ("grey40"			. #(102 102 102))
   ("grey41"			. #(105 105 105))
   ("grey42"			. #(107 107 107))
   ("grey43"			. #(110 110 110))
   ("grey44"			. #(112 112 112))
   ("grey45"			. #(115 115 115))
   ("grey46"			. #(117 117 117))
   ("grey47"			. #(120 120 120))
   ("grey48"			. #(122 122 122))
   ("grey49"			. #(125 125 125))
   ("grey50"			. #(127 127 127))
   ("grey51"			. #(130 130 130))
   ("grey52"			. #(133 133 133))
   ("grey53"			. #(135 135 135))
   ("grey54"			. #(138 138 138))
   ("grey55"			. #(140 140 140))
   ("grey56"			. #(143 143 143))
   ("grey57"			. #(145 145 145))
   ("grey58"			. #(148 148 148))
   ("grey59"			. #(150 150 150))
   ("grey60"			. #(153 153 153))
   ("grey61"			. #(156 156 156))
   ("grey62"			. #(158 158 158))
   ("grey63"			. #(161 161 161))
   ("grey64"			. #(163 163 163))
   ("grey65"			. #(166 166 166))
   ("grey66"			. #(168 168 168))
   ("grey67"			. #(171 171 171))
   ("grey68"			. #(173 173 173))
   ("grey69"			. #(176 176 176))
   ("grey70"			. #(179 179 179))
   ("grey71"			. #(181 181 181))
   ("grey72"			. #(184 184 184))
   ("grey73"			. #(186 186 186))
   ("grey74"			. #(189 189 189))
   ("grey75"			. #(191 191 191))
   ("grey76"			. #(194 194 194))
   ("grey77"			. #(196 196 196))
   ("grey78"			. #(199 199 199))
   ("grey79"			. #(201 201 201))
   ("grey80"			. #(204 204 204))
   ("grey81"			. #(207 207 207))
   ("grey82"			. #(209 209 209))
   ("grey83"			. #(212 212 212))
   ("grey84"			. #(214 214 214))
   ("grey85"			. #(217 217 217))
   ("grey86"			. #(219 219 219))
   ("grey87"			. #(222 222 222))
   ("grey88"			. #(224 224 224))
   ("grey89"			. #(227 227 227))
   ("grey90"			. #(229 229 229))
   ("grey91"			. #(232 232 232))
   ("grey92"			. #(235 235 235))
   ("grey93"			. #(237 237 237))
   ("grey94"			. #(240 240 240))
   ("grey95"			. #(242 242 242))
   ("grey96"			. #(245 245 245))
   ("grey97"			. #(247 247 247))
   ("grey98"			. #(250 250 250))
   ("grey99"			. #(252 252 252))
   ("grey100"			. #(255 255 255))
   ("darkgrey"			. #(169 169 169))
   ("darkblue"			. #(0 0 139))
   ("darkcyan"			. #(0 139 139))
   ("darkmagenta"		. #(139 0 139))
   ("darkred"			. #(139 0 0))
   ("lightgreen"		. #(144 238 144))
   ("lightred"			. #(255 127 127))))


(define (%convert-color str)
  (let ((col (assoc str %rgb-alist)))
    (cond
      (col
       (let ((r (vector-ref (cdr col) 0))
             (g (vector-ref (cdr col) 1))
             (b (vector-ref (cdr col) 2)))
	 (values r g b)))
      ((and (string? str) (eq? (string-ref str 0) #\#) (= (string-length str) 7))
       (values (string->number (substring str 1 3) 16)
	       (string->number (substring str 3 5) 16)
	       (string->number (substring str 5 7) 16)))
      ((and (string? str) (eq? (string-ref str 0) #\#) (= (string-length str) 13))
       (values (string->number (substring str 1 5) 16)
	       (string->number (substring str 5 9) 16)
	       (string->number (substring str 9 13) 16)))
      (else
       (values 0 0 0)))))

;;;
;;; COLOR->RGB
;;;
(define (color->rgb spec)
  (cond
    ((string? spec) (%convert-color spec))
    ((integer? spec)
       (values (bitwise-and #xff (arithmetic-shift spec -16))
	       (bitwise-and #xff (arithmetic-shift spec -8))
	       (bitwise-and #xff spec)))
    (else
     (values 0 0 0))))

;;;
;;; DOCUMENT-USED-COLORS
;;;
(define (document-used-colors doc)
  ;; Return the list of colors used by DOC, a document.
  (define colored-nodes
    (search-down (lambda (n)
                   ;; The only standard markups known to deal with colors.
                   (or (is-markup? n 'color)
                       (is-markup? n 'tr)))
                 doc))

  (append-map (lambda (n)
                (let ((fg (markup-option n :fg))
                      (bg (markup-option n :bg)))
                  (cond ((and bg fg) (list bg fg))
                        (fg          (list fg))
                        (bg          (list bg))
                        (else        '()))))
              colored-nodes))

