/*+----------------------------------------------------------------------------+
  |                                                                            |
  |                       Entiers de longueur arbitraire                       |
  |                                                                            |
  |                            Macros assembleur x86                           |
  |                                                                            |
  +----------------------------------------------------------------------------+*/

/* M. Quercia, 26/08/2001 */

#include "../kernel/long_int-s.h"

#ifdef BSD_ASSEMBLER
#define ALIGN(x)
#define SUBR(x)  _##x
#define CALL(x)  call _##x
#else
#define ALIGN(x) .align x
#define SUBR(x)  x
#define CALL(x)  call x
#endif

/* entre et retour de fonction */
#define  ENTER(nom)                \
        .align 4                  ;\
        .globl SUBR(nom)          ;\
        .type  SUBR(nom),@function;\
SUBR(nom):                        ;\
        pushl  %ebp               ;\
        movl   %esp,%ebp          ;\
        pushl  %edi               ;\
        pushl  %esi               ;\
        pushl  %ebx

#define  RETURN                    \
        movl   -12(%ebp),%ebx     ;\
        movl    -8(%ebp),%esi     ;\
        movl    -4(%ebp),%edi     ;\
        movl   %ebp,%esp          ;\
        popl   %ebp               ;\
        ret

#define  EXIT(nom)                 \
.L##nom##_exit:                   ;\
RETURN

#define SIGN_m 0x80000000
#define LONG_m 0x7fffffff

/* accs aux paramtres d'appel */
#define a       8(%ebp)
#define la     12(%ebp)
#define b      16(%ebp)
#define lb     20(%ebp)
#define c      24(%ebp)
#define d      28(%ebp)

#define za      8(%ebp)
#define zb     12(%ebp)
#define zc     16(%ebp)
#define zd     20(%ebp)

#define arg1    8(%ebp)
#define arg2   12(%ebp)
#define arg3   16(%ebp)
#define arg4   20(%ebp)
#define arg5   24(%ebp)
#define arg6   28(%ebp)
#define arg7   32(%ebp)
#define arg8   36(%ebp)

/* limite entre Karatsuba et la multiplication ordinaire */
/* trop compliqu de faire prendre en compte la valeur   */
/* dfinie dans long_int.h, elle est recopie ici ...    */
/* attention aux mises  jour!                           */
#define klim  32
#define kprof 31

/* multiplication par FFt  partir de 30000 bits */
#define flim  937
