(************************************************************************)
(* This file is part of SKS.  SKS is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA *)
(***********************************************************************)

type seed = [ `SelfSeed | `IntSeed of int | `ArraySeed of int array]
module Make :
  functor (Seed : sig val seed : seed end) ->
    sig
      type state	
      val state : int array
      val bits : unit -> int
      val int : int -> int
      val float : float -> float
      val init : int -> unit
      val full_init : int array -> unit
      val self_init : unit -> unit
      val get_state : unit -> state
      val set_state : state -> unit
    end
