/*
   This file is part of Numerix.  Numerix is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA 
*/

/* +------------------------------------------------------------------------+
   |                                                                        |
   |                      Entiers de longueur arbitraire                    |
   |                                                                        |
   |                         Fonctions utilitaires                          |
   |                                                                        |
   +------------------------------------------------------------------------+ */


/* M. Quercia, 31/01/2001 */

#include "long_int.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/* erreur fatale */
void xn(fatal_err)(char *msg) {
  fprintf(stderr,msg);
  fflush(stderr);
  exit(1);
}

/* allocation/dsallocation */
naturel xn(alloc_tmp)(longueur l) {
  naturel a = malloc(l*sizeof(chiffre));
  if (a == NULL) xn(fatal_err)("\nout of memory\n");
  return(a);
}

entier *xz(alloc_tmp)(longueur l) {
  entier *a = malloc(l*sizeof(chiffre)+sizeof(longueur));
  if (a == NULL) xn(fatal_err)("\nout of memory\n");
  return(a);
}

/* dboguage */
void xn(dump)(naturel a, longueur la) {
  longueur i;
  fprintf(stderr,"[%ld]",la);
  for (i=la-1; (i>=0) && (i>la-200); i--)
#ifdef bits_32
#ifdef use_dlong
    fprintf(stderr,"%08lX", a[i]);
#else
    fprintf(stderr,"%04X", a[i]);
#endif
#else
    fprintf(stderr,"%08X", a[i]);
#endif
  if (la >= 200) fprintf(stderr," ...");
  fprintf(stderr,"\n");
  fflush(stderr);
}

void xz(dump)(entier *a) {
  longueur la = Lg(a), sa = Signe(a);
  fprintf(stderr,(sa) ? "-" : "+") ;
  xn(dump)(a->val,la);
}

void xn(message)(char *msg, long n, long *reg) {
  long i;
  fprintf(stderr,"%s", msg);
  for (i=0; i<n; i++) fprintf(stderr," %08lX", reg[i]);
  fprintf(stderr,"\n");
  fflush(stderr);
}

