/*
 *   $Id: AudibleElem.h,v 1.6 2006/04/14 00:12:09 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef AUDIBLE_ELEM_H
#define AUDIBLE_ELEM_H

#include <qobject.h>

#include "../common.h"
#include "SafeData.h"

/// Abstract class for audible elements
///
/// It defines an interface (and a default implementation for things that have 
/// a volume and can be muted and unmuted.
///

class AudibleElem : public QObject {
    Q_OBJECT
protected:
    SafeData<bool> active;
    sample_t volume;
    AudibleElem() : volume(1) {};
    virtual ~AudibleElem();
public:
    inline void mute() { 
        active.setValue(0); 
        emit modified();
    }
    inline void unmute() { 
        active.setValue(1); 
        emit modified();
    }
    inline bool isActive() { return active.getValue(); }
public slots:
    inline void setVolume(int vol) { 
        emit volumeChanged(vol);
        emit modified();
        volume = (sample_t)vol / 100;
    }
    inline sample_t getVolume() { return volume; }
    inline int getVolumePercent() { return static_cast<int>(volume * 100); }
    inline void setActive(bool val) { 
	active.setValue(val); 
        emit modified();
	emit activeStateChanged(val); 
    }
signals:
    void activeStateChanged(bool);
    void volumeChanged(int);
    void modified();
};

#endif

//EOF
