/*
 *   $Id: PatternWidget.cpp,v 1.46 2006/04/03 19:42:06 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qlayout.h>

#include "../Slag.h"
#include "../audio_engine/Pattern.h"
#include "../audio_engine/Channel.h"
#include "PatternWidget.h"
#include "PatternRow.h"
#include "RowContext.h"

PatternWidget::PatternWidget(QWidget* parent, Song* song, Pattern* pattern) 
    : RowSet(parent, song),
      _pattern(pattern)
{}

PatternWidget::~PatternWidget() {
    qDebug("destruction pattern widget"); 
}

void PatternWidget::activate(QWidget* row, Channel* channel) {
    if ( _pattern->channels_parts[channel] != NULL ) 
        ((PatternRow*)row)->activate();
}

QWidget* PatternWidget::createRow(Channel* channel) {
    return new PatternRow(this, song, new RowContext(channel, _pattern));
}

//EOF
