/*
 *   $Id: WavFileDriver.cpp,v 1.2 2006/01/03 06:24:28 rhizome Exp $
 *
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "WavFileDriver.h"

WavFileDriver::WavFileDriver(char* filename, process_callback processCallback, const int buf_size) 
    : audio_buffer(new sample_t[buf_size]),
      filename(filename),
      active(0)
{
    sf_info.format = SF_FORMAT_WAV | SF_FORMAT_PCM_16;
    sf_info.samplerate = 44100;
    sf_info.channels = 2;

    // TODO faire un close du fichier quelque part
    if(! (wav_file = sf_open(filename, SFM_WRITE, &sf_info)) ) {
        cout << "impossible d'ouvrir " << filename << " en criture" << endl;
        cout << sf_strerror(wav_file) << endl;
        abort();
    }

    buffer_size = buf_size;
    audioProcessCallback = processCallback;
}

WavFileDriver::~WavFileDriver() {
    delete[] audio_buffer;
}

void WavFileDriver::run() {
    while (active) {
	audioProcessCallback(audio_buffer);

        // Ecrire dans le fichier
        sf_write_float(wav_file, audio_buffer, buffer_size) ;
    }
}

void WavFileDriver::connect() {
    active = 1;
    start(QThread::HighPriority);
}

void WavFileDriver::disconnect() {
    active = 0;
}

//EOF
