/*
 *   $Id: PartMenu.h,v 1.5 2006/02/17 16:40:55 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PART_MENU_H
#define PART_MENU_H

#include <qpopupmenu.h>

class Song;
class Part;
class Channel;
class Pattern;
class PartListMenu;
class PartEditMenu;
class RowContext;

class PartMenu : public QPopupMenu {
    Q_OBJECT
public:
    PartMenu(QWidget*, Song*, RowContext*);
    ~PartMenu();
public slots:
    void addPart(Part*);
    void partDeleted(Part*);
signals:
    void partChanged(Part*);
    void partAdded(Part*);
    void renamed(const QString &);
private slots:
    void partChosen(int);
    void createBlank();
    void createFromExisting(int);
    void deletePart();
    void renamePart();
private:
    bool askForPartName(QString&);
    void updateEditMenu();
    void setPart(Part*);

    Song* song;
    Channel* channel;
    Pattern* pattern;
    Part* previous_part;
    Part* current_part;
    PartListMenu* choice_menu;
    PartListMenu* create_from_menu;
    PartEditMenu* edit_menu;
    int editItemId;
    int renameItemId;
    int deleteItemId;
};

typedef QPair<QString, QString> EditFeature;
typedef QPtrList<EditFeature> EditFeatureList;

class PartListMenu : public QPopupMenu {
    Q_OBJECT
public:
    PartListMenu(QPtrList<Part>*);
    Part* getPartById(int);
    void addPart(Part*);
public slots:
    void partRenamed(Part*);
    void partDeleted(Part*);
private:
    int getIdByPart(Part*);

    QPtrList<Part>* song_parts;/// referred parts
    QMap<int, Part*> part_map;/// menu item ids and parts pointers association
};

class PartEditMenu : public QPopupMenu {
    Q_OBJECT
public:
    PartEditMenu(Part*);
    void appendItems();
    void setPart(Part*);
private:
    Part* part;
    EditFeatureList features;
    QValueList<int> item_ids;
};
    

#endif

//EOF
