/*
 *   $Id: PatternRow.h,v 1.5 2006/03/28 01:09:07 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PATTERN_ROW_H
#define PATTERN_ROW_H

#include <qwidget.h>

class QLabel;
class QCheckBox;
class QPushButton;
class QBoxLayout;

class Song;
class Channel;
class Pattern;
class Part;
class ChannelMenu;
class PartMenu;
class NamedButton;
class RowContext;

class PatternRow : public QWidget {
    Q_OBJECT
private:
    std::auto_ptr<RowContext> row_context;
    Channel* channel;
    Pattern* pattern;
    QLabel* current_part_label;
    QPtrList<QPushButton> buttons;
    QBoxLayout* layout;
    QPushButton* new_part_button;
    PartMenu* part_menu; 
    QPushButton* part_but;
    Song* song;
public:
    PatternRow(QWidget* parent, Song*, RowContext*);
    ~PatternRow();
    void clearConnections();
public slots:
    void activate();
    void handlePartChanged(Part*);
    void handlePartRenamed(Part*);
    void handleFileChanged();
    void popup_part_menu();
    void deactivate(Part*);
};

#endif

//EOF
