/*
 *   $Id: RowSet.cpp,v 1.10 2006/04/08 23:39:15 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qpainter.h>
#include <assert.h>

#include "../Slag.h"
#include "../audio_engine/Channel.h"
#include "../audio_engine/Song.h"

#include "RowSet.h"

RowSet::RowSet(QWidget* parent, Song* song)
    : QWidget(parent),
      song(song),
      layout(new VBoxLayout(this, 3, 5))
{
    qDebug("connection addChannel");
    connect(song, SIGNAL(channelAdded(Channel*)),
            this,       SLOT(addChannel(Channel*)));
}

void RowSet::setSong(Song* s) {
    song = s;
    connect(song, SIGNAL(channelAdded(Channel*)),
            this,   SLOT(addChannel(Channel*)));
}

void RowSet::populate() {
    QPtrList<Channel>::iterator channels_end = song->channels().end();
    for(QPtrList<Channel>::iterator chan_it = song->channels().begin(); 
                chan_it != channels_end; ++chan_it) {
        addChannel(*chan_it);
    }
    layout->addStretch();
}

void RowSet::addChannel(Channel* channel) {
    assert(channel != NULL);
    QWidget* row = createRow(channel);

    chan_row_map[channel] = row;

    layout->insertWidget(rows.count(), row);

    rows.append(row);

    activate(row, channel);

    row->show();

}

void RowSet::clear() {
    rows.clear();
    chan_row_map.clear();
    layout->clear();
}

void RowSet::deleteChannel(Channel* channel) {
    layout->remove(chan_row_map[channel]);
    rows.remove(chan_row_map[channel]);
    if (chan_row_map.contains(channel)) {
        delete chan_row_map[channel];
        chan_row_map.remove(channel);
    }
}

void RowSet::syncChannelPosition(Channel* channel) {
    QWidget* row = chan_row_map[channel];

    layout->remove(row);
    layout->insertWidget(channel->rowIndex(), row);
}

//EOF
