-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

blueprint.headangle = math.rad(24)   -- Steering head angle
blueprint.steeringtravel = 1.0122    -- Steeing angle range.
blueprint.steeringdamping = 9.944

blueprint.points = {
   {0.705, 0, 0},         -- Aerodynamic reference point, p_1
   {1.173, 0, 0.7488},    -- Twist axis joint with main frame, p_2
   {1.164, 0, 0.7698},    -- Centre of mass of front frame steer body, p_3
   {1.365, 0, 0.324},     -- Centre of mass of front frame suspension body, p_5
   {1.41, 0, 0.282},      -- Front wheel attachment point, p_6
   {0, 0, 0.297},         -- Rear wheel attachment point, p_7
   {0.6779, 0, 0.4724},   -- Centre of mass of the main frame, p_8
   {0.364, 0, 0.8438},    -- Attachment point for rider on main frame, p_9
   {0.415, 0, 1.14},      -- Rider centre of mass, p_10
   {0.549, 0, 0.3608},    -- Point of attachment for swinging arm onto main frame, p_11
   {0.487, 0, 0.4888},    -- Attachment point for the rear spring onto main frame, p_13
   {0.196, 0, 0.3113},    -- Centre of mass of swinging arm, p_14
   {0.539, 0, 0.1878},    -- Swinging link pivot for monoshock suspension, p_19
   {0.4946, 0, 0.1522},   -- Lower connecting link pivot for monoshock suspension, p_20
   {0.4443, 0, 0.1782},   -- Spring / link attachment for monoshock suspension, p_21
   {0.3722, 0, 0.2748},   -- Upper connecting link pivot for monoshock suspension, p_22
   {0.549 + 0.08, 0, 0.3608 + 0.01}, -- Engine output shaft bearing, p_24?
}

blueprint.chassisstiffness = 100000
blueprint.chassisdamping = 100

blueprint.rearstiffness = 75570        -- Rear spring stiffness (N / m)       
blueprint.reardamping = {8600, 11700}  -- Rear suspension Compression and     
                                     -- rebound damping (N s / m)	       
blueprint.rearpreload = 0.03	     -- Rear spring preload displacement (m)
blueprint.rearlocks = {-0.04, 0.025}   -- Rear suspension range (m).         

blueprint.frontstiffness = 19620       -- Front spring stiffness (N / m)
blueprint.frontdamping = {1760, 2710}  -- Front suspension Compression and
                                     -- rebound damping (N s / m)
blueprint.frontpreload = 0.03          -- Front spring preload displacement (m)
blueprint.frontlocks =  {-0.09, 0.03}  -- Front suspension range (m).         

blueprint.sprockets = {0.043197, 0.10622}

blueprint.drag = 0.48      -- Coefficient of drag.
blueprint.lift = 0.078     -- Coefficient of lift.
blueprint.pitch = 0.189    -- Coefficient of pitching moment.
blueprint.area = 0.65      -- Frontal area.

blueprint.masses = {
   {9.99, 1.341, 1.584, 0.4125 + 0.103, 0, 0, 0},    -- Steering head
   {7.25, 1e-6, 1e-6, 1e-6, 0, 0, 0},                -- Front suspension unsprung mass
   {165.13, 11.0854, 22.013, 14.982, 0, -3.691, 0},  -- Main frame
   {33.68, 1.428, 1.347, 0.916, 0, 0.4433, 0},       -- Rider upper body
   {8, 0.02, 0.259, 0.259, 0, 0, 0},                 -- Swingarm
   {11.9, 0.27, 0.484, 0.27, 0, 0, 0},               -- Front wheel
   {14.7, 0.383, 0.638, 0.383, 0, 0, 0},             -- Rear wheel
}
