-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

fragments = {}

function fragments.tracks(context)
   return [=[
    <table class="presets">
    <tr><th colspan="3">]=] .. context.heading .. [=[</th></tr>
  <?lua
     local html, entries = "", {}

     for key, tag in pairs(configurations.stock) do
        if string.match (key, "^]=] .. context.prefix .. [=[") then
	   table.insert (entries, {key, tag})
	end
     end

     table.sort(entries, function(a, b) return a[1] < b[1] end)

     for i = 1, #entries do
	html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">race</a></td></tr>
]], entries[i][2], entries[i][1])
     end

     return html
   ?>
    </table>
  ]=]
end

function fragments.presets(context)
   return [=[
  <form name="]=] .. context.chunk .. [=[_presets" action="]=] .. context.action .. [=[" method="post">
    <input type="hidden" name="remove" />
    <script type="text/javascript">
      function remove_]=] .. context.chunk .. [=[ (preset)
      {
	 var form;
	 
	 form = document.forms.]=] .. context.chunk .. [=[_presets;

	 form.remove.value = preset;
	 form.submit();
      }
    </script>

    <table class="presets">
    <tr><th colspan="2">Stock configurations</th></tr>
  <?lua
     local html = ""

     for key, tag in pairs(configurations.stock) do
        if string.match (key, "^]=] .. context.prefix .. [=[") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">load</a></td></tr>
]], tag, key)
	end
     end

     return html
   ?>

    <tr><th colspan="2">Custom configurations</th></tr>
  <?lua
     local html = ""

     if query.remove then
	configurations.pages[query.remove] = nil
	configurations.mime[query.remove] = nil
	configurations.custom[query.remove] = nil
     end

     -- TODO: fix this when Lua 5.2 arrives.
 
     for key, tag in getmetatable(configurations.custom).__pairs() do
        if string.match (key, "^]=] .. context.prefix .. [=[") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">load</a> &middot; <a href="javascript:remove_]=] .. context.chunk .. [=[('%s')">remove</a></td></tr>
]], tag, key, key)
	end
     end

     if #html == 0 then
	html = [[
    <tr><td>No presets have been created yet</td><td/></tr>
]]
     end

     return html
   ?>
    </table>
  </form>
]=]
end

function fragments.preprocessor(script)
   return [=[
  <script type="text/javascript">
    preprocessors.push(function () {
]=] .. script .. [=[
    });
  </script>
]=]
end

function fragments.postprocessor(script)
   return [=[
  <script type="text/javascript">
    postprocessors.push(function () {
]=] .. script .. [=[
    });
  </script>
]=]
end

fragments.processimport = [=[
  <?lua
     if query.import and #query.script[1] > 0 then
	assert(loadstring(query.script[3]))()
 
	return [[
<table class="notification"><tr><td><ul>
  <li>A configuration has been imported.</li>
</table>
	   ]]
    end
   ?>
]=]
     
function fragments.importconfiguration(context)
   return [=[
  <form name="import" action="]=] .. context.action .. [=[" enctype="multipart/form-data" method="post">
   <p> Select a configuration file to import: <input type="hidden" name="import" value="true" />
   <input type="file" name="script" onchange="javascript: document.import.submit()" /></p>
  </form>
]=]
end

function fragments.beginconfiguration(context)
  local fragment = [=[
  <form name="configuration" method="post">
  <script type="text/javascript">
     var preprocessors = [function (form) {
        var i, form;

        for (i = 0;
	     i < form.elements.length;
	     i += 1) {
	   var element = form.elements[i];
	   var pre = element.getAttribute("pre");
	   
	   if (pre) {
	      element.value = eval(pre.replace ("$", element.value));
	   }
	}
     }]

     var postprocessors = [function (form) {
        var i, form;

        for (i = 0;
	     i < form.elements.length;
	     i += 1) {
	   var element = form.elements[i];
	   var post = element.getAttribute("post");

	   if (post) {
	      element.value = eval(post.replace ("$", element.value));
	   }
	}
     }]

     function save()
     {
	var form;

	form = document.forms.configuration;
	form.save.value = "true";
	form.action="]=] .. (context.onsave or '') .. [=[";

	submit();
     }

     function apply()
     {
	var form;

	form = document.forms.configuration;
	form.save.value = "false";
	form.action="]=] .. (context.onapply or '') .. [=[";

	submit();
     }

     function writeout()
     {
	var form;

	form = document.forms.configuration;
	form.save.value = "false";
	form.action="/slipstream/configurations/export";

	submit();
     }

     function submit()
     {
	var form, description, checks;

	form = document.forms.configuration;

	// Make all checkboxes return false when
	// not checked.

	checks = form.getElementsByTagName("input");

	for (i in checks) {
	   var e = checks[i];

	   if (e.type == "checkbox") {
	      if (e.checked) {
		 e.value = "true";
	      } else {
	         e.value = "false";
		 e.checked = true;
	      }
	   }
	}

	// Postprocess and submit.

	for (i in postprocessors) {
	   postprocessors[i](form)
	}

	form.submit();
     }

    window.addEventListener("load", function () {
       var form;

       form = document.forms.configuration;

       for (i in preprocessors) {
	  preprocessors[i](form)
       }
    }, false);
  </script>
  
  <input type="hidden" name="save" />
]=]

   if context.chunk then
      fragment = fragment .. [=[
  <input type="hidden" name="chunk" value="]=] .. context.chunk .. [=[" />
]=]
   end

   return fragment
end

function fragments.endconfiguration(context)
   local fragment = [=[

]=]

   if context.apply then
      fragment = fragment .. [=[
  <a href="javascript: apply()">Apply</a> this configuration for now only.
]=]

      if context.default or context.save then
         fragment = fragment .. [=[
   <br/>
]=]
      end
   end

   if context.save then
      fragment = fragment .. [=[
  <a href="javascript: save()">Save</a> this configuration as
    <input type="text" name="description" class="description"
           value="<?lua return string.format('Configuration created on %s',
		    os.date('%a, %d %b %Y %T'))?>"/>.
]=]

      if context.default or context.export then
         fragment = fragment .. [=[
   <br/>
]=]
      end
   end

   if context.export then
      fragment = fragment .. [=[
  <a href="javascript: writeout()">Export</a> this configuration to a file.
]=]

      if context.default then
         fragment = fragment .. [=[
   <br/>
]=]
      end
   end

   if context.default then
      fragment = fragment .. [=[
  <a href="javascript: save()">Save</a> this configuration.
]=]
   end

   fragment = fragment .. [=[
</form>
]=]

   return fragment
end

function fragments.processconfiguration(context)
   local fragment = [=[
<?lua
local script, uri, full, html, file

if query.save == nil then
   return
end
 
script = ""

for key, value in pairs(query) do
   -- All query keys of the form foo.bar as well as the
   -- key blueprint are assumed to be variables to set.

   if string.match (key, "^blueprint$") or
      string.match (key, "^%w+%.%w[%w.]*$")  then
      if type(value) == "table" then
	 value = "{" .. table.concat (value, ", ") .. "}"
      end

      script = script .. "   " .. key .. " = " .. value .. "\n"
   end
end

assert (loadstring (script))()

html = [[
<table class="notification"><tr><td><ul>
  <li>Your changes have been applied.</li>
]]
]=]

   if context.model then
      -- Save the model chunk using a bookmark.

      fragment = fragment .. [=[

if query.save and query.save ~= "false" then
   uri = string.format ("]=] .. context.prefix .. [=[/%s/%d", query.chunk, os.time())

   configurations.mime[uri] = "text/html"
   configurations.custom[uri] = query.description
   configurations.pages[uri] = [[
<?lua
]] .. script .. [[
?>

<head></head>
<body onload="javascript:window.location = ']=] .. context.redirect .. [=[';"></body>
]]

   html = html .. [[
  <li>Your changes have been saved as:<br/>]] .. query.description .. [[.</ul>
]]
end
]=]
   else
      -- Save global configuration into .rc file.

      fragment = fragment .. [=[

if query.save and query.save ~= "false" then
   file = io.open (os.getenv ("HOME") .. "/.slipstream", "w")

   if file then
      file:write ([[
-- These settings have been written by the graphical interface.
-- If you make any changes, keep in mind that they will be replaced
-- next time you click save in the settings page.

]])
      file:write (script)
      
      if query.save == "true" then
	 html = html .. [[
  <li>Your changes have been saved.</ul>
]]
      end
   else

      html = html .. [[
  <li>Your changes could not be saved because I can't write to ']] .. os.getenv ("HOME") .. [[/.slipstream'.</ul>
]]
   end
end
]=]
   end

   fragment = fragment .. [=[

html = html .. [[
</ul></td></tr></table>
]]

return html
?>
]=]

   return fragment
end

-- print (fragments.processconfiguration {prefix = "/slipstream",
-- 				       redirect = "/slipstream"})
-- abort()

function fragments.editloadedmodel(context)
   return [=[
<?lua
  if blueprint.model == "]=] .. context.model .. [=[" then
     return [[<span>[<a href="/]=] .. context.model .. [=[">Edit</a>]</span>]]
  end
 ?>
]=]
end

fragments.logo = [=[
<img id="logo" src="/slipstream/logo" />
]=]

fragments.slipstreamnavigation = [=[
<table class="navigation">
<tr><th>Slipstream</th><tr>
<tr><td>
  <a href="/slipstream">home</a>&nbsp;&middot;&nbsp;<a href="/slipstream/sessions">sessions</a>&nbsp;&middot;&nbsp;<a href="/slipstream/settings">settings</a>&nbsp;&middot;&nbsp;<a href="/slipstream/quit">quit</a>
</td></tr>
</table>
]=]

fragments.motorcyclenavigation = [=[
<table class="navigation-container">
<tr><td>
]=] .. fragments.slipstreamnavigation .. [=[
</td><td>
<table class="navigation">
<tr><th>Motorcycle</th><tr>
<tr><td>
<a href="/motorcycle">home</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/vehicle">vehicle</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/engine">engine</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/tyre?wheel=front">front tyre</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/tyre?wheel=rear">rear tyre</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/control">control</a>
</td></tr>
</table>
</td></tr>
</table>
]=]