<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Slipstream</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.slipstreamnavigation ?>

  <!-- Add the sessions table. -->

  <p>The following table lists the sessions you have recorded and
     saved so far.
  </p>

  <?lua
     if query.remove then
	sessions.pages[query.remove] = nil
	sessions.mime[query.remove] = nil
	sessions.recorded[query.remove] = nil
	sessions.imported[query.remove] = nil
     end
   ?>

  <script type="text/javascript">
      function remove (preset)
      {
	 var form;
	 
	 form = document.forms.sessions;

	 form.remove.value = preset;
	 form.submit();
      }
  </script>

  <form name="sessions" action="/slipstream/sessions" method="post">
    <input type="hidden" name="remove" />

    <table class="presets">
      <tr><th colspan="2">Recorded sessions</th></tr>
  <?lua
     local html = ""

     -- TODO: fix this when Lua 5.2 arrives.
 
     for key, tag in getmetatable(sessions.recorded).__pairs() do
        if string.match (key, "^/slipstream/sessions") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">load</a> &middot; <a href="javascript:remove('%s')">remove</a></td></tr>
]], tag, key, key)
	end
     end

     if #html == 0 then
	html = [[
      <tr><td>No sessisons have been recorded yet.</td><td/></tr>
]]
     end

     return html
   ?>
    </table>

    <p>These are the sessions that have been imported from recordings
    made by others. </p>
    
    <table class="presets">
      <tr><th colspan="2">Imported sessions</th></tr>
  <?lua
     local html = ""

     -- TODO: fix this when Lua 5.2 arrives.
 
     for key, tag in getmetatable(sessions.imported).__pairs() do
        if string.match (key, "^/slipstream/sessions") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">load</a> &middot; <a href="javascript:remove('%s')">remove</a></td></tr>
]], tag, key, key)
	end
     end

     if #html == 0 then
	html = [[
      <tr><td>No sessisons have been imported yet.</td><td/></tr>
]]
     end

     return html
   ?>
    </table>
  </form>

  <form name="import" action="/slipstream/sessions/import" enctype="multipart/form-data" method="post">
    <p>Choose a session file to import: <input type="file" name="script" onchange="javascript: document.import.submit();"/></p>
  </form>
</body>
