/*
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

body {
    font-size: 10pt;
    margin-left: 10px;
    margin-right: 10px;

    color: #424242;
}

a {
    color: #888424;
}

a:link {
    background-color: inherit ;
    text-decoration: none ;
}

a:visited {
    background-color: inherit ;
    text-decoration: none ;
}

a:link:hover, a:visited:hover {
    background-color: #ddddbb ;
    color: #FFFAF6;
}

hr {
    border: 0;
    height: 1px;
    background-color: #424242;
}

input {
    color: inherit;
}
    
input[type='text'] {
    font-size: inherit;
    width: 5em;
    text-align: right;
}

input.description {
    width: 350px;
    text-align: left;
}

textarea.comments {
    width: 350px;
    height: 100px;
    text-align: left;
}

table.configuration, table.presets {
    font-size: 10pt;
    margin-top: 5px;
    margin-bottom: 5px;
    padding: 0px;
    width: 100%;
    border: 1px dotted #424242;
}

table.configuration > tbody > tr > th {
    background-color: #7FA6AD;
    color: #FFFAF6;
    text-align: left;
}

table.configuration > tbody > tr:nth-of-type(even) {
    background-color: #ddddbb;
}

table.presets > tbody > tr > th {
    background-color: #7FA6AD;
    color: #FFFAF6;
    text-align: left;
}

table.presets > tbody > tr > td {
    text-align: right;
    padding-left: 3px;
    padding-right: 3px;
}

table.presets > tbody > tr > td:first-child {
    text-align: left;
}

table.presets > tbody > tr:nth-of-type(odd) {
    background-color: #ddddbb;
}

table.matrix {
    font-size: 10pt;
    display: inline;
    vertical-align: middle;
}

table.matrix > tbody > tr {
    background-color: transparent;
}

table.matrix > tbody > tr:first-child > td:first-child {
    width : 2px;
    border-top : 1px solid #424242;
    border-left : 1px solid #424242;
    border-bottom : 1px solid #424242;
}

table.matrix > tbody > tr:first-child > td:last-child {
    width : 2px;
    border-top : 1px solid #424242;
    border-right : 1px solid #424242;
    border-bottom : 1px solid #424242;
}

table.fraction {
    font-size: 10pt;
    display: inline;
    vertical-align: middle;
}

table.fraction > tbody > tr > td {
    background-color: transparent;
    text-align: center;
}

table.fraction > tbody > tr:first-child > td {
    background-color: transparent;
    border-bottom: solid 1px;
}

table.splashscreen {
    width:100%;
    height:100%;
}

table.splashscreen div {
    background-color: slategrey;
    border-style:dotted;
    border-width:thin;
    border-color:#424242;
    text-align:center;
}

div.section {
    width: 20em;
    font-weight: bold;
    border-top: 1px solid #424242;
    border-bottom: 1px solid #424242;
    background-color: #E5BD4E;
    color: #FFFAF6;
    padding-left: 3px;
}

div.section span {
    font-weight: normal;
    font-size: smaller;
    margin-right: 3px;
    float: right;
}

div.section a {
    color: inherit;
}

table.notification {
    margin-top: 1em;
    border: 1px dotted #424242;
    background-color: #ddddbb;
    color: #424242;
    font-weight: normal;
    font-size: smaller;
}

table.notification ul {
    padding: 0 0 0 1.5em;
    margin: 0;
}

table.navigation {
    width: 100%;
    border: 1px dotted #424242;
    border-collapse: collapse;
}

table.navigation th {
    background-color: #E5BD4E;
    color: #FFFAF6;
    font-size: 7pt;
    text-align: left;
    padding: 1px;
}

table.navigation td {
    font-size: 10pt;
    padding: 1px;
}

table.navigation-container {
    border-collapse: collapse;
}

table.navigation-container > tbody > tr > td:last-child {
    width: 100%;
}

#logo {
    width: 350px;
    margin-left: 5px;
    margin-bottom: 3px;
}

form {
   margin: 0;
   padding: 0;
}