/**
 * @file  imgs.c
 * @copyright Copyright (C) 2019-2020 Michal Babik
 *
 * This file is part of Small File Renamer.
 *
 * Small File Renamer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Small File Renamer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Small File Renamer.  If not, see <https://www.gnu.org/licenses/>.
 *
 * @brief  Application graphics
 * 
 * @author Michał Bąbik <michalb1981@o2.pl>
 */
#include "imgs.h"
/*----------------------------------------------------------------------------*/
/**
 * @brief  Icon data structure
 */
typedef struct Icon {
  int           width;                        /**< Image width */
  int           height;                       /**< Image height */
  int           bytes_per_pixel;              /**< 2:RGB16, 3:RGB, 4:RGBA */ 
  unsigned char pixel_data[16 * 16 * 4 + 1];  /**< Image data */
} Icon;
/*----------------------------------------------------------------------------*/
/**
 * @brief  Add icon
 */
static const Icon icon_add = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000+K'\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\061M.\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000(G%\213i\262_\377i\256`\377m\257d\377t\266k\377/I+\213"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\070b\063\200\221\367\204\377\221\361\205\377\226\363\212\377\240\374"
  "\224\377Ae<\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\070a\062\200\217\364\201\377\217\356\203\377\224\357"
  "\210\377\236\371\222\377Ac<\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000$"
  "H\040\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066^\061|\216\364\201\377\217\356\202"
  "\377\224\360\210\377\235\371\221\377?a:|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\067N\064\001\000\000\000\000\"D\036\213\061_+\200\062_-\200\064].|Bt;\277\216\364\201\377"
  "\217\355\202\377\223\360\207\377\235\371\220\377MxH\277Ab<|De@\200GgC\200"
  "\065J\061\213\000\000\000\000\000\000\000\000V\254K\377|\357m\377\200\356q\377\204\360v\377"
  "\211\362{\377\211\353|\377\216\355\201\377\223\357\206\377\226\360\213\377"
  "\241\372\225\377\246\374\232\377\253\375\237\377\262\377\247\377\203\274"
  "|\377\000\000\000\000\000\000\000\000S\246H\377x\347i\377{\347m\377\200\350r\377\204\352"
  "w\377\211\353|\377\216\356\200\377\222\357\206\377\227\361\213\377\233\363"
  "\220\377\240\364\225\377\245\366\232\377\254\373\241\377\177\266w\377\000\000"
  "\000\000\000\000\000\000S\246H\377w\347h\377{\347l\377\177\350q\377\204\352v\377\210"
  "\353|\377\215\355\200\377\222\357\206\377\226\360\212\377\233\362\217\377"
  "\240\364\224\377\244\365\232\377\253\372\240\377\177\266w\377\000\000\000\000\000\000"
  "\000\000V\253J\377{\357k\377~\356o\377\203\360t\377\207\361y\377\210\353z\377"
  "\215\355\177\377\221\356\205\377\226\360\211\377\237\372\224\377\244\374"
  "\231\377\251\375\236\377\260\377\245\377\202\273{\377\000\000\000\000\000\000\000\000\"D"
  "\035\213\061_+\200\062^,\200\063]-|Ar:\277\214\363~\377\214\355\200\377\221\356"
  "\204\377\233\370\216\377KwF\277@b;|Ce?\200GgA\200\064J\061\213\000\000\000\000$H\037"
  "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\065^/|\213\362}\377\214\354\177\377\220"
  "\357\204\377\232\370\215\377=a\071|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066N\064"
  "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066`\060\200\213\363}\377\213\354"
  "\177\377\220\357\203\377\231\367\215\377?c:\200\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\067a\061\200\214\365"
  "~\377\215\357\200\377\222\361\205\377\233\372\216\377?d:\200\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000'F#\213"
  "d\260[\377e\254[\377h\255_\377o\265f\377.H*\213\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000*J%\001\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\060L,\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Add dir icon
 */
static const Icon icon_add_dir = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\323\323j\000rr\067\021\234\234O#\234\234R#\234"
  "\234U#\234\234Y#rrA\021\323\323|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\264\264Zn\347\347w\332\353\353~\334\353"
  "\353\203\334\347\347\205\332\264\264hn\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\306\306b\200\373\373\200\376"
  "\377\377\207\377\377\377\215\377\373\373\216\376\306\306q\200\000\000\000\001\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\306"
  "\306`\200\372\372~\376\377\377\205\377\377\377\212\377\372\372\214\376\306"
  "\306o\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\323\323N\000\000\000\000\002\000\000"
  "\000\001\000\000\000\001\000\000\000\003\305\305]\200\372\372{\375\377\377\202\377\377\377\207"
  "\377\372\372\212\375\305\305m\200\000\000\000\003\000\000\000\001\000\000\000\001\000\000\000\002\323\323"
  "\205\000rr&\021\264\264Cn\306\306M\200\306\306Q\200\305\305T\200\321\321`\277"
  "\373\373y\376\377\377\200\377\377\377\205\377\373\373\210\376\321\321s\277"
  "\305\305p\200\306\306t\200\306\306y\200\264\264pnrrF\021\234\234\067#\347\347"
  "V\332\373\373b\376\372\372g\376\372\372l\375\373\373q\376\377\377x\377\377"
  "\377}\377\377\377\202\377\377\377\207\377\373\373\212\376\372\372\217\375"
  "\372\372\223\376\373\373\231\376\347\347\220\332\234\234a#\234\234\065#\353"
  "\353V\334\377\377a\377\377\377f\377\377\377l\377\377\377q\377\377\377v\377"
  "\377\377{\377\377\377\200\377\377\377\205\377\377\377\212\377\377\377\217"
  "\377\377\377\224\377\377\377\231\377\353\353\220\334\234\234_#\234\234\063"
  "#\353\353S\334\377\377_\377\377\377d\377\377\377i\377\377\377n\377\377\377"
  "s\377\377\377x\377\377\377}\377\377\377\202\377\377\377\207\377\377\377\214"
  "\377\377\377\221\377\377\377\226\377\353\353\216\334\234\234]#\234\234\062"
  "#\347\347P\332\373\373[\376\372\372`\376\372\372e\375\373\373j\376\377\377"
  "q\377\377\377v\377\377\377z\377\377\377\200\377\373\373\203\376\372\372\207"
  "\375\372\372\214\376\373\373\221\376\347\347\211\332\234\234\\#rr!\021\264"
  "\264;n\306\306E\200\306\306I\177\305\305L\200\321\321V\277\373\373m\376\377"
  "\377s\377\377\377x\377\373\373{\376\321\321i\277\305\305h\200\306\306l\177"
  "\306\306q\200\264\264inrrA\021\323\323E\000\000\000\000\002\000\000\000\001\000\000\000\001\000\000\000\003"
  "\305\305O\200\372\372j\375\377\377q\377\377\377u\377\372\372x\375\305\305"
  "_\200\000\000\000\003\000\000\000\001\000\000\000\001\000\000\000\002\323\323}\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\001\306\306N\200\372\372g\376\377\377n\377\377\377s\377\372"
  "\372u\376\306\306]\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\306\306L\200\373\373e\376\377\377k\377\377"
  "\377p\377\373\373s\376\306\306\\\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\264\264Cn\347\347Z\332\353\353"
  "a\334\353\353e\334\347\347h\332\264\264Qn\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\323\323N\000rr&\021\234\234:#\234\234"
  "=#\234\234@#\234\234C#rr\061\021\323\323`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Remove icon
 */
static const Icon icon_remove = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000Q\031\031\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q$$\001\000\000\000\000M\030"
  "\030\213k\"\"\200i##\200i$%\200i%%\200i''\200i((\200i**\200i++\200i,,\200"
  "i..\200i./\200k\060\060\200M\"\"\213\000\000\000\000\000\000\000\000\300;;\377\377UU\377\377"
  "WX\377\377Z[\377\377^^\377\377aa\377\377dd\377\377gh\377\377kk\377\377nn"
  "\377\377qq\377\377ut\377\377vv\377\300UU\377\000\000\000\000\000\000\000\000\272\071\070\377"
  "\377QQ\377\377ST\377\377WW\377\377ZZ\377\377]]\377\377``\377\377cc\377\377"
  "gf\377\377ji\377\377mm\377\377pp\377\377rr\377\272SS\377\000\000\000\000\000\000\000\000"
  "\272\070\067\377\377PP\377\377SR\377\377UU\377\377YX\377\377\\\\\377\377__"
  "\377\377bb\377\377ee\377\377hh\377\377lk\377\377oo\377\377ss\377\272SS\377"
  "\000\000\000\000\000\000\000\000\300\071\071\377\377RR\377\377TT\377\377WW\377\377[Z\377\377"
  "^^\377\377aa\377\377dd\377\377gg\377\377kk\377\377nn\377\377qq\377\377vv"
  "\377\300UU\377\000\000\000\000\000\000\000\000M\027\027\213k\040\040\200i!!\200i\"\"\200i$$\200"
  "i%%\200i&&\200i((\200i)(\200i**\200i++\200i--\200k//\200M\"\"\213\000\000\000\000"
  "Q\030\030\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q$$\001\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Revert icon
 */
static const Icon icon_rev = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\001"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000)\000\000\000\030\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\017*X#\022\061c\244\005\026\063\064\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\014\"S\236\216(`\264\342\021\062c\065\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\035G\213O\061"
  "s\325\350.q\313\350\017\060Z\066\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021.a\037*c\273\300\067\204\353"
  "\377.y\320\361\031S\205\216\031Y\210q\025RyP\012\065O#\000\000\000\005\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005#T\241u\064|\341\367\067\215\361\377"
  "\064\221\352\377\060\223\341\373\060\231\341\373-\230\330\363%\211\276\320\033"
  "o\227w\012=S\035\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031?~//o\316\325\067"
  "\210\357\377\066\223\361\377\065\234\361\377\064\244\362\377\063\252\362\377"
  "\062\260\362\377\061\262\357\377-\252\341\367\"\214\265\267\024b~\071\000\000\000\002"
  "\000\000\000\000\000\000\000\000\000\000\000\010&Z\254\216\066\200\346\373\067\220\361\377\065\231"
  "\361\377\064\242\361\377\063\252\362\377\062\260\362\377\061\266\362\377\061\272"
  "\362\377\060\276\363\377.\272\353\377!\220\265\300\006\061@\033\000\000\000\000\000\000\000"
  "\000\035F\212\070\061t\326\337\067\213\360\377\066\226\361\377\065\237\361\377\063"
  "\246\356\377/\245\344\374.\252\343\374.\264\351\377/\276\360\377/\304\363"
  "\377/\306\362\377#\237\302\333\007:I%\000\000\000\000\002\002\033\012'^\262\230\066\202\351"
  "\375\067\221\361\377\065\234\361\377\064\246\361\377,\230\326\363\031g\217\225"
  "\030h\213z\033y\233\235#\232\277\321*\272\341\367.\312\360\377#\244\303\332"
  "\006;G%\000\000\000\000\024\064j\071+g\300\341\063\201\340\377\063\221\350\377\064\240\357"
  "\377\063\254\362\377)\227\316\347\014AZ\067\000\000\000\001\000\000\000\007\011AQ$\031\177\227"
  "v%\260\315\332\040\237\270\332\010DO%\000\000\000\002\003\017'N\021\062b\235\026Dw\254\033"
  "Z\216\313$|\264\352,\241\333\375'\231\312\350\016Kc\065\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\005\022n~<\020es\227\002%+\"\000\000\000\000\000\000\000\005\000\000\000\010\000\000\000\014\000\000\000"
  "\034\006*>F\024^~\237\027l\214\321\007\065F\065\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\024\000\000\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\017\002\031\"E\000\000\000\034\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\001\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};

/**
 * @brief  Sort icon
 */
static const Icon icon_srt = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\065\071Q\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000CGf\002\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\062"
  "\066M\213~\206\300\377|\203\274\377Y_\210\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000GLm\203"
  "\265\300\377\377\261\274\377\377\200\210\302\377\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\035\037.=HLo\177HMm|\064\067O\210\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\071\000\000\000\065\000\000\000\065\000\000\000\062\000\000\000"
  "/\000\000\000/\000\000\000\063\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000hs\277\377\226\244\377\377\232\246\377\377\236\253\377\377"
  "\245\260\377\377\254\267\377\377~\206\300\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000ep\277\377\221\240\377\377\226"
  "\243\377\377\233\250\377\377\240\254\377\377\247\263\377\377}\204\300\377"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\037@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\063\000\000\000/\000\000\000/\000\000\000/\000\000\000/\000\000\000/\000\000\000\063\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\022\025,@/\066l\203\060\067h\200\062\070h\200\065<k|\070>k|:"
  "@k|<Ak|>Cl|BFm|\061\065N\210\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000-\064m\204"
  "u\207\377\377w\210\377\377|\215\377\377\202\221\377\377\207\226\377\377\215"
  "\233\377\377\221\240\377\377\227\244\377\377\237\253\377\377v\177\302\377"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\032\037BeDP\245\320FP\240\313IS\240"
  "\313LV\240\313OY\240\313S[\240\313V_\240\313Yb\240\313^f\242\313FKu\335\000"
  "\000\000\000\026\033C\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000'*C\003\000\000\000\000&/t\335"
  "\065B\241\313\066C\237\313:F\237\313=I\237\313AL\237\313DN\240\313GQ\240\313"
  "JU\240\313NW\240\313QZ\240\313T\\\240\313Xa\242\313BHt\335\000\000\000\000\000\000\000"
  "\000?N\275\377Vk\377\377Vj\377\377\\o\377\377`s\377\377fy\377\377k}\377\377"
  "p\202\377\377u\206\377\377{\213\377\377\200\217\377\377\206\225\377\377\215"
  "\233\377\377is\276\377\000\000\000\000\000\000\000\000&/t\335\065B\241\313\065A\237\313\066"
  "B\237\313\071E\237\313<H\237\313@K\237\313CN\237\313FQ\240\313JT\240\313M"
  "V\240\313PZ\240\313T]\241\313?Et\335\000\000\000\000\026\033C\001\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000%(C\001",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Select icon
 */
static const Icon icon_select = {
  16, 16, 4,
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364\026V\000\377\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000"
  "\377\377\377\000\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377"
  "\000\364B\377\000\364\026V\000\377\377\377\377\000\377\377\377\000\026V\000\377B\377\000"
  "\364\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377"
  "\000\377\377\377\000\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377"
  "\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377\000\364B\377"
  "\000\364\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000\026V\000"
  "\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377"
  "\000\364B\377\000\364B\377\000\364\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026"
  "V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377\000"
  "\364B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377\000\364"
  "B\377\000\364\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364\026V\000\377"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Duplicates icon
 */
static const Icon icon_dupl = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\003\003\000=\013\013\000<\013\013\000<\013\013"
  "\000=\013\013\000\034\003\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\277\216a\377\335\244o\377\334\243l\377\334\242j\377\314\226a\334\211"
  "d?\"\211d?\"\314\226a\334\334\242i\377\334\242i\377\335\242i\377\277\214"
  "Z\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\335\245r\377\377\277\203\377\377\276"
  "\200\377\377\275}\377\353\256q\334\236sI\"\236sJ\"\353\255q\334\377\274{"
  "\377\377\274{\377\377\275{\377\335\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\334\245t\377\377\300\205\377\377\276\202\377\377\275\177\377\353\256s"
  "\334\235rJ\"\235rI\"\353\255q\334\377\274{\377\377\274{\377\377\274{\377"
  "\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\246v\377\377\300\207\377"
  "\377\277\204\377\377\276\202\377\353\256u\334\235sK\"\235rI\"\353\255q\334"
  "\377\274{\377\377\274{\377\377\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\334\247x\377\377\301\212\377\377\300\207\377\377\277\204\377"
  "\353\257w\334\235tM\"\235rI\"\353\255q\334\377\274{\377\377\274{\377\377"
  "\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\247z\377\377\302"
  "\214\377\377\300\211\377\377\300\206\377\353\260y\334\235tN\"\235sI\"\353"
  "\255q\334\377\274{\377\377\274{\377\377\274{\377\334\242i\377\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\334\250|\377\377\302\216\377\377\301\213\377\377\300"
  "\210\377\353\260{\334\235tP\"\235sK\"\353\256s\334\377\274{\377\377\274{"
  "\377\377\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\250~\377"
  "\377\303\220\377\377\302\215\377\377\301\213\377\353\261}\334\235uQ\"\235"
  "sM\"\353\256u\334\377\275}\377\377\274{\377\377\274{\377\334\242i\377\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\251\200\377\377\304\223\377\377\302\217"
  "\377\377\302\215\377\353\262\177\334\235uR\"\235tN\"\353\257w\334\377\276"
  "\200\377\377\275}\377\377\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\334\251\202\377\377\304\225\377\377\303\222\377\377\302\217\377\353"
  "\262\201\334\235vT\"\235tO\"\353\260y\334\377\276\202\377\377\275\177\377"
  "\377\275}\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\252\203\377"
  "\377\305\227\377\377\304\224\377\377\303\221\377\353\263\204\334\235vU\""
  "\235uP\"\353\260{\334\377\277\204\377\377\276\201\377\377\276\177\377\334"
  "\242j\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\253\205\377\377\306\231\377"
  "\377\304\226\377\377\304\224\377\353\264\206\334\235wW\"\235uR\"\353\261"
  "}\334\377\300\206\377\377\277\203\377\377\276\201\377\334\243l\377\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\335\254\210\377\377\307\234\377\377\306\231\377"
  "\377\305\226\377\353\265\210\334\236xY\"\236wT\"\353\262\177\334\377\301"
  "\211\377\377\300\206\377\377\277\203\377\335\244o\377\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\277\224v\377\335\253\207\377\334\253\204\377\334\252\202\377"
  "\314\234w\334\211hN\"\211gI\"\314\232o\334\334\246w\377\334\245t\377\335"
  "\245r\377\277\216`\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\034\006\006\000=\025\025\000<\025\025\000<\025\025\000=\025\025\000\034\006\006\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Info icon
 */
static const Icon icon_info = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333\010\000\\\333/\000\\\333\065\000"
  "\\\333\062\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333\063\000\\\333\325\000\\\333\354\000\\\333"
  "\304\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333P\000\\\333\347\000\\\333\360\000\\\333\235"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333#\000\\\333K\000\\\333K\000\\\333'\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\\\333\013\000\\\333\207\000\\\333\270\000\\\333\253\000\\\333-\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\\\333\036\000\\\333\323\000\\\333\377\000\\\333\337\000\\\333*\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\\\333\070\000\\\333\351\000\\\333\377\000\\\333\303\000\\\333\024\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\\\333[\000\\\333\367\000\\\333\377\000\\\333\237\000\\\333\007\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\334\004\000\\\333\213\000\\\333\376\000\\\333\372\000\\\333m\000Z\332\001\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\333\016\000\\\333\265\000\\\333\377\000\\\333\357\000\\\333E\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\333\040\000\\\333\324\000\\\333\377\000\\\333\334\000\\\333'\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\333:\000\\\333\353\000\\\333\377\000\\\333\300\000\\\333\022\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\332T\000\\\333\337\000\\\333\346\000\\\333\215\000\\\332\006\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333"
  "\025\000\\\333/\000\\\333/\000\\\333\031\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
static const struct {
  int 	         width;
  int 	         height;
  int 	         bytes_per_pixel; /* 2:RGB16, 3:RGB, 4:RGBA */ 
  unsigned char	 pixel_data[93 * 120 * 3 + 1];
} image_about = {
  93, 120, 3,
  "Io\216Lm\211\026V|\000OyIl\211Wu\217Wu\217\000HtYv\221Rr\216\065a\204Yw\221#Z}"
  "\000Ox\032V|d~\227\"Y}\014Sy\005Rx\013Tz\034V{\016Tz\032V}-]\177\000Qx\034W|;d\204Pp\215"
  "\000LuLn\213Bi\207\023V{`|\225+\\\177\031V|&Z~)[\177*[\177*[\177*[\177*[\177"
  "*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177"
  "*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177"
  "*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177"
  "*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177*[\177"
  "*[\177*[\177)Z~\067f\210\\y\223\221\240\257\227\245\263\210\231\251z\214\235"
  "f{\220m\201\225\000\022[\177\217\241q\203\227dz\220z\213\234\222\240\257_u\215"
  "(Tw\241\256\273\235\253\270\215\234\254\207\227\247\217\237\255\230\247\264"
  "\231\250\267\226\243\261e{\221\000!^i\200\224u\212\235h~\224\000/cax\220Vr\212"
  "\065\\|\215\235\255\066[{\000%a\000\063d\000\065e\000\066f\000\066f\000\066f\000\066f\000\066f\000\066"
  "f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066"
  "f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066"
  "f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066"
  "f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066f\000\066"
  "f\000\067e\000Px\000KwPn\207<e\202Kn\213<`\201\062\\|\070^~\000\000\071\000\060d\000'c<_\177"
  "?b\200Eh\205\000(c\000\000A\040XzCf\203\000Qx\032TxRq\214<d\202Ch\206\065^~\000\000X\000\000"
  "*\000<l\000@m\000\023_\000\030]Ac\201\000Ep\000'd\070_\200\000\000Q\000\000<\000\000D\000\000E\000\000F\000\000"
  "F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000"
  "\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000"
  "F\000\000F\000\000F\000\000E\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000F\000\000E\000\000E\000\000E\000\000E\000"
  "\000E\000\000E\000\000E\000\000E\000\000E\000\000E\000\000F\000\000F\000\000G\000\000K\000&f\202\224\245\277\305"
  "\316\270\277\307\266\276\310\266\276\310\267\277\311\272\301\312\270\301"
  "\311\271\300\312\270\277\307\267\300\310\266\277\310\266\276\310\270\277"
  "\311\270\277\307\266\276\310\265\275\307\266\275\307\266\275\307\266\275"
  "\307\266\275\307\266\275\307\267\276\310\271\300\310\272\301\311\271\300"
  "\312\271\300\310\271\300\312\271\300\312\270\301\311\270\277\311\271\300"
  "\312\271\300\312\271\302\312\274\303\313\275\304\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\275\304\314\275\304\314\275\304\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\275\304\313\275\304\314\275\304"
  "\314\275\304\314\274\304\313\274\303\313\274\303\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303"
  "\313\274\303\313\274\303\313\274\303\313\275\304\313\276\305\315\302\312"
  "\320\203\224\246\276\302\311\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\272\276\306\262\272\302\377\377"
  "\377\376\376\377\374\375\375\374\375\375\374\375\375\373\374\374\375\375"
  "\376\372\373\373\374\374\376\373\374\374\373\373\374\373\373\374\373\374"
  "\374\373\374\374\373\373\374\373\373\374\374\374\375\374\374\375\372\375"
  "\375\373\373\374\374\374\374\373\374\376\373\374\374\373\373\374\373\373"
  "\374\373\374\374\373\374\374\373\374\374\373\373\374\373\374\374\375\376"
  "\376\372\373\373\374\375\375\374\375\375\373\374\374\375\375\375\374\374"
  "\375\373\374\374\373\374\374\373\374\374\374\374\375\373\374\374\373\374"
  "\374\374\374\375\374\375\375\373\373\374\374\374\374\373\373\375\374\375"
  "\375\374\374\375\373\373\374\373\373\374\373\374\374\374\374\375\373\374"
  "\374\373\374\374\373\374\374\374\375\376\373\374\374\375\376\376\374\374"
  "\374\373\374\374\371\372\374\374\375\375\373\374\374\373\373\374\373\374"
  "\374\373\374\374\373\373\374\373\373\374\373\374\374\374\374\375\373\374"
  "\374\373\374\374\373\373\374\374\374\375\373\373\374\373\373\374\372\373"
  "\373\372\373\373\372\373\373\372\373\373\372\373\373\372\373\373\372\373"
  "\373\372\373\373\372\373\373\373\373\374\373\374\374\376\376\376\377\377"
  "\377\254\264\276\256\266\277\377\377\377\373\374\374\372\373\374\350\347"
  "\346\317\322\326\323\326\330\323\325\327\320\323\325\351\353\357\371\372"
  "\372\370\370\371\370\371\372\364\365\366\364\365\365\370\371\372\370\371"
  "\371\371\372\373\346\345\344\315\316\320\311\313\317\330\332\336\356\357"
  "\361\371\372\373\367\370\371\367\370\371\367\370\370\362\363\364\367\370"
  "\370\370\371\371\371\371\372\365\364\364\313\315\316\303\305\311\317\323"
  "\325\314\315\321\343\347\353\372\373\373\370\371\371\370\371\372\365\366"
  "\367\364\365\366\370\371\372\370\371\371\371\372\373\353\352\353\317\322"
  "\322\304\304\310\325\330\334\350\352\355\372\373\373\370\371\371\367\370"
  "\371\370\371\372\362\363\364\367\370\371\370\371\371\370\371\372\371\370"
  "\371\325\325\326\317\322\326\310\312\314\314\314\320\333\335\341\370\371"
  "\371\370\371\371\367\370\371\366\367\370\363\364\365\370\371\371\367\370"
  "\371\370\371\371\362\363\364\347\350\352\350\352\355\347\346\350\364\366"
  "\367\367\370\371\367\370\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\367\370"
  "\370\367\370\371\372\372\373\377\377\377\247\260\272\255\265\277\377\377"
  "\377\372\373\374\372\371\372\332\331\330\277\300\302\311\316\320\311\313"
  "\321\312\316\320\344\350\353\370\371\372\367\370\371\366\367\370\316\316"
  "\321\324\326\327\370\371\372\367\370\371\371\372\373\343\342\337\303\304"
  "\310\277\303\307\316\321\325\333\336\342\367\370\371\367\370\371\367\370"
  "\371\354\355\356\275\276\301\356\357\360\367\370\371\370\371\372\364\363"
  "\364\316\320\321\274\276\303\313\315\321\310\312\314\327\335\341\370\372"
  "\373\367\370\371\370\371\372\331\332\335\310\311\315\367\370\370\367\370"
  "\371\371\372\373\346\346\346\313\316\316\271\272\276\320\322\324\327\327"
  "\334\364\367\367\367\370\371\367\370\371\361\362\363\275\300\303\347\350"
  "\352\370\370\371\367\371\371\370\370\370\322\323\324\300\301\307\315\317"
  "\317\324\326\331\346\347\353\371\371\372\367\370\370\367\370\371\351\352"
  "\355\324\325\330\364\365\366\367\367\370\367\370\371\354\355\354\335\340"
  "\341\336\342\345\337\340\340\357\362\363\367\367\370\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\366\367\367\366\367\370\371\372\372\377\377"
  "\377\246\257\271\255\265\276\377\377\377\372\372\373\370\371\372\364\365"
  "\366\365\366\367\360\361\362\364\365\365\357\360\362\365\366\371\367\370"
  "\370\366\367\370\367\370\371\361\362\364\363\363\364\367\370\371\366\367"
  "\370\367\370\371\364\365\366\361\362\363\360\361\362\361\362\363\357\360"
  "\360\365\366\367\366\367\370\366\367\370\365\366\367\357\360\361\367\370"
  "\371\366\367\370\367\370\371\371\370\371\366\367\370\363\364\365\362\362"
  "\363\362\363\363\363\366\366\370\371\371\367\370\371\367\370\371\365\366"
  "\367\362\363\363\370\371\371\367\370\371\367\371\371\366\365\366\360\361"
  "\363\361\362\365\362\363\364\356\357\362\365\367\370\367\370\371\367\370"
  "\371\370\371\372\360\361\362\366\367\370\367\370\371\367\370\371\370\371"
  "\372\362\363\364\362\363\365\367\370\371\364\367\367\365\366\367\367\370"
  "\371\366\367\370\366\367\370\365\366\367\362\363\364\366\367\370\366\367"
  "\370\366\367\370\364\365\366\356\357\361\364\365\365\356\356\357\365\366"
  "\367\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\366\367\370\371\371\372\377\377\377\245\256\271\255\265\276\377\377"
  "\377\371\372\372\367\370\371\367\370\371\370\371\372\370\371\372\370\371"
  "\372\370\370\371\367\367\370\366\367\370\365\366\367\366\367\370\366\367"
  "\370\366\367\370\366\367\370\365\366\367\366\367\370\367\370\371\370\371"
  "\372\370\371\372\370\371\372\367\370\371\366\367\370\365\366\367\365\366"
  "\367\366\367\370\366\367\370\366\367\370\366\367\370\367\370\371\371\372"
  "\373\372\373\374\373\374\375\373\374\375\372\373\374\371\372\373\370\371"
  "\372\370\371\372\370\371\372\370\371\372\371\372\372\371\372\372\370\371"
  "\372\370\371\372\370\371\372\372\373\374\373\374\375\373\374\374\372\373"
  "\373\371\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371"
  "\372\370\370\371\370\371\372\370\371\372\372\373\373\372\373\374\371\372"
  "\373\370\371\372\367\370\371\366\367\370\365\366\367\365\366\367\366\367"
  "\370\366\367\370\366\367\367\365\366\367\365\366\367\366\367\370\367\370"
  "\370\367\370\371\367\367\370\366\367\370\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\366\367\370\371\371\372\377\377"
  "\377\245\256\271\255\265\276\377\377\377\371\372\372\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\365\366\367\365\366\367\365\366\367\365\366\367\366\367\370\366\367"
  "\370\367\370\371\365\366\365\351\352\355\366\367\367\370\371\372\370\371"
  "\372\371\372\372\371\372\373\370\371\371\372\373\374\371\373\374\372\373"
  "\374\370\371\372\356\357\360\364\364\367\372\373\373\371\370\371\370\371"
  "\372\364\363\364\366\367\370\371\372\373\373\374\374\367\370\371\367\370"
  "\370\370\371\374\370\372\373\371\372\373\367\370\371\370\371\373\371\372"
  "\372\371\372\373\371\372\372\367\370\373\370\371\372\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\366\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\366\367\370\371\371\372\377\377\377\245\256\271\255\265\276\377\377"
  "\377\371\372\372\366\367\370\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\366\367\370\370\371\372\353\352\353\301\304"
  "\310\323\326\327\305\306\314\301\300\304\311\316\322\343\345\350\316\317"
  "\321\310\307\311\310\311\314\302\306\313\342\343\345\302\302\303\300\305"
  "\311\316\321\327\352\353\356\342\343\344\273\276\277\305\314\316\311\312"
  "\314\315\320\322\311\312\316\307\305\312\316\322\324\324\325\327\335\337"
  "\344\326\326\331\317\320\323\305\306\312\307\312\314\304\306\311\306\313"
  "\317\361\364\366\367\370\371\366\367\370\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\366\367\370\371\371\372\377\377"
  "\377\245\256\271\255\265\276\377\377\377\371\372\372\366\367\370\366\367"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367"
  "\370\367\370\371\360\357\360\320\321\323\336\340\341\327\326\332\314\315"
  "\317\322\327\333\353\356\360\337\340\342\317\320\320\322\323\325\313\316"
  "\320\354\355\357\334\333\333\321\323\326\323\326\332\354\355\357\353\352"
  "\352\313\315\316\326\332\335\324\325\327\322\325\327\324\327\331\320\321"
  "\323\325\332\334\330\330\333\335\341\344\343\343\344\325\326\326\310\311"
  "\313\332\334\337\321\322\324\314\316\323\363\366\366\367\370\371\366\367"
  "\370\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\366\367\370\371\371\372\377\377\377\245\256\271\255\265\276\377\377"
  "\377\372\372\373\367\370\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\367\370\371\370\371\372\367\370"
  "\371\371\372\373\372\373\374\372\373\374\372\372\373\372\373\374\371\372"
  "\373\372\373\374\372\373\374\372\373\374\373\374\374\371\372\373\372\373"
  "\373\371\372\373\372\373\374\372\373\372\370\371\372\372\373\374\372\373"
  "\374\372\373\374\372\373\374\372\373\374\372\373\374\365\365\366\366\371"
  "\371\372\372\373\372\373\374\371\372\374\372\373\374\372\373\374\371\372"
  "\372\370\371\372\367\370\371\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\367\366\367\367\366\367\367\366\367\367\366\367"
  "\367\366\367\367\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\367\370\370\371\372\372\377\377"
  "\377\246\257\271\255\265\276\377\377\377\370\370\370\363\364\364\362\363"
  "\363\361\362\363\361\362\363\361\362\363\361\362\363\362\363\364\362\363"
  "\364\362\363\364\362\363\364\362\363\363\361\362\363\361\362\363\361\362"
  "\363\361\362\363\361\362\363\361\362\363\361\362\363\361\362\363\361\362"
  "\363\361\362\363\361\362\363\361\362\363\361\362\363\361\362\363\361\362"
  "\363\362\363\364\362\363\364\363\364\365\363\364\365\363\364\365\363\364"
  "\365\363\364\364\362\363\364\363\364\364\363\364\365\364\364\365\363\364"
  "\365\363\364\364\363\364\364\363\364\365\363\364\365\363\364\365\363\364"
  "\365\364\365\366\364\365\366\364\365\366\364\365\365\363\364\365\363\364"
  "\365\364\365\365\364\365\366\364\365\366\364\365\365\364\365\365\364\365"
  "\365\364\365\365\364\365\365\364\365\365\363\364\364\362\363\364\362\362"
  "\363\361\362\363\361\362\363\361\362\363\360\361\362\360\361\362\360\361"
  "\362\360\361\362\360\361\362\360\361\362\360\361\362\360\361\362\361\362"
  "\362\361\362\362\361\362\363\361\362\363\362\363\363\361\362\363\361\362"
  "\363\361\362\362\361\362\363\361\362\363\361\362\363\362\363\363\362\363"
  "\363\362\363\364\366\367\367\377\377\377\246\257\272\256\266\277\377\377"
  "\377\377\376\374\375\374\372\372\372\371\371\371\372\366\367\367\363\364"
  "\367\365\366\370\366\367\371\366\367\372\366\367\372\366\367\371\366\367"
  "\371\365\370\372\364\367\371\364\367\371\364\367\371\364\367\371\364\367"
  "\371\363\366\370\363\366\370\364\367\371\365\366\370\365\370\372\365\370"
  "\372\364\367\371\363\366\371\364\365\370\365\366\370\365\370\372\365\370"
  "\372\365\370\372\365\370\372\365\367\372\364\366\371\363\366\370\364\367"
  "\371\365\366\370\367\370\373\365\366\371\364\367\371\363\366\371\364\365"
  "\367\364\367\371\365\366\370\366\367\371\367\370\372\367\370\372\366\367"
  "\372\365\366\371\364\367\371\364\367\371\365\370\371\367\367\372\367\370"
  "\372\367\370\372\366\367\373\365\370\372\366\370\373\366\367\372\367\370"
  "\372\367\370\372\366\367\371\365\370\370\365\367\372\364\367\371\363\366"
  "\370\361\363\365\361\362\364\360\362\364\360\362\364\360\362\364\360\362"
  "\364\361\362\364\361\362\365\362\363\365\362\363\366\363\364\366\364\365"
  "\367\363\364\367\364\365\367\363\364\366\363\364\366\363\364\366\363\364"
  "\366\363\365\367\363\364\366\363\366\370\365\366\370\366\366\370\377\377"
  "\377\247\260\272\261\270\277\377\377\377\342\351\366\340\346\364\366\366"
  "\366\352\352\351\364\365\367\376\377\377\354\353\354\345\346\350\352\353"
  "\355\342\343\344\344\345\347\347\350\354\370\371\372\373\372\375\371\372"
  "\372\371\372\372\365\366\367\370\367\370\374\375\376\377\377\377\366\367"
  "\366\361\362\364\367\370\370\361\362\364\370\371\372\377\377\377\356\354"
  "\355\354\356\360\372\373\374\372\373\374\372\371\372\371\371\373\366\367"
  "\370\374\375\376\377\377\377\367\367\367\360\361\363\366\367\370\347\350"
  "\351\364\365\367\377\377\377\363\363\364\363\362\365\361\360\361\344\343"
  "\346\336\337\343\347\347\351\340\342\344\344\345\352\377\377\377\370\370"
  "\371\354\353\356\344\347\347\346\347\350\344\345\347\360\361\363\372\373"
  "\373\361\360\362\351\352\353\345\344\346\345\346\350\352\354\360\372\371"
  "\372\366\365\370\371\372\372\371\371\373\377\377\377\377\376\377\376\376"
  "\377\376\376\377\376\375\377\376\376\377\376\376\377\376\377\377\361\362"
  "\366\363\365\370\374\375\377\361\357\361\327\330\332\361\362\366\374\375"
  "\377\364\365\371\357\361\365\373\373\375\370\367\370\334\335\337\355\356"
  "\362\377\376\377\350\351\355\372\372\373\250\261\273\264\272\300\371\373"
  "\377_\236\347b\237\350\332\336\353\317\314\313\361\362\364\377\377\376\327"
  "\327\330\307\306\307\315\316\320\321\324\327\334\334\334\326\330\330\277"
  "\277\301\321\320\323\315\316\320\312\315\314\310\313\320\311\306\307\337"
  "\342\347\376\374\371\313\315\313\302\305\312\301\300\304\271\267\275\307"
  "\312\317\376\377\377\337\332\332\304\304\305\312\312\312\266\265\270\272"
  "\272\272\277\303\306\307\310\311\340\343\350\377\374\372\325\327\325\306"
  "\311\316\313\312\315\274\275\300\327\326\333\377\377\377\354\352\351\347"
  "\347\350\347\347\350\336\336\341\300\302\304\330\332\334\341\340\341\321"
  "\322\327\377\377\377\363\363\360\332\331\332\301\301\304\313\313\313\311"
  "\312\317\313\314\317\332\335\335\332\333\336\324\323\324\275\275\275\275"
  "\301\305\326\327\332\341\342\337\300\303\310\305\304\304\324\325\333\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\362\363\367\365\366\372\377\377\377\352\347\350\272"
  "\275\277\352\355\361\377\377\377\365\367\372\360\361\366\377\377\377\367"
  "\365\366\316\320\320\340\343\347\377\377\377\342\343\346\370\371\372\251"
  "\262\274\263\272\277\373\376\377\216\263\352x\250\347\343\350\362\354\354"
  "\350\365\366\370\377\377\377\370\370\367\365\364\365\362\362\361\357\356"
  "\357\357\356\357\362\362\363\355\355\355\362\361\362\361\363\362\365\366"
  "\365\372\372\372\362\362\361\360\357\360\362\361\357\343\344\345\363\364"
  "\365\357\357\357\361\361\361\357\357\357\370\370\371\365\365\366\363\363"
  "\362\364\365\364\361\360\361\361\362\361\364\363\364\365\364\365\357\361"
  "\361\366\365\365\360\361\360\363\364\363\363\363\363\363\362\363\366\364"
  "\365\366\370\367\371\371\372\377\377\376\374\374\375\376\375\374\366\365"
  "\364\367\371\371\373\372\371\355\357\355\367\366\367\373\374\373\373\372"
  "\371\362\361\362\361\360\361\364\365\366\365\365\363\371\371\372\375\375"
  "\375\367\366\365\364\364\363\364\364\365\366\366\366\352\351\346\334\337"
  "\341\340\340\336\340\343\347\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366"
  "\370\377\377\377\372\372\372\363\364\364\371\372\374\377\377\377\365\366"
  "\372\360\361\366\377\377\377\375\374\374\352\351\352\367\366\370\377\377"
  "\377\343\343\347\370\372\373\252\262\274\261\270\277\377\377\377\372\373"
  "\373\366\367\370\375\374\372\373\373\372\366\366\370\370\373\375\374\375"
  "\377\377\376\377\377\377\377\376\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\376\377\377\376\377\375\376\377\377\376\377\373\374"
  "\376\371\372\375\374\375\377\377\376\377\375\377\377\377\377\377\375\376"
  "\377\371\372\374\373\374\376\377\376\377\377\376\377\377\376\377\377\377"
  "\377\375\376\377\377\376\377\373\374\376\370\372\374\374\376\377\376\376"
  "\377\374\375\377\376\376\377\374\375\376\370\371\373\374\375\375\376\375"
  "\377\374\375\377\376\376\377\375\376\377\376\375\377\376\375\377\374\376"
  "\376\371\372\374\373\374\376\377\376\377\377\377\377\375\377\377\377\377"
  "\377\377\377\377\377\377\377\377\376\377\375\377\377\377\377\377\377\377"
  "\377\377\377\377\374\375\375\374\375\377\373\374\376\371\372\375\371\372"
  "\374\367\370\373\367\370\372\366\370\372\366\370\372\367\370\372\367\370"
  "\373\370\371\373\357\362\365\362\363\366\365\367\372\370\370\373\372\371"
  "\374\370\370\373\366\367\372\362\363\366\357\360\365\366\367\372\370\370"
  "\373\372\371\375\372\372\375\372\373\374\336\336\343\372\372\373\252\263"
  "\274\260\267\277\377\377\377\377\377\375\377\377\373\376\375\372\371\371"
  "\371\364\367\367\363\364\370\361\362\366\363\365\370\364\365\371\357\361"
  "\364\360\361\366\361\364\370\370\371\375\365\370\374\367\370\374\367\370"
  "\374\365\370\374\367\370\374\367\370\374\367\370\374\366\370\373\365\367"
  "\373\364\366\371\362\363\367\366\371\374\367\370\374\367\370\374\367\370"
  "\374\364\367\373\365\366\372\362\366\371\367\370\374\367\370\374\367\370"
  "\374\366\370\374\366\367\373\364\367\372\364\365\371\363\364\370\363\365"
  "\371\363\364\370\356\361\365\357\362\366\361\362\366\357\360\364\356\361"
  "\365\364\366\372\363\365\371\363\364\370\361\364\370\362\365\370\362\364"
  "\370\363\366\371\370\371\374\364\367\371\363\364\370\362\365\371\362\365"
  "\371\361\364\370\366\367\373\366\367\372\367\370\374\364\367\373\364\365"
  "\371\362\364\367\361\363\367\360\362\366\360\361\365\360\361\365\360\361"
  "\365\360\361\365\360\361\365\360\361\365\357\362\366\360\360\364\356\357"
  "\365\361\362\365\357\362\365\353\356\361\361\362\367\361\362\365\357\360"
  "\365\357\362\365\361\362\365\360\363\367\353\356\361\361\363\367\363\364"
  "\371\333\335\342\372\372\373\252\263\274\263\271\277\377\377\377\265\313"
  "\357\263\310\356\353\356\362\333\331\331\363\364\363\377\377\377\336\333"
  "\336\337\341\343\354\353\355\334\335\336\335\336\336\333\336\340\350\351"
  "\351\351\352\352\353\352\352\351\352\352\345\346\346\350\352\352\352\353"
  "\354\351\351\351\350\350\350\373\374\377\370\366\365\324\322\323\351\352"
  "\353\353\353\353\347\347\347\346\347\347\357\360\362\377\377\377\344\345"
  "\350\352\351\353\352\352\352\356\357\357\354\353\353\347\350\351\353\354"
  "\356\377\377\377\361\357\356\353\353\353\351\351\351\340\336\336\311\312"
  "\316\335\336\340\322\323\325\324\325\331\377\377\377\370\366\365\341\341"
  "\341\323\324\325\327\330\332\324\325\326\337\341\344\360\357\360\343\342"
  "\345\333\335\335\321\323\323\314\317\323\335\336\340\362\363\364\347\346"
  "\351\352\353\353\356\357\357\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\362\363\367\365\366\370\377\377\377\356\353\352\305\306"
  "\310\356\357\363\377\377\377\366\367\370\360\361\365\377\377\377\370\366"
  "\366\323\324\326\346\351\355\377\377\377\342\342\345\370\372\373\252\263"
  "\274\264\272\300\367\371\376f\237\351E\224\346\326\337\353\327\323\317\363"
  "\364\365\377\377\377\333\333\335\342\344\344\345\343\345\330\331\334\331"
  "\326\327\333\333\333\303\304\305\325\325\327\307\304\307\313\316\321\321"
  "\322\324\315\316\316\312\313\316\325\325\327\303\305\310\355\356\361\366"
  "\364\363\321\313\313\321\321\323\302\301\304\267\271\275\304\305\310\335"
  "\342\346\377\376\375\325\325\327\310\307\312\305\306\311\315\314\317\316"
  "\314\314\305\307\311\315\320\322\375\376\375\363\362\362\356\355\356\354"
  "\353\354\350\352\352\321\322\325\335\336\341\351\353\351\330\332\332\370"
  "\373\374\372\367\367\344\344\345\320\320\316\316\317\322\326\325\326\321"
  "\322\324\327\334\337\345\344\345\333\332\335\315\314\313\307\310\313\332"
  "\335\335\337\340\337\272\275\302\303\304\304\310\311\320\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\362\363\367\364\366\370\377"
  "\377\377\357\354\355\320\321\323\355\360\362\377\377\377\365\366\372\360"
  "\361\366\377\377\377\367\365\365\322\323\323\344\347\352\377\377\377\343"
  "\344\347\370\372\373\252\263\274\262\271\277\377\377\377\277\321\361\262"
  "\311\356\357\363\366\366\364\362\366\367\371\377\377\377\377\377\377\377"
  "\377\377\377\377\377\375\374\375\375\375\375\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\376\373\372\371\371\372\371\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\376\375\371\370\371\376\375\376\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\373\373\373\370"
  "\367\370\375\376\375\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\375\374\375\370\367\370\373\375\375\377\377\377\377"
  "\377\377\377\377\375\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\371\370\367\361\362\364\366"
  "\367\365\357\360\363\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\362\363\367\365\366\370\376\376\377\376\375\376\375\375\375\376"
  "\375\375\376\376\377\365\367\370\360\361\365\376\376\376\377\377\377\366"
  "\366\370\376\375\377\377\377\377\341\342\345\370\372\373\252\263\274\260"
  "\267\277\377\377\377\377\377\375\377\377\373\376\375\372\372\373\372\364"
  "\367\367\363\364\370\365\366\372\366\367\373\367\370\374\367\371\374\367"
  "\371\374\367\370\374\366\370\374\366\367\373\366\367\373\366\367\373\366"
  "\367\373\366\367\373\366\367\373\365\366\372\364\366\372\363\366\372\363"
  "\366\372\365\367\373\366\367\373\366\367\373\366\370\373\366\367\373\365"
  "\366\372\363\366\370\365\367\373\366\367\373\366\367\373\366\367\373\366"
  "\367\373\365\366\372\365\366\372\363\366\372\365\366\372\364\365\371\364"
  "\366\372\365\366\372\365\367\373\365\366\372\365\366\372\364\365\371\363"
  "\365\370\363\366\372\365\366\372\366\367\373\366\367\373\366\367\373\366"
  "\367\373\366\367\373\366\367\373\366\367\373\366\370\373\366\367\373\366"
  "\367\373\365\370\374\367\370\374\367\370\373\364\367\372\364\365\371\364"
  "\365\371\364\365\371\364\365\371\363\365\371\363\364\370\363\364\370\363"
  "\365\370\364\365\371\364\365\371\361\364\370\360\361\365\356\360\365\360"
  "\362\365\361\363\370\363\364\371\361\363\366\360\362\365\357\360\365\357"
  "\362\365\357\362\365\361\363\366\363\364\371\363\364\371\363\364\371\332"
  "\335\340\372\372\373\252\263\274\261\270\277\377\377\377\371\371\372\367"
  "\370\370\374\373\371\364\365\364\365\366\370\371\372\375\360\361\362\357"
  "\360\362\356\357\363\352\353\355\354\355\357\357\360\364\375\376\376\374"
  "\375\376\372\373\375\374\375\377\374\375\377\372\373\375\370\371\373\372"
  "\373\376\376\376\377\373\374\375\372\373\376\375\376\376\375\376\377\374"
  "\373\375\365\366\370\366\367\371\375\376\377\366\370\370\373\374\377\374"
  "\375\376\374\375\376\374\375\377\373\374\376\372\373\375\375\376\377\365"
  "\366\371\364\365\367\373\374\376\375\376\377\372\373\375\367\370\372\375"
  "\376\377\372\372\374\375\376\377\366\367\371\367\371\374\374\375\377\374"
  "\375\377\365\370\372\375\376\377\375\375\377\374\375\377\371\372\373\362"
  "\363\367\373\374\376\375\376\377\375\376\376\375\376\377\374\375\377\373"
  "\374\376\374\375\375\364\365\367\356\357\361\357\360\362\355\356\360\360"
  "\361\365\373\374\376\365\367\371\363\362\364\356\360\362\354\355\361\372"
  "\371\373\361\364\370\362\364\367\370\371\373\363\362\364\344\345\350\363"
  "\364\367\370\371\373\363\364\367\357\360\365\366\367\373\366\365\367\345"
  "\347\352\361\362\365\373\373\375\336\336\343\372\372\373\252\263\274\264"
  "\272\277\374\374\377\177\253\351}\251\351\336\345\355\322\320\315\361\362"
  "\362\377\377\376\327\331\332\317\320\323\323\324\326\325\326\327\336\336"
  "\336\330\332\334\316\317\320\320\323\325\316\316\317\316\321\321\314\315"
  "\317\323\324\326\322\323\326\322\323\326\377\377\377\353\347\344\325\326"
  "\327\326\331\333\340\337\341\322\322\324\313\314\312\313\320\322\377\377"
  "\377\337\336\332\324\330\330\313\312\314\323\324\327\320\321\322\320\321"
  "\323\341\342\346\377\377\376\316\317\320\306\311\314\330\334\336\337\334"
  "\334\316\315\317\314\320\324\335\332\333\321\322\325\374\375\376\354\353"
  "\350\321\321\323\316\315\320\323\324\324\304\311\315\350\351\351\321\316"
  "\317\313\316\320\310\313\315\312\315\316\320\321\325\325\325\325\320\317"
  "\321\321\322\322\315\316\321\327\330\334\363\363\363\332\333\334\315\315"
  "\315\313\316\317\313\314\317\320\317\317\332\333\333\341\340\341\330\326"
  "\326\302\303\306\271\271\273\364\362\357\365\366\372\366\367\371\377\377"
  "\377\352\350\346\272\275\277\352\355\361\377\377\377\366\367\372\360\361"
  "\366\377\377\377\370\366\366\317\320\320\340\343\347\377\377\377\342\343"
  "\346\367\371\372\251\262\274\264\272\300\371\373\377q\246\351T\230\346\333"
  "\341\355\343\341\335\366\367\367\377\377\377\354\352\350\340\336\335\336"
  "\336\340\336\336\340\336\336\340\342\343\345\326\327\332\347\350\352\354"
  "\353\352\337\340\341\333\335\337\352\351\354\340\342\342\325\327\331\366"
  "\365\366\353\351\350\326\330\331\333\334\337\333\332\335\350\350\352\342"
  "\342\340\341\342\345\367\367\370\352\351\347\333\335\340\320\315\316\320"
  "\322\324\331\330\331\335\336\340\353\353\353\371\370\370\341\342\343\342"
  "\343\346\344\344\345\333\331\334\331\332\333\333\333\335\323\322\323\317"
  "\320\323\364\366\366\362\362\363\347\344\344\323\322\323\316\315\317\336"
  "\341\343\361\361\361\333\333\333\333\334\335\330\331\332\340\337\340\323"
  "\324\324\334\334\334\313\314\316\326\327\333\330\331\333\346\351\353\376"
  "\375\376\360\362\363\344\343\342\334\333\334\344\347\347\343\344\346\347"
  "\350\351\363\364\363\356\356\355\342\344\345\334\335\336\374\373\372\364"
  "\366\371\365\367\372\377\377\377\365\363\364\346\346\346\364\365\367\377"
  "\377\377\365\366\372\360\361\366\377\377\377\372\370\371\331\331\333\356"
  "\357\361\377\377\377\361\361\363\373\373\374\250\261\273\261\270\277\377"
  "\377\377\347\354\366\341\351\364\371\372\371\371\372\371\366\367\371\375"
  "\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\372\372\373\375\376\377\376\377\376\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\372\372\372\377"
  "\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\372\372\372\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\376\376\377\373\374\375\375\376\377\377"
  "\377\377\377\377\377\375\376\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\376\377\377\362\363\367\364\365\370\373\374\374\374"
  "\373\375\375\374\376\374\373\375\373\374\374\364\365\370\356\361\365\373"
  "\372\374\374\375\375\373\373\375\375\374\376\374\375\375\372\373\376\376"
  "\376\377\247\260\272\260\267\277\377\377\377\377\377\375\377\377\373\375"
  "\375\372\372\373\372\364\367\367\361\364\370\362\364\370\364\367\373\365"
  "\366\372\363\366\372\365\366\372\364\365\371\365\366\372\365\366\372\364"
  "\366\372\365\366\372\365\366\372\364\365\371\363\365\371\364\365\371\363"
  "\364\370\362\365\371\365\366\372\364\366\372\364\365\371\364\365\371\364"
  "\366\371\362\365\371\363\364\370\362\365\371\364\366\372\365\366\372\365"
  "\366\372\363\366\372\363\364\370\361\364\370\363\364\370\363\364\370\364"
  "\365\371\363\366\372\365\366\372\365\366\372\363\366\372\365\366\372\365"
  "\366\372\365\366\372\365\366\372\365\366\372\365\367\373\365\366\372\364"
  "\365\371\363\365\371\364\365\371\365\366\372\366\367\373\364\367\373\366"
  "\367\373\365\367\373\365\367\373\365\366\372\364\366\372\363\365\370\363"
  "\364\370\362\365\371\364\365\371\365\367\373\364\367\373\364\367\372\365"
  "\366\372\362\365\371\363\366\372\364\367\373\364\365\371\362\365\371\361"
  "\362\366\357\360\365\357\362\365\360\362\367\360\361\366\360\361\366\357"
  "\362\365\357\360\365\357\362\363\357\360\365\360\363\366\360\361\366\361"
  "\362\367\360\363\366\362\363\370\375\377\376\246\257\271\262\270\277\377"
  "\377\377\335\346\365\331\342\363\365\366\367\351\351\350\364\365\365\376"
  "\377\377\352\347\350\343\344\346\346\347\351\337\336\340\340\340\342\343"
  "\345\351\367\367\371\366\366\370\362\363\364\366\367\370\366\367\370\364"
  "\365\365\360\361\363\366\366\370\377\377\377\363\363\364\361\363\363\371"
  "\372\373\372\374\374\373\372\374\362\361\362\353\354\357\377\377\377\365"
  "\364\365\361\363\365\366\370\370\371\370\370\352\355\360\377\377\377\366"
  "\365\364\357\362\364\377\377\377\371\371\370\355\356\356\362\364\364\370"
  "\370\370\356\357\357\367\370\370\371\370\370\366\370\370\367\370\370\367"
  "\367\367\360\361\361\357\360\362\372\374\374\377\376\377\371\370\371\371"
  "\370\370\362\363\364\350\352\353\364\365\367\371\372\373\367\366\367\370"
  "\370\370\367\367\367\370\371\371\374\374\374\354\353\356\341\341\343\344"
  "\346\350\340\342\344\345\350\352\370\371\372\362\361\362\354\353\354\342"
  "\343\343\335\334\340\373\372\373\363\366\370\364\365\371\376\375\377\361"
  "\357\357\317\322\324\361\363\366\376\375\377\364\365\370\357\362\365\374"
  "\375\376\370\367\367\330\327\333\352\355\357\377\376\377\373\374\375\375"
  "\375\376\246\257\271\264\272\300\371\373\376]\234\347a\235\350\330\336\353"
  "\315\313\307\361\362\364\377\377\376\327\326\331\322\324\324\312\314\316"
  "\323\324\330\334\334\334\326\330\330\273\277\277\313\317\321\313\314\315"
  "\277\302\305\273\276\301\315\316\321\306\312\314\300\303\310\374\374\376"
  "\345\341\340\271\270\273\306\306\311\317\322\322\313\310\315\274\275\300"
  "\314\316\322\370\371\372\354\353\350\313\311\314\272\271\274\275\300\302"
  "\272\275\277\363\366\371\355\352\346\316\321\324\376\377\376\323\322\321"
  "\276\304\310\313\311\313\316\315\320\276\275\302\315\314\317\304\307\307"
  "\312\311\313\305\305\307\274\273\275\277\302\307\316\315\321\312\316\320"
  "\345\344\345\274\274\274\273\276\301\270\275\277\305\306\310\304\307\312"
  "\306\307\310\271\273\276\305\306\307\272\274\276\314\317\326\357\360\357"
  "\334\335\340\313\310\311\310\312\314\317\316\320\316\315\315\314\315\320"
  "\341\342\343\330\325\326\301\303\305\273\272\273\364\362\356\365\366\372"
  "\366\367\373\377\377\377\353\347\350\300\301\304\352\355\360\377\377\377"
  "\365\367\372\360\361\366\377\377\377\367\365\365\316\317\317\337\342\346"
  "\377\377\377\376\375\377\374\375\376\246\257\271\263\271\277\375\375\377"
  "\227\271\354\205\254\351\346\351\361\357\355\353\365\370\370\377\377\377"
  "\372\371\370\370\367\366\364\363\364\362\362\362\362\362\362\366\365\366"
  "\362\361\362\372\372\373\374\375\374\367\370\367\365\366\365\374\373\374"
  "\370\370\367\361\360\361\365\364\365\363\363\364\361\361\361\367\366\367"
  "\367\370\367\363\363\362\363\364\363\371\371\371\366\365\364\364\366\367"
  "\372\372\371\357\357\356\343\344\346\367\367\367\365\364\365\361\361\361"
  "\360\361\362\365\364\363\340\341\342\365\367\367\374\372\373\367\367\367"
  "\370\370\366\365\365\364\334\335\336\357\360\362\370\365\366\345\344\343"
  "\363\364\367\373\373\371\346\350\352\377\377\377\367\367\366\365\364\365"
  "\363\364\363\364\365\364\353\354\355\366\365\364\351\351\347\360\361\362"
  "\365\365\365\373\374\374\377\377\377\377\376\376\367\367\366\363\362\363"
  "\367\366\367\366\367\366\367\370\371\376\377\376\372\372\373\366\365\366"
  "\364\365\364\377\377\376\364\365\371\365\366\370\377\377\377\374\372\372"
  "\366\366\366\372\374\374\377\377\377\365\366\370\360\361\366\376\377\377"
  "\375\375\374\355\355\355\367\367\371\377\377\377\376\375\377\374\375\376"
  "\246\257\271\260\267\277\377\377\377\375\374\373\371\372\371\375\376\372"
  "\373\373\372\364\366\370\370\371\373\374\375\376\375\376\377\376\377\377"
  "\376\377\377\376\377\377\376\377\377\375\377\377\375\376\377\375\376\377"
  "\375\376\376\374\375\376\374\375\376\375\376\377\375\374\377\371\372\374"
  "\373\374\376\374\375\376\374\376\376\375\376\377\375\376\377\375\376\377"
  "\374\374\376\370\371\373\370\371\374\375\376\377\376\375\377\372\373\375"
  "\375\376\376\371\372\374\371\372\374\373\374\376\371\372\374\371\372\374"
  "\375\376\377\375\376\376\375\376\377\376\377\377\377\377\377\374\375\377"
  "\375\377\377\377\377\377\374\375\377\375\377\377\376\375\377\372\374\376"
  "\376\377\377\376\377\377\376\377\377\376\377\377\376\376\377\375\376\377"
  "\377\377\377\376\377\377\375\376\377\375\377\377\374\375\376\373\373\375"
  "\373\374\375\373\374\375\373\374\375\373\374\375\373\374\375\372\374\374"
  "\372\371\374\372\374\374\373\374\377\371\372\375\367\370\372\360\363\365"
  "\360\363\367\366\367\371\367\370\372\370\371\375\367\370\371\366\367\370"
  "\361\363\367\357\360\365\366\365\370\366\370\371\370\371\373\367\370\372"
  "\367\370\371\365\366\371\375\375\376\246\257\271\260\267\277\377\377\377"
  "\377\377\375\377\377\373\376\376\372\371\372\371\365\365\367\363\366\372"
  "\361\362\366\364\367\371\365\366\370\356\361\363\356\361\365\361\362\366"
  "\370\371\375\367\372\374\365\366\372\366\367\373\367\370\374\365\370\373"
  "\365\370\372\366\367\373\366\367\373\366\371\373\367\370\372\365\370\373"
  "\365\366\372\367\370\374\367\372\374\366\371\373\366\370\372\365\367\373"
  "\365\366\372\365\366\372\366\371\373\367\370\372\366\367\373\367\370\374"
  "\365\366\372\366\367\373\367\370\374\363\366\370\364\365\371\363\364\370"
  "\356\360\363\356\360\364\356\361\365\360\363\367\357\360\363\362\365\371"
  "\366\367\373\363\365\371\362\363\367\362\363\367\362\363\367\363\364\370"
  "\370\373\375\366\367\373\364\365\371\363\366\372\363\364\370\362\363\367"
  "\366\367\373\365\367\373\366\371\374\365\366\372\365\366\370\362\364\367"
  "\361\364\367\361\364\366\361\364\366\360\363\366\361\364\366\361\364\366"
  "\361\364\367\362\365\367\360\361\364\357\361\365\361\364\367\361\362\366"
  "\351\354\357\361\362\367\361\364\367\357\362\365\357\362\365\361\362\367"
  "\362\363\367\352\354\361\357\362\366\362\365\370\362\365\370\375\375\376"
  "\246\257\271\263\271\277\377\377\377\251\302\356\247\300\354\350\353\362"
  "\330\325\325\361\362\364\377\377\377\335\334\335\334\335\335\337\336\341"
  "\334\335\335\336\337\337\333\334\340\344\345\347\360\360\362\333\327\331"
  "\344\346\350\377\377\377\367\365\364\340\343\344\342\341\341\326\331\331"
  "\352\355\356\377\377\377\360\360\357\342\343\343\343\342\345\343\344\344"
  "\350\351\353\377\377\377\362\361\360\335\337\341\336\335\341\357\360\362"
  "\377\377\377\357\356\355\340\341\341\340\341\343\344\345\347\377\377\377"
  "\367\364\363\347\347\351\343\343\347\344\342\343\336\337\340\327\332\333"
  "\331\330\331\333\334\336\370\371\374\375\373\372\341\340\341\323\322\325"
  "\321\324\326\323\324\326\330\331\333\353\354\355\343\343\343\335\333\335"
  "\321\321\323\310\307\311\330\331\335\361\362\362\344\343\343\346\350\350"
  "\347\350\351\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367"
  "\365\366\370\377\377\377\354\352\352\303\304\306\354\357\363\377\377\377"
  "\366\367\370\360\361\365\377\376\377\370\365\366\322\324\324\343\346\352"
  "\377\377\377\374\375\377\375\375\376\246\257\271\264\272\300\367\373\376"
  "e\241\351E\224\346\330\336\353\331\327\323\363\364\365\377\377\377\336\336"
  "\336\325\325\325\315\316\321\331\331\333\327\327\331\333\335\335\305\307"
  "\307\317\320\325\314\310\312\322\323\326\370\371\372\352\345\342\303\310"
  "\315\313\314\321\304\307\306\324\327\331\376\376\375\336\333\332\321\320"
  "\323\314\314\316\304\303\306\314\317\325\375\374\375\336\335\334\324\326"
  "\330\325\324\326\323\330\334\375\376\375\336\340\340\307\310\310\307\314"
  "\320\334\333\340\371\371\371\370\370\365\356\355\356\351\351\353\354\353"
  "\354\362\363\362\350\345\346\333\334\335\350\352\352\376\377\377\374\374"
  "\371\347\347\350\326\325\326\316\317\321\332\333\333\323\324\326\327\330"
  "\331\352\351\352\337\335\336\322\323\324\315\314\315\331\333\335\343\344"
  "\343\300\277\301\303\304\307\303\304\311\376\376\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\362\363\367\364\366\370\377\377\377\360\356\355\324\325"
  "\327\357\360\364\377\377\377\365\366\372\360\361\366\377\377\377\371\367"
  "\365\323\323\325\344\347\353\377\377\377\376\375\377\374\375\376\246\257"
  "\271\262\271\277\377\377\377\312\330\361\277\320\357\362\364\366\367\365"
  "\364\366\367\371\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\376\371\372\371\373\373\374\377\377\377\377\377\377\377\377\377\376\375"
  "\375\370\370\371\376\376\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\371\372\371\375\375\375\377\377\377\376\376\374\367\366\366\371\370"
  "\371\377\376\377\377\377\377\377\377\377\377\377\377\370\367\370\375\374"
  "\375\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\376\376"
  "\377\377\377\377\373\373\372\373\373\374\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\375\374\373\361\362\363\372\371\372\357\360"
  "\360\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\360\363\367\365\366"
  "\370\376\376\377\375\375\375\375\375\377\376\375\377\376\376\376\365\366"
  "\370\360\361\365\376\376\376\377\377\377\370\367\371\375\374\376\377\377"
  "\377\374\375\377\374\375\376\246\257\271\260\267\277\377\377\377\377\377"
  "\375\377\377\373\376\375\372\372\373\372\364\367\367\363\364\370\364\367"
  "\373\367\370\374\366\370\374\366\371\375\370\371\374\365\370\374\365\370"
  "\373\364\367\373\364\367\373\364\367\373\364\367\371\364\367\373\364\366"
  "\372\363\366\372\363\366\372\363\366\372\362\365\367\362\365\371\363\366"
  "\372\364\367\373\365\370\373\365\370\373\364\367\371\364\367\373\364\367"
  "\373\364\367\373\364\367\373\363\366\370\364\366\372\364\367\373\365\367"
  "\373\365\367\373\364\367\372\363\366\372\363\366\372\363\366\372\363\366"
  "\371\362\365\371\363\366\371\364\367\372\364\367\373\364\367\373\365\367"
  "\373\365\367\373\364\367\373\364\367\373\367\370\374\367\370\374\365\370"
  "\374\365\370\373\364\367\373\364\367\373\364\367\373\364\366\372\363\366"
  "\372\363\366\371\362\365\371\361\364\370\360\362\366\356\361\365\356\361"
  "\365\356\361\365\356\361\365\356\361\365\356\361\365\356\361\365\356\361"
  "\365\357\362\364\360\360\364\356\361\365\360\361\365\362\363\367\363\364"
  "\370\362\363\366\360\361\365\357\362\365\357\362\365\356\361\365\361\362"
  "\366\363\364\367\362\363\367\361\362\366\362\364\370\375\375\376\246\257"
  "\271\261\270\277\377\377\377\365\366\372\362\364\370\373\373\371\361\361"
  "\362\365\366\370\373\374\375\360\360\362\351\353\355\356\357\361\351\352"
  "\354\350\353\355\355\356\362\373\374\376\376\377\377\367\366\370\374\375"
  "\377\374\373\375\372\373\375\371\372\374\375\376\377\373\372\374\366\367"
  "\371\372\373\376\376\377\377\372\373\375\374\373\375\364\365\367\361\360"
  "\364\370\371\373\374\375\376\372\373\374\370\371\373\372\373\375\376\377"
  "\377\375\375\377\375\376\377\372\373\373\361\362\366\372\373\374\375\376"
  "\377\374\374\376\374\375\375\374\375\377\373\374\376\375\375\377\364\363"
  "\366\357\356\360\356\357\361\354\355\357\355\360\362\373\374\376\370\370"
  "\372\362\363\365\356\357\361\353\354\360\356\357\361\367\370\372\371\372"
  "\372\374\375\375\372\373\374\375\374\376\373\374\376\372\373\375\371\372"
  "\375\371\372\374\370\371\374\370\371\374\370\371\374\370\371\374\370\371"
  "\374\370\371\374\370\371\374\371\372\374\372\373\373\357\362\366\362\363"
  "\366\370\371\373\361\361\363\340\341\345\363\364\367\370\371\373\362\363"
  "\367\357\362\365\370\371\373\366\365\367\343\344\346\356\361\364\373\372"
  "\374\367\370\373\375\375\376\246\257\271\264\272\277\372\374\377x\247\351"
  "r\245\347\335\343\355\321\316\315\361\362\362\377\377\376\327\327\330\307"
  "\310\311\321\324\326\325\324\327\334\336\336\330\331\332\314\315\315\333"
  "\335\341\311\307\311\331\333\335\315\314\316\314\315\317\310\315\321\366"
  "\367\367\365\364\362\311\312\315\352\355\357\376\375\373\335\334\335\315"
  "\316\316\306\312\312\311\310\316\312\313\320\321\324\323\313\316\320\323"
  "\324\324\316\317\321\350\350\352\320\320\320\304\306\310\306\311\311\310"
  "\313\315\310\313\317\324\325\325\306\307\313\317\320\322\311\312\314\320"
  "\323\324\361\362\363\334\331\334\313\315\315\311\314\315\310\311\315\316"
  "\317\322\320\324\330\341\342\343\332\330\331\307\307\307\266\267\273\311"
  "\312\317\347\352\352\326\325\325\315\314\317\320\321\324\370\370\372\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\362\363\367\365\366\372\377\377\377\352\350\346\272\273\277\352"
  "\355\361\377\377\377\366\367\372\360\361\366\377\377\377\367\365\366\316"
  "\320\320\337\342\346\377\377\377\376\375\377\374\375\376\246\257\271\264"
  "\272\277\371\373\377y\250\351[\234\347\335\343\356\345\343\340\366\367\370"
  "\377\377\377\360\356\355\351\353\353\345\344\345\342\343\343\343\343\343"
  "\347\350\351\336\335\337\337\337\341\343\343\343\337\336\337\350\351\352"
  "\353\354\354\351\351\353\364\364\365\362\364\361\350\347\352\361\360\361"
  "\366\364\365\344\345\346\334\336\336\343\344\345\354\354\354\346\346\346"
  "\351\353\353\357\356\361\351\352\351\335\335\337\362\363\364\346\343\344"
  "\340\341\342\337\340\340\345\346\347\326\327\331\344\345\345\322\324\324"
  "\331\332\335\341\340\341\351\353\355\377\377\377\365\365\366\355\352\353"
  "\343\342\343\347\350\351\350\351\352\350\352\352\366\366\367\362\361\362"
  "\350\350\351\344\345\346\351\350\351\356\356\354\321\322\323\327\330\332"
  "\311\313\315\366\367\372\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\362\363\367\364\366\371\377\377\377"
  "\367\365\365\352\352\352\365\366\370\377\377\377\365\366\372\360\361\366"
  "\377\377\377\372\372\372\335\336\336\357\360\362\377\377\377\376\375\377"
  "\374\375\376\246\257\271\261\270\277\377\377\377\354\360\370\350\354\366"
  "\373\373\371\371\372\371\366\367\371\373\375\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\373\373\374"
  "\372\373\374\377\377\377\376\375\376\372\374\374\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\373\375\375\377\377\377\372\371\373\376\377\377\375\375\377"
  "\374\374\376\373\373\376\373\373\376\373\373\376\373\373\376\373\373\376"
  "\373\373\376\373\373\376\373\373\376\373\373\376\374\374\376\373\375\375"
  "\361\362\365\361\364\366\373\372\374\374\373\375\373\374\376\372\373\375"
  "\373\372\374\362\365\366\357\361\365\371\372\374\374\373\375\373\373\375"
  "\373\374\376\374\373\375\371\372\375\375\375\376\246\257\271\260\267\277"
  "\377\377\377\377\377\375\377\377\373\376\375\372\372\373\372\364\367\367"
  "\361\364\370\363\364\370\364\365\371\365\366\372\363\364\370\363\366\372"
  "\363\365\371\366\367\372\365\366\372\363\366\372\365\366\372\364\366\372"
  "\364\365\371\364\365\371\362\364\370\363\364\370\364\365\371\364\366\372"
  "\365\366\372\363\366\371\364\365\371\362\365\371\365\366\372\363\366\372"
  "\363\366\372\365\366\372\364\366\372\364\365\371\363\364\370\362\364\370"
  "\362\365\371\363\366\371\363\365\370\363\364\371\363\366\372\365\366\372"
  "\364\365\371\363\365\371\363\364\370\361\365\371\363\364\370\364\366\371"
  "\365\366\372\364\366\371\365\366\372\364\366\372\363\366\372\364\366\371"
  "\365\366\372\365\366\372\364\367\372\364\366\372\365\366\372\365\366\372"
  "\362\364\370\360\361\365\356\360\364\356\357\363\356\357\363\356\357\363"
  "\355\357\363\355\357\363\355\357\363\355\357\363\355\357\363\356\357\363"
  "\356\357\363\356\360\364\357\361\364\357\361\364\356\357\365\357\362\365"
  "\360\362\367\356\361\364\360\361\367\357\362\365\357\362\365\357\362\363"
  "\357\362\365\360\363\366\360\361\364\361\362\367\360\363\366\362\363\370"
  "\375\375\376\246\257\271\262\271\277\377\377\377\324\337\363\322\335\363"
  "\362\364\365\346\346\344\362\363\365\377\377\377\346\346\345\336\337\340"
  "\345\346\350\334\335\337\335\336\340\340\341\345\364\365\365\372\373\374"
  "\353\353\353\370\371\372\362\363\364\360\361\361\360\360\362\377\377\377"
  "\377\375\374\363\364\365\365\364\365\345\344\344\347\350\354\377\377\377"
  "\362\360\360\353\354\356\352\353\352\360\361\363\365\366\367\367\366\366"
  "\363\363\363\375\375\377\377\377\377\353\352\355\356\355\360\353\351\350"
  "\332\333\337\332\333\335\334\335\340\337\340\342\353\356\360\377\377\377"
  "\356\354\355\342\342\342\341\342\344\333\335\337\334\336\342\361\363\365"
  "\364\363\364\354\353\353\335\336\340\327\330\332\337\340\342\360\363\363"
  "\360\362\363\363\364\364\363\364\364\375\375\375\377\377\377\377\377\377"
  "\377\377\377\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377"
  "\377\376\377\377\376\377\377\376\377\377\376\377\377\377\377\377\377\377"
  "\360\363\367\363\365\370\375\377\377\360\355\355\313\314\320\360\363\366"
  "\376\377\377\364\365\370\357\361\365\375\375\376\370\367\367\324\325\327"
  "\351\354\357\377\377\377\373\374\375\375\375\376\246\257\271\264\272\300"
  "\370\373\376^\235\347Z\233\350\330\337\353\315\313\307\363\362\364\377\377"
  "\376\330\327\332\301\301\301\307\310\315\325\326\331\334\334\334\330\330"
  "\332\273\277\301\316\317\324\304\301\303\313\315\321\307\310\314\310\313"
  "\315\306\311\320\363\364\365\356\354\351\306\307\310\271\273\277\273\271"
  "\275\315\317\325\372\374\374\350\344\345\305\307\311\305\313\311\314\316"
  "\320\273\272\277\301\300\303\271\271\275\347\354\357\377\377\377\341\340"
  "\343\347\347\350\352\352\353\353\355\354\346\347\346\322\321\322\317\320"
  "\321\345\351\353\377\377\377\345\343\342\325\323\324\306\311\312\317\320"
  "\320\320\321\323\314\315\316\340\342\344\335\335\335\316\314\314\275\277"
  "\301\305\306\312\340\344\345\313\313\316\302\305\307\277\300\304\356\357"
  "\362\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\361\363\367\365\366\370\377\377\377\353\351"
  "\350\304\306\310\353\355\360\377\377\377\365\367\372\360\361\366\377\377"
  "\377\367\365\365\316\317\321\337\342\346\377\377\377\376\375\377\374\375"
  "\376\246\257\271\263\271\277\375\377\377\240\275\354\216\262\352\350\355"
  "\363\361\357\355\367\370\372\377\377\377\376\373\374\372\374\372\370\367"
  "\370\366\365\366\365\365\366\371\371\371\366\365\366\365\367\365\371\371"
  "\367\365\364\365\374\373\374\375\375\375\373\372\373\365\364\365\352\352"
  "\351\360\361\362\367\367\370\371\370\371\373\372\373\364\363\364\364\366"
  "\366\367\367\367\372\373\372\373\372\373\361\361\361\335\336\336\362\363"
  "\364\364\363\364\365\365\366\374\376\375\377\377\377\376\376\375\377\377"
  "\377\376\376\375\367\364\365\363\363\363\364\363\362\364\365\364\376\375"
  "\375\374\373\373\366\365\366\370\367\370\371\371\372\372\372\371\377\376"
  "\377\377\375\376\371\371\372\371\372\371\372\372\372\372\372\371\344\345"
  "\345\355\356\357\334\335\336\370\371\372\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363"
  "\367\365\366\370\377\377\377\374\374\374\370\370\370\374\374\374\377\377"
  "\377\365\366\370\360\361\366\376\376\377\376\375\375\357\356\360\371\371"
  "\372\377\377\377\376\375\377\374\375\376\246\257\271\260\267\277\377\377"
  "\377\377\376\373\375\374\371\376\375\372\372\373\372\364\367\370\366\367"
  "\373\373\374\376\374\375\377\374\376\377\375\376\377\374\376\377\374\375"
  "\377\374\375\377\374\375\377\374\375\377\373\375\377\373\374\377\373\374"
  "\376\373\374\376\371\372\374\370\371\375\374\375\377\373\374\376\372\373"
  "\375\371\372\374\366\370\372\367\370\372\371\372\374\371\372\375\371\373"
  "\375\372\373\376\371\372\374\372\373\375\367\370\372\366\367\371\367\370"
  "\373\367\370\373\367\370\373\367\370\373\370\371\374\370\372\374\371\372"
  "\374\366\370\372\364\365\372\370\371\374\370\372\374\371\372\375\371\372"
  "\375\371\372\374\370\372\374\370\371\374\370\371\374\371\372\374\371\372"
  "\375\371\372\375\371\372\375\370\371\374\372\373\376\370\371\373\366\371"
  "\373\366\367\372\365\366\371\364\366\371\364\366\370\364\366\370\364\366"
  "\370\364\366\370\364\366\370\364\366\370\364\366\370\364\366\370\365\366"
  "\371\365\366\371\365\366\372\357\360\364\360\361\364\364\365\370\365\366"
  "\372\366\367\373\365\366\372\364\365\370\361\362\365\357\360\365\364\365"
  "\370\365\366\371\366\367\373\366\367\372\365\366\371\365\366\371\375\375"
  "\376\246\257\271\260\267\277\377\377\377\377\377\373\376\376\371\377\376"
  "\373\370\370\367\365\365\367\365\370\372\361\362\365\361\362\364\356\357"
  "\363\357\360\363\356\360\363\362\363\367\372\374\377\372\373\377\372\373"
  "\377\372\375\377\372\373\375\366\367\371\366\367\371\367\370\374\367\371"
  "\375\371\372\376\370\371\373\367\370\372\365\366\371\364\365\370\364\365"
  "\370\364\365\370\364\365\370\364\365\370\364\366\370\365\366\371\364\366"
  "\370\364\365\370\364\365\370\363\365\370\363\365\367\363\365\367\363\365"
  "\367\364\365\370\364\365\370\364\365\370\364\365\370\364\365\370\364\365"
  "\370\364\365\370\364\365\370\364\365\370\364\365\370\364\365\370\364\365"
  "\370\364\365\370\364\365\370\364\365\370\364\365\370\364\365\370\365\366"
  "\370\365\366\370\364\366\370\364\365\370\363\364\367\363\364\367\363\364"
  "\367\363\364\367\363\364\367\363\364\367\363\364\367\363\364\367\363\364"
  "\367\363\364\367\363\364\367\363\364\367\363\365\367\363\366\370\357\360"
  "\364\360\361\365\362\365\371\361\362\366\351\352\357\361\364\367\363\365"
  "\367\361\362\365\357\360\365\362\364\367\364\363\367\352\354\357\357\362"
  "\365\365\366\372\364\366\372\375\375\376\246\257\271\263\271\277\376\377"
  "\377\237\274\354\235\273\353\347\352\360\326\324\323\361\362\364\377\377"
  "\376\332\332\334\333\334\334\334\335\340\331\331\333\336\337\337\334\335"
  "\337\340\341\343\342\342\342\344\343\344\343\343\343\341\342\345\334\336"
  "\336\335\336\337\363\365\363\340\337\336\341\342\343\342\343\345\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\362\363\367\365\366\370\377\377\377\354\352"
  "\350\300\302\304\354\357\363\377\377\377\366\367\370\360\361\367\377\377"
  "\377\370\366\366\320\322\323\343\346\351\377\377\377\376\375\377\374\375"
  "\376\246\257\271\264\272\300\370\373\376f\237\351E\224\346\330\336\353\333"
  "\330\325\365\365\365\377\377\377\337\336\337\344\346\350\353\355\353\334"
  "\333\335\331\330\333\336\337\340\301\301\303\303\302\306\277\274\300\310"
  "\312\314\305\306\311\327\331\333\332\333\340\346\347\346\301\301\303\305"
  "\307\313\303\304\307\375\376\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\364"
  "\366\370\377\377\377\362\360\356\331\331\333\360\361\363\377\377\377\365"
  "\366\372\360\361\366\377\377\377\371\367\367\323\325\325\346\351\355\377"
  "\377\377\376\375\377\374\375\376\246\257\271\262\271\277\377\377\377\321"
  "\335\363\311\327\361\364\365\370\367\367\365\366\367\371\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\375"
  "\375\375\374\375\376\372\373\374\375\376\375\375\374\374\377\377\377\377"
  "\377\377\375\374\375\365\366\367\374\376\374\363\362\365\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\360\363\367\363\364\370\376\375\376\376\375\375\375"
  "\376\376\376\375\377\376\376\376\364\365\370\360\361\365\375\374\376\375"
  "\375\377\372\371\373\375\376\376\377\376\377\374\373\375\374\375\376\246"
  "\257\271\260\267\277\377\377\377\377\377\375\377\377\373\376\375\372\372"
  "\373\372\364\367\367\361\364\370\364\365\371\365\370\372\365\370\373\366"
  "\367\373\366\371\373\366\367\373\366\371\373\366\371\373\366\371\373\366"
  "\370\373\365\366\372\364\366\371\364\367\371\365\367\372\365\370\372\365"
  "\370\374\364\365\371\362\363\367\362\365\367\361\363\367\361\362\367\361"
  "\364\366\360\362\366\360\361\365\360\361\366\360\364\366\361\363\367\362"
  "\363\370\362\364\370\362\365\367\362\365\367\361\362\367\360\361\366\361"
  "\362\366\362\365\367\362\366\370\363\364\370\362\364\370\362\365\367\361"
  "\364\367\362\365\367\362\364\370\363\366\370\363\366\370\362\363\367\361"
  "\363\367\361\364\367\361\362\366\360\361\365\356\360\364\356\357\364\356"
  "\357\363\356\357\363\355\357\363\355\357\363\355\357\363\355\357\363\355"
  "\357\363\355\357\363\355\357\363\355\357\363\355\357\363\355\357\363\355"
  "\357\363\356\357\363\356\357\363\356\357\364\357\361\364\357\360\364\356"
  "\361\365\356\361\365\360\363\367\361\364\370\360\363\366\357\361\365\357"
  "\362\365\357\362\363\357\362\365\357\362\366\361\364\367\360\363\367\360"
  "\362\366\362\364\370\375\375\376\246\257\271\261\270\277\377\377\377\361"
  "\363\370\355\361\366\371\372\370\360\360\357\363\366\366\374\375\377\357"
  "\356\361\350\351\354\353\354\357\350\351\353\351\352\353\344\346\351\367"
  "\372\374\376\375\377\375\374\377\365\366\367\364\366\371\377\377\377\371"
  "\372\373\374\375\376\367\366\371\366\367\372\377\377\377\375\375\375\366"
  "\367\367\365\366\372\372\373\375\367\370\371\364\365\367\375\376\377\362"
  "\362\365\364\363\366\357\361\361\344\343\347\347\350\354\361\363\365\357"
  "\356\360\354\355\361\376\377\377\364\365\366\357\356\361\351\353\355\352"
  "\353\355\351\352\355\365\366\370\371\371\373\363\362\364\353\354\357\351"
  "\352\354\352\353\355\360\363\365\370\371\372\370\371\373\372\372\374\371"
  "\373\375\374\375\376\372\374\375\372\373\374\372\373\374\372\373\374\372"
  "\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372"
  "\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372"
  "\374\374\374\373\375\361\362\365\362\363\366\372\373\375\361\361\363\336"
  "\337\343\361\364\367\372\373\375\363\363\367\357\362\365\372\371\375\366"
  "\365\367\341\343\344\356\357\362\373\374\376\371\372\373\375\375\376\246"
  "\257\271\264\272\277\372\374\377p\243\351m\243\350\333\342\355\321\316\313"
  "\361\362\362\377\377\376\330\327\330\300\301\302\306\311\315\324\325\325"
  "\335\336\337\314\315\315\315\316\321\313\312\314\304\305\310\306\313\314"
  "\345\350\354\376\374\371\317\320\321\313\314\316\311\310\313\301\304\311"
  "\371\372\373\360\356\353\310\311\310\313\315\317\301\304\310\315\314\321"
  "\330\331\336\377\377\377\344\342\343\345\345\346\347\347\350\332\333\332"
  "\305\307\311\327\331\333\330\326\326\310\314\320\377\377\377\352\350\347"
  "\327\324\325\300\301\304\313\312\313\314\316\320\316\320\320\337\340\341"
  "\333\333\334\320\317\320\267\266\271\303\303\305\332\333\336\335\335\332"
  "\312\313\315\305\310\313\345\347\353\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\372"
  "\377\377\377\352\350\346\272\273\275\352\355\361\377\377\377\366\367\372"
  "\360\361\366\377\377\377\367\365\366\316\317\317\337\340\346\377\377\377"
  "\376\375\377\374\375\376\246\257\271\264\272\277\372\374\377~\253\353e\236"
  "\347\336\345\356\347\347\342\366\366\370\377\377\377\364\361\360\353\353"
  "\354\347\346\347\347\350\351\351\350\351\353\352\353\351\350\351\345\344"
  "\345\345\344\345\347\350\351\363\362\365\360\360\355\333\334\335\352\351"
  "\354\354\353\354\343\344\345\363\364\365\346\345\344\340\343\344\352\351"
  "\352\344\345\346\360\357\361\355\353\356\370\372\371\370\367\367\374\373"
  "\372\371\370\371\372\372\371\356\356\357\370\371\370\366\363\364\354\353"
  "\354\371\372\371\371\371\370\364\364\363\351\351\350\352\352\352\355\357"
  "\357\354\354\354\364\365\366\370\370\367\356\356\357\352\352\352\354\353"
  "\354\361\361\361\333\333\330\330\332\334\321\322\322\347\350\354\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\362\363\367\365\366\371\377\377\377\371\367\367\355\355\355\367\370"
  "\370\377\377\377\365\366\372\360\361\366\377\377\377\374\372\372\342\342"
  "\344\361\362\364\377\377\377\376\375\377\374\375\376\246\257\271\261\270"
  "\277\377\377\377\361\364\371\355\361\366\374\373\371\371\371\371\366\367"
  "\371\373\375\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\375\376"
  "\376\371\372\373\375\376\377\377\377\377\377\377\377\377\377\377\373\374"
  "\375\372\373\374\377\377\377\377\377\377\377\377\377\377\377\377\374\375"
  "\376\371\371\373\375\376\377\376\377\377\376\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\376\377\372\371\374\375\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\373\373\375\376\377"
  "\377\373\372\375\373\374\374\374\375\376\372\374\375\372\373\374\372\373"
  "\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373"
  "\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373"
  "\374\372\373\374\372\374\374\374\373\375\357\362\365\362\363\366\371\372"
  "\374\372\373\375\373\374\376\372\371\375\371\372\374\362\363\366\357\361"
  "\365\371\370\372\372\373\375\372\373\375\373\374\376\372\373\375\371\371"
  "\373\375\375\376\246\257\271\260\267\277\377\377\377\377\377\375\377\377"
  "\373\376\375\372\372\373\372\364\367\367\363\364\370\363\364\370\365\366"
  "\372\364\366\372\364\365\371\364\365\371\363\365\370\366\367\373\365\370"
  "\372\365\370\374\365\370\374\365\366\372\364\365\371\363\366\370\364\365"
  "\371\363\364\370\361\362\366\364\366\372\365\370\374\366\370\374\366\367"
  "\373\364\367\373\366\370\374\365\370\374\365\367\373\364\367\373\364\366"
  "\373\363\366\370\363\364\370\363\366\372\362\365\371\363\366\372\365\366"
  "\371\364\366\372\365\370\373\365\366\372\364\365\371\365\366\372\365\366"
  "\372\362\365\371\365\366\372\365\366\372\364\367\373\363\366\370\361\364"
  "\367\360\361\366\360\363\366\360\362\366\360\363\366\357\361\365\356\360"
  "\364\356\357\364\356\357\363\356\357\363\355\357\363\355\357\363\355\357"
  "\363\355\357\363\355\357\363\355\357\363\355\357\363\355\357\363\355\357"
  "\363\355\357\363\356\357\363\356\357\363\356\357\363\356\357\364\357\361"
  "\364\360\360\364\356\361\365\357\362\365\360\362\365\356\361\365\360\361"
  "\367\357\362\365\357\362\365\357\362\363\357\362\365\360\363\366\356\361"
  "\364\361\362\367\360\362\366\362\364\370\375\375\376\246\257\271\262\271"
  "\277\377\377\377\315\332\363\311\330\361\361\363\365\344\342\342\362\363"
  "\365\377\377\377\343\341\341\333\332\334\336\337\343\333\334\336\336\337"
  "\340\322\323\327\354\355\357\364\363\364\363\364\365\363\362\364\353\354"
  "\352\351\352\354\377\377\377\367\366\365\344\344\346\336\340\342\371\370"
  "\371\361\362\361\362\362\362\352\353\353\337\342\346\361\362\362\364\363"
  "\364\360\361\362\363\363\363\360\360\360\364\365\367\367\367\367\347\347"
  "\351\331\330\332\334\333\335\333\335\335\344\347\351\365\364\364\352\351"
  "\352\342\341\342\332\334\334\325\326\332\337\340\342\365\366\367\356\355"
  "\357\362\362\362\363\362\365\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\360\363\367\363\364\370\377\377"
  "\377\360\355\356\311\312\316\360\361\364\377\377\377\364\365\371\360\361"
  "\365\375\376\377\370\365\367\324\324\325\351\352\355\377\377\377\374\373"
  "\377\375\375\376\246\257\271\264\272\300\370\373\376^\235\351S\230\350\326"
  "\337\353\317\315\311\363\364\364\377\377\376\331\331\333\313\315\315\305"
  "\306\311\325\327\331\333\332\333\323\323\323\307\310\313\300\302\304\302"
  "\301\304\301\302\307\316\321\321\325\324\333\374\374\375\341\337\333\320"
  "\320\325\352\354\354\347\345\344\265\267\272\272\274\276\300\303\310\301"
  "\304\310\306\307\314\276\277\302\272\271\271\301\300\304\274\277\301\333"
  "\336\343\360\360\361\341\337\340\313\313\315\311\312\313\321\322\321\313"
  "\314\317\324\327\333\341\340\341\327\326\331\307\306\307\277\301\303\326"
  "\330\332\341\343\341\272\273\300\277\302\305\310\312\316\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362"
  "\363\367\365\366\370\377\377\377\355\351\351\310\312\314\353\356\360\377"
  "\377\377\365\367\372\360\361\366\377\377\377\367\365\365\320\317\321\340"
  "\344\347\377\377\377\376\375\377\374\375\376\246\257\271\263\271\277\376"
  "\377\377\252\302\356\231\270\352\353\356\363\363\361\357\367\370\371\377"
  "\377\377\377\376\375\375\375\375\374\374\373\371\371\371\371\371\370\373"
  "\373\373\373\374\373\375\374\375\374\374\373\372\372\372\373\374\373\375"
  "\373\374\365\364\365\372\372\373\376\376\375\377\377\377\377\377\377\373"
  "\373\372\373\374\373\374\373\374\371\370\366\365\366\367\373\374\373\360"
  "\357\356\372\373\373\374\373\374\377\377\377\377\377\377\377\377\377\375"
  "\375\374\372\372\371\376\375\375\375\375\376\376\377\376\377\377\377\377"
  "\376\375\376\376\375\375\376\375\377\376\377\366\365\362\346\350\352\361"
  "\360\357\346\350\352\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\362\363\367\365\366\370\377\377\377\376"
  "\374\374\372\371\372\374\373\375\377\377\377\365\366\370\360\361\365\376"
  "\376\377\375\375\375\362\362\362\371\372\374\377\377\377\374\375\377\374"
  "\375\376\246\257\271\260\267\277\377\377\377\377\377\375\376\376\371\376"
  "\375\372\372\373\372\364\366\370\364\367\371\370\371\374\371\373\375\372"
  "\374\376\373\374\376\373\374\376\373\374\376\372\374\376\372\373\375\372"
  "\373\375\371\373\375\371\372\375\370\372\374\366\367\371\366\367\374\370"
  "\372\374\370\371\374\370\371\374\371\372\374\372\373\375\372\373\376\373"
  "\374\376\373\374\376\373\374\376\371\372\376\372\373\376\371\372\375\370"
  "\371\374\367\371\373\370\371\374\371\372\375\372\373\376\373\374\376\372"
  "\373\376\372\373\375\371\372\374\371\372\375\372\373\376\373\374\376\373"
  "\374\376\371\372\376\372\373\376\373\374\376\370\371\375\367\370\372\362"
  "\365\370\361\364\367\361\364\367\361\364\367\361\364\367\361\364\367\361"
  "\364\367\361\364\367\361\364\367\361\364\367\361\364\367\361\364\367\361"
  "\364\367\361\364\367\361\364\367\361\364\367\361\364\367\361\364\367\361"
  "\364\367\361\364\367\361\364\367\361\364\367\362\365\367\363\364\370\357"
  "\360\364\356\361\365\362\363\367\363\365\370\364\367\373\363\364\370\362"
  "\363\367\357\362\365\357\362\365\362\363\367\363\364\370\366\367\373\364"
  "\367\370\363\364\367\364\366\371\375\375\376\246\257\271\260\267\277\377"
  "\377\377\377\376\373\375\374\371\375\374\373\366\366\365\364\365\367\366"
  "\371\373\365\367\371\364\365\367\362\363\365\355\356\362\357\360\363\355"
  "\356\362\371\372\376\374\375\377\373\375\377\373\374\377\367\370\373\366"
  "\367\372\372\374\376\371\373\375\366\367\371\371\373\376\372\373\376\374"
  "\375\377\373\374\377\374\375\377\371\372\374\366\367\373\373\374\377\374"
  "\375\377\374\375\377\373\374\377\373\374\376\372\373\375\370\371\373\364"
  "\365\371\360\363\365\363\364\366\361\362\366\363\366\372\373\375\377\366"
  "\367\372\364\365\367\363\364\366\362\364\366\362\363\367\371\372\375\371"
  "\372\375\373\374\376\371\372\374\367\370\373\365\367\371\365\366\371\365"
  "\366\371\365\366\370\365\366\370\365\366\370\365\366\370\365\366\370\365"
  "\366\370\365\366\370\365\366\370\365\366\370\365\366\370\365\366\370\365"
  "\366\370\365\366\370\365\366\370\365\366\370\365\366\370\365\366\370\365"
  "\366\371\365\366\371\365\366\372\357\360\364\360\361\365\364\366\371\363"
  "\362\366\347\352\356\363\364\367\365\366\371\361\362\365\357\360\365\364"
  "\365\371\364\365\367\351\352\355\360\362\366\365\366\372\366\366\372\375"
  "\375\376\246\257\271\263\271\277\375\375\377\224\267\352\222\265\353\343"
  "\350\357\324\323\321\361\361\363\377\377\377\350\345\344\332\331\332\323"
  "\325\327\330\330\330\337\336\337\315\317\317\325\326\330\330\331\334\337"
  "\336\337\336\336\340\330\331\333\325\326\333\377\377\377\357\353\352\314"
  "\320\320\321\323\325\345\346\351\361\361\357\324\324\324\332\331\334\323"
  "\326\330\316\317\323\333\334\335\333\334\334\332\332\330\335\336\337\324"
  "\325\327\343\346\346\363\362\361\336\335\336\316\315\317\317\322\325\317"
  "\316\316\322\325\327\344\343\343\336\335\336\330\327\332\312\313\313\300"
  "\301\305\327\332\334\356\357\357\327\327\331\336\337\337\337\341\341\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362"
  "\363\367\365\366\370\377\377\377\354\350\350\276\300\302\354\355\361\377"
  "\377\377\366\367\370\360\361\367\377\377\377\370\365\366\320\322\322\341"
  "\344\350\377\377\377\376\375\377\374\375\376\246\257\271\264\272\300\371"
  "\373\376h\241\351I\226\346\332\340\355\336\334\327\364\365\366\377\377\377"
  "\367\365\364\347\345\346\327\331\333\331\332\335\333\333\333\334\335\336"
  "\324\323\324\320\321\324\317\321\321\317\320\322\327\332\335\344\344\346"
  "\371\371\371\346\344\343\314\320\321\304\303\305\314\320\326\361\361\360"
  "\316\316\316\314\315\316\317\322\326\320\321\323\316\317\321\316\317\321"
  "\303\302\303\316\321\324\317\321\321\350\353\355\371\370\371\355\355\354"
  "\331\331\330\325\326\331\341\340\341\334\335\337\336\340\342\355\355\353"
  "\343\341\341\331\333\333\324\325\330\337\340\343\337\340\341\300\301\304"
  "\313\315\315\306\312\316\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\361\363\367\364\366\370\377\377\377\362\360\360"
  "\335\336\337\362\363\365\377\377\377\365\366\372\360\361\366\377\377\377"
  "\371\367\367\325\325\327\352\353\355\377\377\377\376\375\377\374\375\376"
  "\246\257\271\262\270\277\377\377\377\331\342\365\322\334\361\365\367\370"
  "\370\370\367\366\366\370\376\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\372\372\372\375\376\377\377\377\377"
  "\377\377\377\375\374\375\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\376\375\376\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\376\377\376\371\372\373\376\375\376\367\366\370\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377"
  "\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377"
  "\377\376\377\377\376\377\377\376\377\377\377\377\377\377\377\360\363\367"
  "\363\364\370\374\376\376\376\375\375\375\376\376\376\375\377\374\376\376"
  "\364\365\370\356\361\365\375\374\376\375\375\377\373\373\373\375\376\376"
  "\375\376\377\372\373\375\375\375\376\246\257\271\260\267\277\377\377\377"
  "\377\377\375\377\377\373\375\375\372\372\372\372\364\366\366\360\363\367"
  "\362\363\367\363\364\370\364\365\371\364\367\372\366\367\373\364\367\373"
  "\365\366\372\365\366\372\364\366\372\364\366\371\364\365\371\363\364\370"
  "\362\364\370\363\364\371\364\365\371\365\366\372\365\366\372\364\365\371"
  "\363\364\370\363\364\370\364\365\371\365\366\372\365\366\372\365\366\372"
  "\365\366\372\363\365\371\362\364\370\362\364\370\362\364\370\364\365\371"
  "\363\366\372\366\367\373\366\370\373\366\367\373\362\365\371\363\364\370"
  "\363\365\371\365\366\372\366\367\373\366\367\373\366\367\373\366\367\373"
  "\365\367\372\365\366\372\364\365\371\364\365\371\363\365\370\362\364\370"
  "\362\363\367\362\363\367\361\362\366\360\361\365\356\360\364\356\357\363"
  "\356\357\363\356\357\363\356\357\363\356\357\363\356\357\363\355\357\363"
  "\355\357\363\355\357\363\355\357\363\356\357\363\356\357\363\356\357\363"
  "\356\357\364\357\360\364\357\360\364\356\357\365\356\361\365\360\363\367"
  "\361\362\370\360\363\366\357\361\365\357\360\365\357\362\363\357\361\365"
  "\357\362\366\361\362\370\360\363\367\360\362\366\362\363\370\375\375\376"
  "\246\257\271\261\270\277\377\377\377\352\360\370\350\354\366\370\370\370"
  "\356\356\355\363\364\366\374\375\377\363\362\365\364\364\366\363\362\364"
  "\344\345\347\347\346\350\342\343\345\365\370\372\373\375\375\375\374\374"
  "\372\372\374\372\371\373\371\372\372\377\377\377\374\373\374\372\373\374"
  "\374\374\374\366\365\366\361\364\365\376\377\377\377\377\377\371\371\371"
  "\372\372\374\373\372\374\373\374\374\370\371\371\372\373\375\377\377\377"
  "\361\362\363\362\364\364\360\360\362\344\345\347\344\346\350\347\350\352"
  "\345\345\351\354\355\357\377\377\377\366\366\366\356\355\360\351\352\354"
  "\351\351\353\347\350\352\365\366\370\373\372\373\362\362\364\352\353\355"
  "\346\347\351\347\350\352\357\360\362\371\372\372\367\370\372\371\372\373"
  "\372\373\373\376\377\377\374\375\376\374\375\376\373\375\376\373\375\376"
  "\373\375\376\373\375\376\373\375\376\373\375\376\373\375\376\373\375\376"
  "\373\375\376\373\375\376\373\375\376\374\375\376\375\375\375\361\362\365"
  "\363\365\366\374\373\375\361\361\361\333\334\337\361\364\370\374\373\375"
  "\364\365\367\357\362\365\372\373\375\367\367\367\337\337\342\354\357\362"
  "\375\374\376\371\372\375\375\375\376\246\257\271\264\272\300\371\373\377"
  "g\241\347g\241\350\332\340\353\321\316\313\360\361\361\377\377\377\351\351"
  "\350\346\345\346\343\342\343\324\324\326\334\335\336\315\316\317\311\312"
  "\312\306\306\312\310\311\314\305\307\313\316\313\314\314\315\322\376\377"
  "\377\337\335\330\304\307\312\315\317\317\310\307\310\267\272\275\354\357"
  "\362\373\370\367\312\313\312\311\313\315\306\305\307\301\304\307\307\310"
  "\312\335\336\343\377\377\377\346\346\345\345\345\346\350\347\352\334\335"
  "\335\275\274\301\272\271\274\303\304\306\322\324\330\377\377\377\356\354"
  "\353\330\326\327\300\301\304\311\313\313\313\316\320\315\316\317\335\336"
  "\341\334\333\334\320\317\322\267\270\273\301\303\305\330\331\334\336\335"
  "\334\306\307\314\302\305\307\342\343\346\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\362\363\367\365\366\372\377\377\377\352\347\346\267\273"
  "\275\352\355\361\377\377\377\365\367\372\360\361\366\377\377\377\367\365"
  "\366\316\317\317\337\340\346\377\377\377\376\375\377\374\375\376\246\257"
  "\271\264\272\277\372\374\377\210\257\353m\242\347\342\346\360\352\350\346"
  "\365\366\367\377\377\377\376\374\373\376\375\374\365\364\363\352\353\354"
  "\353\353\353\356\355\356\354\355\356\354\355\356\354\355\353\353\354\355"
  "\365\363\364\351\351\351\365\365\366\340\336\335\351\352\353\357\356\357"
  "\355\355\355\351\352\351\361\362\363\357\357\355\322\322\324\360\357\361"
  "\357\357\357\355\354\355\361\362\363\364\362\362\370\371\370\367\371\370"
  "\375\375\374\372\372\373\375\374\373\360\360\361\356\357\356\357\360\361"
  "\356\360\360\371\370\371\373\372\371\367\367\366\355\354\355\355\355\355"
  "\361\362\363\360\361\360\370\367\370\372\371\372\362\361\362\357\357\357"
  "\360\361\361\363\364\365\341\341\335\335\336\340\327\326\327\346\351\353"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\371"
  "\377\377\377\371\370\371\361\361\361\371\370\372\377\377\377\365\366\372"
  "\360\361\366\377\377\377\374\373\372\346\345\347\362\363\365\377\377\377"
  "\376\375\377\374\375\376\246\257\271\261\270\277\377\377\377\365\370\371"
  "\362\364\370\374\374\372\373\373\372\365\366\370\371\372\374\374\375\376"
  "\375\376\377\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\376\377\377\377\376\377\373\372\375"
  "\372\373\375\377\377\377\377\377\377\377\377\377\377\377\377\375\374\376"
  "\372\373\375\373\374\376\377\377\377\377\377\377\377\377\377\376\377\377"
  "\374\375\375\367\371\373\374\374\376\374\375\377\374\376\376\376\377\377"
  "\377\377\377\377\377\377\377\377\377\376\376\377\370\371\373\373\375\377"
  "\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\376\377\377"
  "\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\375\376\377"
  "\377\377\377\376\377\377\375\374\377\374\375\377\373\374\374\372\374\374"
  "\373\374\375\373\374\375\373\374\375\372\373\374\372\373\374\372\373\374"
  "\371\373\373\371\372\373\370\372\372\370\371\372\370\371\372\371\372\373"
  "\372\373\374\357\362\365\362\363\366\367\370\372\370\372\374\372\373\375"
  "\370\371\373\367\370\372\362\363\366\357\361\365\367\370\372\370\371\373"
  "\372\373\375\371\372\374\370\371\373\367\370\373\375\375\376\246\257\271"
  "\260\267\277\377\377\377\377\377\375\377\377\373\376\375\372\371\371\370"
  "\364\367\367\362\363\367\363\364\370\362\364\370\362\364\367\362\363\366"
  "\362\365\371\362\365\370\366\367\373\365\370\374\364\367\373\363\366\372"
  "\363\366\372\364\367\373\366\370\373\367\370\374\364\367\373\363\366\372"
  "\363\366\372\364\367\373\364\367\373\367\370\374\366\371\374\366\366\372"
  "\365\370\372\364\366\372\364\365\371\364\365\371\364\367\373\363\366\372"
  "\362\365\371\362\365\371\364\365\371\365\366\372\367\370\374\365\366\372"
  "\364\367\371\365\367\373\364\367\373\367\370\374\366\371\373\364\365\371"
  "\366\371\373\367\370\374\365\370\374\365\370\373\365\370\373\364\367\373"
  "\364\367\373\364\366\372\363\366\372\364\367\373\364\365\371\363\366\371"
  "\365\367\373\364\365\371\363\364\370\362\365\371\362\363\367\362\364\367"
  "\362\365\371\364\365\371\363\366\372\362\365\371\360\363\367\357\361\366"
  "\356\361\365\356\361\365\356\361\366\357\362\364\360\360\364\356\361\365"
  "\361\362\365\361\362\365\355\357\363\361\362\367\361\362\365\357\362\365"
  "\357\362\365\357\362\365\360\363\367\354\357\363\357\362\366\362\363\366"
  "\362\364\370\375\375\376\246\257\271\262\271\277\377\377\377\302\322\361"
  "\300\321\360\356\360\363\340\336\336\362\363\364\377\377\377\357\356\355"
  "\346\346\347\332\333\337\332\333\335\336\337\337\316\321\323\350\351\353"
  "\360\360\361\356\356\357\377\377\377\374\373\372\350\347\352\355\356\357"
  "\353\354\355\355\356\356\377\377\377\372\371\370\357\356\357\360\361\362"
  "\366\366\370\356\356\354\347\350\350\351\352\354\375\376\377\367\367\366"
  "\351\352\352\355\356\356\361\362\362\377\376\377\377\375\374\350\347\350"
  "\344\345\351\360\357\360\350\353\352\353\354\354\372\372\372\360\360\361"
  "\356\356\356\352\351\352\337\340\342\352\351\353\361\362\362\355\354\355"
  "\357\360\360\356\355\355\356\357\361\374\373\373\345\344\345\331\332\332"
  "\334\335\336\325\327\332\333\334\334\356\357\357\355\354\355\345\344\346"
  "\326\327\331\317\320\322\326\326\333\360\363\363\354\355\355\355\356\357"
  "\355\355\356\376\376\376\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\360\363\367\365\366\370\377\377\377\356\354\354\307\310\314"
  "\356\361\364\377\377\377\366\367\370\360\361\365\377\376\377\370\365\366"
  "\322\324\326\347\352\354\377\377\377\374\375\377\375\375\376\246\257\271"
  "\264\272\300\370\371\376b\237\351J\226\346\326\336\353\323\320\315\362\363"
  "\363\377\377\377\360\356\355\335\334\335\324\325\326\326\331\331\332\331"
  "\332\325\324\325\312\311\314\313\314\314\302\303\306\364\365\370\360\360"
  "\355\316\315\316\306\307\310\271\272\277\325\327\333\371\372\373\347\343"
  "\342\316\317\320\314\315\314\313\315\317\272\273\300\306\313\315\301\304"
  "\311\356\361\362\360\357\352\276\300\305\304\305\310\304\305\310\362\365"
  "\366\362\360\357\320\321\322\324\323\326\301\302\305\305\310\310\323\324"
  "\331\346\345\346\304\301\302\272\275\300\275\301\301\312\313\316\300\303"
  "\310\310\311\312\263\266\273\303\304\311\301\302\305\316\321\324\363\364"
  "\365\343\342\343\326\325\326\312\313\316\323\324\326\323\324\325\313\315"
  "\317\346\345\350\337\337\335\314\313\314\303\304\307\314\317\324\343\346"
  "\344\306\307\307\303\304\305\275\300\303\364\365\366\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\370\377\377"
  "\377\355\353\353\314\315\317\355\356\362\377\377\377\365\366\372\360\361"
  "\366\377\377\377\367\365\365\320\321\321\341\343\350\377\377\377\376\375"
  "\377\374\375\376\246\257\271\263\271\277\377\377\377\261\310\357\246\277"
  "\354\354\357\365\364\362\360\366\367\371\377\377\377\377\377\377\375\375"
  "\374\373\373\373\372\374\372\373\372\373\375\376\375\376\375\376\377\377"
  "\376\375\374\375\371\371\370\371\371\372\377\377\377\377\376\375\373\374"
  "\373\377\377\376\367\370\367\370\371\372\374\376\375\377\376\376\372\372"
  "\371\362\363\362\376\377\377\375\374\375\372\371\370\370\371\370\377\376"
  "\377\375\375\374\360\362\362\370\367\370\370\367\370\374\376\375\377\377"
  "\377\376\375\374\375\376\375\377\377\377\377\377\377\377\377\377\376\377"
  "\376\375\376\375\377\377\376\365\366\366\377\377\376\367\366\365\370\371"
  "\372\377\377\376\377\377\377\377\377\377\377\377\377\377\377\376\375\375"
  "\374\375\376\375\377\376\377\377\377\376\377\377\377\377\377\377\376\376"
  "\377\377\376\375\377\376\377\375\374\374\352\353\354\366\365\366\347\350"
  "\350\376\375\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\362\363\367\365\366\370\377\377\377\376\375\376\374\373\373\374\375"
  "\375\377\377\377\365\366\370\360\361\364\376\376\377\377\375\375\364\364"
  "\366\373\374\374\377\377\377\374\375\377\375\375\376\246\257\271\260\267"
  "\277\377\377\377\377\377\375\377\377\373\376\375\372\372\373\372\364\366"
  "\366\362\365\371\364\367\371\365\370\374\371\372\376\371\372\376\371\373"
  "\376\371\372\376\367\372\374\367\371\374\366\371\373\366\367\373\366\367"
  "\373\365\370\373\365\370\372\366\370\373\366\370\373\365\366\372\366\367"
  "\373\366\371\373\366\371\373\366\371\373\366\371\374\367\371\373\366\371"
  "\373\366\367\373\365\366\372\365\370\372\365\370\372\366\367\373\365\367"
  "\373\366\367\373\370\371\375\367\372\374\367\371\374\366\371\373\365\370"
  "\372\364\367\372\365\370\373\367\372\374\371\372\376\372\373\377\370\373"
  "\375\371\372\374\367\372\374\367\372\374\367\372\374\367\372\374\366\371"
  "\373\366\370\373\366\371\373\366\371\373\366\370\373\365\367\372\363\366"
  "\371\363\365\370\363\366\370\363\366\371\363\366\371\363\366\371\364\367"
  "\371\364\365\372\364\367\372\364\365\371\362\365\367\360\363\366\360\363"
  "\365\360\362\365\360\363\366\361\362\366\357\360\364\356\361\365\360\361"
  "\367\362\365\370\363\366\371\362\364\370\360\361\367\357\362\365\357\362"
  "\365\360\361\367\361\364\370\363\366\371\362\365\370\361\362\367\362\364"
  "\370\375\375\376\246\257\271\261\270\277\377\377\377\374\374\373\372\373"
  "\371\375\374\371\366\366\365\364\365\367\370\371\373\365\366\371\362\363"
  "\365\357\361\363\354\355\361\356\357\361\354\355\361\372\373\375\371\374"
  "\374\371\372\374\367\370\372\374\375\377\373\374\376\375\376\377\366\366"
  "\370\366\371\373\373\374\377\374\375\377\374\374\377\367\370\373\372\373"
  "\375\371\370\372\372\373\375\374\375\377\373\375\377\373\374\376\373\374"
  "\376\372\373\375\364\365\367\366\366\370\362\363\365\354\355\357\361\362"
  "\366\367\370\373\370\371\373\366\367\372\374\373\376\364\366\370\363\363"
  "\367\361\362\364\360\361\365\361\362\364\371\372\376\372\373\375\365\366"
  "\371\361\362\364\360\361\365\361\362\364\365\366\370\370\371\374\372\373"
  "\377\373\374\376\372\373\375\371\372\373\370\371\372\367\371\372\367\371"
  "\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371"
  "\372\367\370\371\367\370\371\366\370\371\367\370\371\367\370\371\367\370"
  "\372\357\362\366\360\363\366\366\367\371\363\362\364\346\347\352\363\364"
  "\367\366\367\371\361\364\367\357\360\365\366\367\371\364\365\367\347\350"
  "\354\360\362\366\367\370\374\366\370\372\375\375\376\246\257\271\263\272"
  "\277\373\376\377\214\261\352\206\257\351\342\346\357\324\322\317\360\361"
  "\363\377\377\377\351\347\347\341\341\341\321\322\325\327\326\330\337\336"
  "\337\314\315\317\317\322\325\323\326\330\325\324\326\316\321\321\325\324"
  "\324\323\325\327\376\377\377\352\350\347\315\317\317\332\334\332\321\322"
  "\323\327\330\330\321\322\326\371\372\373\352\350\347\316\315\320\321\323"
  "\325\323\322\325\325\326\326\354\357\362\377\377\377\341\337\340\344\344"
  "\345\350\350\350\322\321\324\312\313\317\321\321\321\323\323\325\336\337"
  "\344\377\377\377\347\345\344\323\321\322\307\312\315\320\317\317\321\322"
  "\324\325\326\327\345\346\347\336\335\336\323\322\323\274\277\302\310\307"
  "\311\340\343\347\341\341\337\324\325\327\325\324\326\360\361\364\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\370\377\377"
  "\377\352\350\346\274\275\302\352\355\361\377\377\377\366\367\370\360\361"
  "\367\377\377\377\370\365\366\316\320\322\337\342\350\377\377\377\376\375"
  "\377\374\375\376\246\257\271\264\272\277\371\373\377k\241\351L\226\346\331"
  "\340\355\340\336\333\364\364\366\377\377\377\370\366\365\354\354\353\331"
  "\332\333\332\334\334\335\334\335\335\337\337\327\330\333\343\346\346\337"
  "\335\335\315\321\321\303\302\304\324\325\327\366\370\370\361\357\356\330"
  "\327\330\337\340\341\332\331\332\331\331\331\326\331\334\364\364\366\355"
  "\355\354\335\336\341\326\327\330\324\325\326\330\330\330\343\346\350\374"
  "\376\375\357\357\356\365\365\364\364\364\365\361\361\360\334\334\335\337"
  "\340\341\341\341\341\344\346\351\375\376\375\365\364\363\352\350\347\334"
  "\333\334\333\334\337\340\341\342\333\334\335\356\357\360\357\356\357\340"
  "\337\340\330\331\331\337\340\341\352\353\353\320\317\317\312\313\320\301"
  "\302\305\347\352\355\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362"
  "\363\367\364\366\371\377\377\377\364\361\362\341\342\342\362\363\365\377"
  "\377\377\365\366\372\360\361\366\377\377\377\372\370\371\325\326\327\353"
  "\355\357\377\377\377\376\375\377\374\375\376\246\257\271\261\270\277\377"
  "\377\377\340\347\366\332\342\363\370\370\371\370\370\367\366\366\370\376"
  "\375\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\373\372\374\377"
  "\377\377\373\374\373\374\376\376\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\373\372\373\375\376\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\375\374\375\372\373\373\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\376\371"
  "\371\372\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\372\373\372\376\377\377\371\370\371\375\374\377\377\377\377\376"
  "\377\376\375\377\376\375\376\376\375\376\376\375\376\376\375\376\376\375"
  "\376\376\375\376\376\375\376\376\375\376\376\375\376\376\375\376\376\375"
  "\377\376\376\377\376\377\376\377\360\362\365\363\364\370\374\374\376\374"
  "\375\375\375\376\376\374\375\375\375\374\376\364\365\370\356\361\365\373"
  "\374\374\375\375\377\373\373\375\375\376\376\375\375\377\372\373\375\375"
  "\375\376\246\257\271\260\267\277\377\377\377\377\377\375\377\377\373\375"
  "\375\372\372\372\372\364\366\367\360\363\367\360\364\370\364\365\371\363"
  "\366\372\364\365\371\365\367\373\365\367\373\366\367\373\365\366\372\365"
  "\367\372\366\367\373\365\367\373\364\365\371\363\364\370\361\364\370\363"
  "\364\370\363\364\370\363\364\370\364\365\371\364\365\372\364\365\371\364"
  "\365\371\364\365\372\363\365\371\364\365\371\364\366\372\364\366\372\364"
  "\366\372\363\365\371\364\365\371\364\365\371\364\365\371\364\365\371\364"
  "\365\371\363\365\371\363\365\371\364\365\371\363\366\372\364\367\373\364"
  "\367\373\364\367\372\365\366\372\365\366\372\363\366\372\364\367\373\364"
  "\367\373\364\367\373\365\366\372\365\366\372\365\366\372\364\365\371\362"
  "\364\370\360\362\366\355\360\364\355\360\364\354\357\364\354\357\364\354"
  "\357\364\354\357\364\354\357\364\354\357\364\354\357\364\354\357\364\354"
  "\357\364\354\357\364\354\357\364\354\357\364\355\360\364\356\361\365\360"
  "\361\364\357\360\365\357\362\365\360\361\367\360\363\366\360\363\367\357"
  "\360\365\357\360\365\357\362\363\357\360\365\360\363\366\357\362\366\361"
  "\362\367\360\363\366\362\363\370\375\377\376\246\257\271\261\270\277\377"
  "\377\377\341\351\366\337\345\364\365\366\370\352\352\351\363\364\366\376"
  "\377\377\364\364\364\366\366\366\357\357\357\343\343\345\344\345\347\336"
  "\337\341\362\365\367\365\366\367\365\365\367\360\361\361\372\371\372\370"
  "\371\372\377\377\377\372\371\371\363\364\364\377\376\377\377\377\377\364"
  "\365\366\364\365\365\370\371\371\372\371\371\366\367\367\365\366\367\376"
  "\377\377\372\373\373\372\372\372\362\363\363\354\355\357\370\371\372\372"
  "\373\373\370\371\372\372\373\373\371\372\372\373\374\375\373\373\373\356"
  "\356\360\345\346\351\346\347\351\344\345\347\356\357\361\374\373\373\363"
  "\362\362\353\354\354\345\346\350\345\344\350\351\352\354\371\373\373\366"
  "\365\367\371\372\372\370\371\372\377\377\377\377\377\377\377\376\377\376"
  "\376\377\376\376\377\376\376\377\376\376\377\376\376\377\376\376\377\376"
  "\376\377\376\376\377\376\376\377\376\376\377\376\376\377\376\376\377\376"
  "\376\377\377\376\377\376\377\377\361\362\366\364\365\371\374\376\377\362"
  "\360\361\327\331\334\362\363\366\374\375\377\365\366\371\357\362\366\374"
  "\373\375\370\370\370\334\335\337\355\356\361\375\376\377\373\374\375\375"
  "\375\376\246\257\271\262\271\277\367\372\376o\242\346u\247\347\327\335\351"
  "\315\313\313\357\356\360\377\377\377\351\347\347\327\324\327\313\313\317"
  "\326\332\334\340\341\340\322\323\323\312\313\315\312\315\317\310\307\314"
  "\302\305\306\305\304\305\306\307\312\367\370\371\352\353\350\306\311\316"
  "\357\360\363\363\362\360\313\314\313\304\311\316\311\312\314\307\310\312"
  "\306\307\314\316\321\323\341\340\341\270\272\274\302\304\306\303\306\310"
  "\301\304\312\314\317\320\306\307\310\304\303\304\303\304\307\300\303\305"
  "\331\335\337\355\355\354\334\332\334\303\304\307\316\317\320\314\313\316"
  "\311\314\316\324\331\333\333\331\333\323\324\327\303\304\302\273\274\300"
  "\323\324\331\345\346\344\305\304\311\306\307\312\321\322\326\377\377\377"
  "\377\377\377\377\377\376\377\377\377\377\377\377\377\376\376\377\377\377"
  "\377\377\377\377\376\376\377\377\377\377\377\377\377\376\376\377\376\377"
  "\377\377\377\377\376\376\377\376\376\377\377\377\377\377\377\357\361\365"
  "\364\364\367\376\376\376\351\345\346\271\275\277\351\354\356\377\376\376"
  "\365\364\370\357\360\364\374\374\376\365\362\363\321\324\324\336\337\345"
  "\376\375\375\373\374\376\375\375\376\246\257\271\260\267\277\377\377\377"
  "\354\361\366\350\355\365\363\364\365\360\360\360\366\367\367\370\371\372"
  "\364\365\364\360\360\362\352\353\354\360\361\362\360\361\362\361\362\362"
  "\354\354\355\357\360\361\356\357\360\354\355\356\354\355\355\352\353\356"
  "\366\367\370\363\364\363\355\356\357\364\365\366\366\365\366\357\360\361"
  "\355\356\356\353\354\355\353\354\357\360\361\362\356\357\361\364\363\364"
  "\350\351\352\353\354\356\355\356\356\356\357\360\354\355\356\353\354\354"
  "\353\354\354\354\355\356\353\354\355\361\362\364\367\366\367\362\362\362"
  "\354\355\356\357\360\360\357\360\362\354\355\356\356\360\361\363\364\365"
  "\360\357\360\354\355\357\354\355\355\356\357\360\361\362\363\352\353\354"
  "\352\353\353\353\354\357\367\370\371\365\366\367\365\366\367\364\366\367"
  "\364\365\367\364\366\367\364\366\367\364\366\367\365\366\367\364\366\367"
  "\364\366\367\364\366\367\364\365\367\364\365\366\364\365\366\364\365\366"
  "\364\365\366\365\366\367\362\363\364\363\364\366\367\366\367\363\363\363"
  "\355\356\361\363\364\365\365\366\367\363\364\366\363\364\365\365\366\367"
  "\364\365\366\353\354\354\356\361\361\366\367\370\370\370\371\377\377\376"
  "\246\257\271\257\266\277\377\377\377\375\374\371\373\372\366\371\371\370"
  "\370\370\370\365\366\366\364\365\366\365\366\366\367\370\371\367\370\371"
  "\367\370\371\367\370\371\367\370\371\367\370\371\370\371\372\370\371\372"
  "\370\371\372\370\371\372\367\370\371\364\365\366\364\365\366\366\367\370"
  "\364\367\366\364\365\366\367\370\371\367\370\371\367\370\371\366\367\370"
  "\366\367\367\366\367\366\367\370\370\370\371\372\370\371\372\370\371\372"
  "\370\371\371\370\371\372\370\371\372\370\371\372\370\371\372\370\371\371"
  "\365\366\367\364\365\366\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\363\364\365\365\366\367\365\366\367\366\367\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\363\364\364\362\363\363"
  "\362\363\364\364\365\366\362\363\364\362\363\364\362\363\364\362\363\364"
  "\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364"
  "\361\362\363\360\361\362\360\361\362\360\361\362\360\361\362\361\362\363"
  "\361\362\363\361\362\363\362\363\364\364\365\366\362\363\364\361\362\363"
  "\361\362\363\361\362\363\361\362\363\361\362\363\364\365\366\362\363\364"
  "\362\363\364\366\366\367\376\377\377\246\257\271\257\266\277\377\377\377"
  "\377\377\375\372\372\372\376\376\373\362\363\364\371\373\374\372\373\374"
  "\371\371\372\367\367\370\373\374\375\365\366\367\371\372\372\372\373\374"
  "\371\372\373\372\373\373\372\373\374\372\373\374\372\372\373\372\373\374"
  "\372\373\374\371\372\373\371\372\373\366\366\367\371\373\374\371\372\373"
  "\371\372\372\365\366\367\371\371\372\366\367\371\367\370\372\365\365\365"
  "\361\363\364\366\371\371\373\373\374\373\373\374\364\367\370\370\371\374"
  "\372\373\374\372\373\374\372\373\375\372\372\373\370\372\373\371\372\372"
  "\367\370\371\367\370\371\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\367\370\370\365\366\370\366\367\371\364\365\366\357\362\363\365\366\370"
  "\372\373\373\372\372\373\365\366\367\367\370\373\371\372\373\371\372\373"
  "\371\372\374\371\372\372\367\370\372\370\371\372\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\367\370\370\371\372\372\377\377\377"
  "\245\257\271\260\270\277\377\377\377\306\327\363\200\253\352\334\342\356"
  "\305\304\303\316\317\320\314\317\321\310\312\315\304\307\313\336\342\346"
  "\315\314\317\317\322\326\345\346\347\315\316\323\312\312\317\310\313\315"
  "\310\312\317\305\307\312\344\347\351\323\322\324\312\313\315\314\315\321"
  "\310\311\315\337\341\342\304\306\313\306\307\313\334\336\342\370\370\372"
  "\366\367\371\373\374\376\342\341\343\272\275\301\310\314\321\334\341\343"
  "\342\341\337\310\313\315\314\316\323\311\313\315\312\315\321\322\323\325"
  "\311\312\316\313\316\322\364\366\367\370\370\371\366\367\370\366\367\370"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\366\367\367\366\367\367\365\366\370\373\373\375"
  "\345\344\344\272\274\301\310\312\320\332\337\341\342\342\343\310\312\315"
  "\313\314\320\312\313\315\312\315\321\322\323\325\311\312\316\311\314\320"
  "\362\365\367\370\371\371\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\366\367"
  "\366\367\370\371\371\372\377\377\377\245\256\271\261\270\277\377\377\377"
  "\242\276\356\000\207\344\311\324\352\340\337\334\312\310\311\304\307\313\310"
  "\314\316\312\314\317\342\345\351\336\333\333\323\324\330\351\354\354\334"
  "\334\335\310\313\315\321\323\327\334\336\337\313\314\316\346\347\351\317"
  "\320\322\317\320\325\323\324\330\321\324\326\344\344\343\307\311\314\315"
  "\316\322\343\345\351\370\370\372\371\372\374\377\377\377\355\356\357\331"
  "\332\332\320\323\327\337\341\345\342\343\342\330\333\335\330\327\333\310"
  "\312\316\330\332\336\314\313\315\273\276\304\317\322\325\365\367\372\370"
  "\371\372\366\367\370\366\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\366\367\365"
  "\367\367\370\370\372\377\377\377\357\360\361\333\332\333\321\323\327\335"
  "\340\344\344\343\344\330\333\335\331\330\333\311\312\314\325\330\336\316"
  "\315\316\272\273\301\315\320\323\365\366\370\371\372\373\370\371\372\367"
  "\370\371\367\370\371\367\370\371\367\370\371\367\370\371\367\370\371\366"
  "\367\370\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\366\367\370\371\371\372\377\377\377\245"
  "\256\271\257\267\277\377\377\377\361\364\371\336\346\365\373\373\374\374"
  "\374\373\373\373\373\373\375\376\375\375\376\370\371\371\373\376\376\374"
  "\375\376\374\375\375\376\377\377\376\377\377\375\376\377\377\377\377\377"
  "\377\377\374\375\377\374\376\377\372\373\374\372\373\373\371\372\373\371"
  "\372\373\373\374\374\371\372\373\371\372\372\370\371\371\372\372\371\372"
  "\372\371\372\373\373\374\372\370\364\365\366\373\374\376\374\375\375\374"
  "\375\376\377\377\377\377\377\377\377\377\377\377\377\377\370\371\371\370"
  "\370\372\375\377\377\375\376\376\372\373\374\370\371\371\366\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\366\367\367\370\371\370\371\372\371\372\373\372\374"
  "\374\372\370\371\370\374\376\377\377\377\377\376\377\377\375\377\377\377"
  "\377\377\375\376\377\376\377\377\370\371\372\366\367\371\376\377\377\375"
  "\376\377\372\373\374\370\373\374\373\374\375\373\374\375\373\374\374\372"
  "\373\374\372\373\374\372\373\374\371\372\373\367\370\371\366\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366"
  "\367\370\370\371\372\377\377\377\245\256\271\256\266\276\377\377\377\374"
  "\374\373\374\375\375\366\366\365\311\311\313\334\334\337\335\337\340\331"
  "\333\333\322\326\332\352\354\356\326\325\331\335\337\342\353\355\356\333"
  "\334\336\333\334\336\332\332\335\327\330\332\327\327\331\351\354\360\372"
  "\373\373\370\371\372\367\370\371\367\370\371\367\370\371\367\370\371\370"
  "\370\371\371\371\371\373\372\371\312\327\360\247\301\354\350\353\357\313"
  "\312\314\333\335\340\350\353\353\332\333\335\335\336\340\327\332\334\331"
  "\332\334\333\335\337\336\341\343\342\343\345\332\334\336\332\332\334\326"
  "\330\333\360\362\364\367\370\371\366\367\370\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\366\366\367\367\370\367\372"
  "\372\371\315\331\361\245\300\354\343\347\352\321\320\320\330\332\333\336"
  "\341\343\332\333\337\337\342\344\332\333\335\351\352\354\326\325\327\343"
  "\346\350\357\362\362\341\342\344\330\331\335\326\325\330\317\322\322\330"
  "\333\335\327\330\334\333\334\336\336\337\341\332\335\335\327\330\332\325"
  "\327\333\362\365\366\367\370\370\366\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\366\367\370\370\371\372\377\377\377\245"
  "\256\271\255\265\276\377\377\377\373\373\375\377\377\377\356\357\357\317"
  "\317\320\277\300\300\271\275\300\303\307\311\277\303\307\335\340\345\325"
  "\322\324\316\320\323\344\347\347\322\321\324\300\301\305\305\307\313\317"
  "\322\324\270\272\301\337\344\350\371\371\372\367\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\371\371\370\366\370\367x\246"
  "\347\000\202\343\332\342\361\335\333\332\321\323\324\343\345\346\313\314\316"
  "\311\312\316\275\275\277\273\276\304\312\317\321\320\320\324\314\313\315"
  "\274\277\303\301\301\303\300\305\311\355\360\362\370\370\371\366\367\370"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\366\367\367\370\370\370\367\370\367\203\255\347\000\203\344\315\327\351\323"
  "\322\317\276\276\277\304\310\314\275\275\301\316\316\322\302\305\311\342"
  "\345\347\316\315\320\322\325\327\337\342\341\303\304\312\322\321\325\305"
  "\310\312\300\301\303\303\310\316\315\314\316\301\305\312\312\315\317\312"
  "\314\316\312\315\317\304\307\315\360\362\365\367\370\371\366\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367\370\370"
  "\371\372\377\377\377\245\256\271\255\265\276\377\377\377\370\371\373\367"
  "\370\371\370\371\373\373\372\373\365\366\366\366\367\367\370\372\372\365"
  "\365\366\372\372\374\373\374\374\372\373\373\375\376\376\374\375\376\371"
  "\372\373\371\371\373\372\373\373\365\365\370\367\370\371\367\370\371\366"
  "\367\370\365\366\367\365\366\367\365\366\367\365\366\367\366\367\367\367"
  "\370\370\374\373\370\334\345\363\311\327\360\367\371\372\371\371\367\371"
  "\372\373\375\376\376\372\373\374\374\375\377\375\376\376\375\376\376\374"
  "\375\377\374\375\375\372\373\374\373\374\374\372\373\375\372\372\373\371"
  "\374\374\367\370\371\366\367\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\366\366\367\367\370\367\373\373\370\336"
  "\347\363\307\327\361\366\370\371\372\372\371\363\364\366\374\375\375\372"
  "\373\373\373\375\376\374\375\375\376\377\377\373\373\374\372\373\376\374"
  "\375\376\371\372\373\375\376\376\372\373\373\372\373\375\373\374\375\374"
  "\375\375\372\373\375\374\375\375\373\374\375\374\375\375\370\371\371\371"
  "\372\373\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\366\367\370\370\371\372\377\377\377\245\256\271\255"
  "\265\276\377\377\377\370\371\373\367\370\372\365\366\366\322\322\324\346"
  "\350\353\351\351\353\345\347\347\340\342\344\360\362\364\340\337\341\347"
  "\352\354\363\364\365\346\347\347\344\345\347\345\347\351\371\373\374\370"
  "\371\372\367\370\371\366\367\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\366\367\367\370\370\370\371\371\370\374"
  "\373\372\362\360\357\314\315\316\343\344\350\365\366\366\357\356\360\346"
  "\347\351\347\350\352\351\353\354\350\351\353\347\350\352\353\354\356\350"
  "\351\353\350\350\353\347\350\350\354\355\357\370\371\372\366\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\366\367\367\370\370\370\371\371\370\374\373\372\362\361\361\346"
  "\347\346\335\340\342\351\352\354\336\337\337\343\346\350\350\351\353\345"
  "\346\350\353\353\356\351\353\354\351\351\353\345\346\350\356\360\361\341"
  "\340\342\350\351\353\364\365\366\347\350\351\350\351\353\352\353\353\351"
  "\352\354\351\352\352\346\351\353\370\370\371\367\367\370\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367\370\371"
  "\371\372\377\377\377\245\256\271\255\265\276\377\377\377\372\373\374\377"
  "\377\377\355\355\355\301\300\302\272\272\275\263\266\272\274\300\304\270"
  "\272\300\331\336\341\314\311\315\310\313\317\335\336\336\270\271\275\267"
  "\272\300\327\332\340\370\371\373\367\370\371\366\367\370\366\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\364\365\367\371\372\373\377\377\377\362\363\365\316\315\317\310"
  "\313\317\340\343\343\305\304\306\266\271\275\263\266\270\271\273\301\272"
  "\276\302\307\311\315\313\315\320\271\272\276\271\271\276\261\264\270\323"
  "\330\334\367\370\373\367\367\370\366\367\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\366\366\367\364\365\367\370"
  "\372\373\377\377\377\352\351\352\316\317\321\277\300\306\305\306\312\272"
  "\272\275\270\272\277\301\304\310\274\275\301\302\307\313\302\305\307\300"
  "\307\311\275\274\300\324\327\335\316\313\315\306\311\315\340\341\341\264"
  "\265\267\272\277\303\266\270\274\275\275\301\302\303\307\302\304\313\363"
  "\365\366\367\370\371\366\367\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\366\367\370\371\371\372\377\377\377\245\256\271\255"
  "\265\276\377\377\377\370\371\373\366\367\373\364\365\370\364\365\366\350"
  "\351\352\350\352\353\356\356\361\353\354\354\363\365\370\366\367\367\362"
  "\363\365\371\372\372\360\361\363\362\362\365\365\365\366\371\372\372\367"
  "\370\371\367\370\371\367\370\370\366\367\370\366\367\370\366\367\367\365"
  "\366\367\365\366\367\365\366\367\366\367\367\366\367\367\364\365\367\365"
  "\366\372\367\370\370\364\365\365\361\362\363\367\370\371\354\354\354\347"
  "\350\353\350\351\352\361\363\366\364\364\367\367\367\370\363\364\364\362"
  "\362\363\362\362\363\360\363\364\365\365\370\371\372\372\367\370\371\366"
  "\367\370\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\366\367\367\366\367\367\365\365\370\365\366\372\366\367\367\357"
  "\360\361\363\366\366\364\365\365\361\361\364\361\363\364\366\367\367\362"
  "\363\364\363\363\364\363\364\364\365\365\366\364\365\366\365\370\371\365"
  "\366\367\362\363\365\371\372\373\354\355\356\351\354\356\362\363\365\361"
  "\362\364\361\362\363\361\362\364\370\371\372\366\367\370\366\367\370\366"
  "\366\367\365\366\367\365\366\367\365\366\367\366\367\370\366\367\370\371"
  "\372\372\377\377\377\245\257\271\255\265\276\377\377\377\366\367\367\364"
  "\365\365\364\365\366\365\366\367\367\370\370\370\371\372\371\372\373\371"
  "\372\373\372\373\374\372\373\373\372\372\373\371\372\373\371\372\373\371"
  "\372\372\370\371\371\366\367\370\366\367\370\366\367\370\366\367\367\364"
  "\365\366\363\364\365\362\363\364\362\363\364\362\363\364\362\363\364\362"
  "\363\364\362\363\364\362\363\364\363\364\364\363\364\365\364\365\366\365"
  "\366\367\365\366\367\366\367\370\370\371\372\372\373\373\372\373\374\372"
  "\373\373\372\372\373\372\372\373\372\373\373\372\373\373\371\372\373\370"
  "\371\372\366\367\370\365\365\366\363\364\365\362\363\364\362\363\364\362"
  "\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362"
  "\363\364\363\364\364\364\365\365\365\366\367\365\366\367\366\367\367\366"
  "\367\370\366\367\370\366\367\370\367\370\370\370\371\372\370\371\372\372"
  "\373\374\372\373\373\372\372\373\372\372\373\371\372\373\371\372\373\372"
  "\373\374\372\373\374\372\373\373\371\372\372\367\370\370\365\366\367\363"
  "\364\365\363\364\364\362\363\364\362\363\364\362\363\364\362\363\364\362"
  "\363\364\362\363\364\363\364\365\365\366\367\376\376\376\246\257\271\255"
  "\265\276\377\377\377\370\370\371\365\366\367\365\366\366\365\366\367\366"
  "\367\370\367\370\371\360\357\356\322\323\325\345\350\352\360\361\361\354"
  "\354\355\352\352\355\357\360\362\360\361\363\355\356\360\362\363\363\347"
  "\347\351\355\356\357\350\351\353\352\355\357\366\367\370\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\365"
  "\365\366\365\366\366\365\366\367\365\366\367\365\366\367\366\367\370\367"
  "\370\370\344\345\346\352\353\355\357\357\362\360\361\362\356\357\361\350"
  "\351\353\354\353\355\351\352\354\356\357\361\346\347\351\354\357\361\366"
  "\367\370\365\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\365"
  "\366\366\365\366\367\365\366\367\365\366\367\365\366\367\366\367\367\367"
  "\370\371\355\356\355\326\327\332\351\352\355\352\354\355\352\355\357\352"
  "\353\355\351\352\354\363\364\364\351\352\352\355\356\360\354\355\357\346"
  "\347\351\365\366\366\366\367\370\365\366\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\365\366\367\367"
  "\370\371\377\377\377\245\257\271\255\265\276\377\377\377\371\372\372\366"
  "\367\370\365\366\367\365\366\367\366\367\370\370\371\372\352\347\350\273"
  "\276\276\260\261\265\262\267\273\275\301\303\301\303\307\264\264\273\307"
  "\312\314\271\274\300\334\337\341\275\271\271\255\261\265\272\274\303\337"
  "\341\345\370\371\372\366\367\370\365\366\367\365\366\367\365\366\367\366"
  "\366\367\366\367\367\367\367\370\367\370\370\370\370\370\370\370\370\367"
  "\370\370\367\370\370\370\371\371\371\370\370\313\307\307\301\304\307\271"
  "\271\273\265\265\271\274\303\306\317\321\327\330\327\331\260\257\265\264"
  "\271\275\300\300\306\343\345\351\370\371\372\366\367\370\366\367\367\366"
  "\367\367\366\367\367\366\367\367\366\367\367\366\367\367\366\367\367\366"
  "\367\367\366\367\370\366\367\367\365\366\367\365\366\367\365\366\367\366"
  "\367\367\366\367\370\366\367\370\370\371\372\352\351\352\312\315\316\302"
  "\300\303\265\272\274\272\273\276\266\270\276\260\261\264\325\332\340\304"
  "\303\307\262\263\266\264\267\275\314\315\323\361\364\366\367\370\371\366"
  "\367\370\366\367\367\366\367\367\366\366\367\366\366\367\366\367\367\366"
  "\367\370\366\367\370\367\367\370\371\372\372\377\377\377\245\256\271\255"
  "\265\276\377\377\377\367\367\371\363\364\367\362\363\366\362\363\366\362"
  "\363\366\364\365\367\361\362\365\353\356\357\345\346\351\334\335\337\341"
  "\344\350\355\356\356\350\351\353\355\356\357\352\353\355\364\365\367\345"
  "\346\350\342\343\347\344\345\351\354\357\361\364\365\367\362\363\366\362"
  "\363\366\362\363\366\362\363\366\363\364\366\362\364\365\355\361\370\357"
  "\363\367\357\363\370\357\363\370\356\361\370\354\360\365\354\360\365\356"
  "\360\367\343\345\354\342\346\356\344\346\347\346\346\351\351\353\357\356"
  "\361\363\357\360\362\342\343\346\342\345\347\345\350\352\355\356\360\366"
  "\366\367\364\365\370\364\365\367\362\365\365\362\363\365\362\363\366\362"
  "\363\366\362\365\365\364\365\365\364\365\367\364\365\370\364\365\367\363"
  "\364\366\362\363\366\362\363\366\363\364\366\363\364\367\364\365\367\365"
  "\366\371\361\362\362\342\344\346\350\350\354\347\352\354\347\350\354\347"
  "\352\354\345\346\347\357\362\365\354\355\355\343\345\347\344\347\351\347"
  "\350\354\360\363\365\364\365\367\364\364\367\364\365\367\364\365\367\364"
  "\364\367\362\365\365\362\363\365\362\363\366\362\363\366\363\366\366\367"
  "\370\372\377\377\377\245\257\271\255\265\276\375\377\376\375\375\376\376"
  "\375\376\373\374\375\372\374\375\373\374\375\373\374\375\376\375\376\377"
  "\377\377\377\377\377\377\377\377\371\372\374\371\372\372\367\370\370\355"
  "\356\357\360\361\362\370\371\375\377\377\377\377\377\377\377\377\377\376"
  "\376\377\373\374\375\373\374\375\372\374\375\373\374\375\375\375\375\372"
  "\373\374\347\354\365\360\364\374\346\346\354\336\342\350\327\333\344\356"
  "\362\371\370\372\377\366\371\376\367\371\376\371\373\377\363\370\377\353"
  "\361\371\377\377\377\360\357\361\367\370\373\377\377\377\377\377\377\377"
  "\377\377\372\373\376\366\371\372\370\371\373\367\370\373\367\370\372\363"
  "\366\370\371\372\374\371\372\374\372\373\375\370\367\373\356\361\365\372"
  "\373\375\354\353\355\362\365\367\376\376\376\373\374\375\373\375\375\367"
  "\370\372\364\367\370\367\370\372\370\371\373\371\372\374\367\371\373\375"
  "\376\377\375\376\377\376\377\377\374\375\377\365\366\371\377\377\377\360"
  "\357\361\370\371\373\377\377\377\377\377\377\375\376\377\367\370\373\364"
  "\367\370\367\370\372\367\370\372\367\370\372\363\366\370\371\372\374\371"
  "\372\374\372\373\375\370\367\373\365\366\370\377\377\377\245\257\271\254"
  "\264\276\375\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\360"
  "\357\361\275\274\277\274\301\307\266\264\272\300\303\310\354\357\362\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\346\354\366\377\377\377\342"
  "\337\334\335\335\335\314\316\321\366\367\367\377\377\377\377\377\377\377"
  "\377\377\377\377\377\375\377\377\347\355\367\377\377\375\324\323\324\347"
  "\353\355\377\377\377\377\377\377\377\377\377\374\375\376\370\371\374\360"
  "\361\361\354\357\360\371\372\372\371\372\374\375\375\375\325\327\327\354"
  "\354\356\375\375\377\360\362\365\376\375\374\322\322\322\346\351\354\377"
  "\377\377\377\377\377\377\377\377\373\374\375\370\371\373\360\361\361\355"
  "\357\360\371\372\373\372\373\375\377\376\376\327\330\331\356\355\357\377"
  "\376\377\362\363\367\377\376\375\324\323\324\347\353\355\377\377\377\377"
  "\377\377\377\377\377\373\375\375\370\371\373\360\361\363\354\355\360\371"
  "\372\372\371\372\374\375\375\375\325\327\327\354\354\356\376\375\377\365"
  "\366\370\377\377\377\245\257\271\254\264\276\375\376\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\363\364\367\332\333\335\337\342\344\341"
  "\342\344\344\344\350\357\362\364\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\346\354\366\374\375\375\354\351\350\351\350\350\341\342\343\371"
  "\370\370\377\377\377\377\377\377\377\377\377\377\377\377\375\377\377\346"
  "\354\366\377\377\377\357\356\355\370\372\373\377\377\377\377\377\377\377"
  "\377\377\374\375\376\370\371\374\360\361\364\356\357\360\371\372\372\371"
  "\372\374\375\375\375\327\327\331\354\356\356\375\375\377\360\361\365\377"
  "\377\377\357\356\355\370\371\372\377\377\377\377\377\377\377\377\377\374"
  "\375\376\370\371\373\360\361\363\357\357\360\371\372\373\371\372\375\376"
  "\375\376\330\330\332\355\356\356\376\375\377\360\362\365\377\377\377\356"
  "\356\355\370\371\372\377\377\377\377\377\377\377\377\377\373\375\375\370"
  "\371\373\360\361\363\356\357\360\371\372\372\371\372\374\375\375\375\330"
  "\327\331\354\356\356\376\376\377\365\366\370\377\377\377\245\257\271\255"
  "\265\276\375\377\377\373\374\376\375\376\377\373\375\376\373\374\375\373"
  "\374\375\373\374\375\373\374\375\373\374\375\374\375\376\373\375\375\365"
  "\366\370\371\372\373\372\373\374\372\373\374\371\372\372\363\366\370\372"
  "\373\375\374\375\376\373\374\375\373\374\375\373\374\375\373\374\375\373"
  "\374\375\373\374\375\374\375\376\372\373\375\346\353\365\361\365\375\371"
  "\373\377\371\374\377\366\370\376\364\366\375\366\370\377\366\370\377\366"
  "\370\377\367\371\377\361\364\374\350\354\366\375\375\377\377\377\377\377"
  "\377\377\375\377\377\375\376\377\375\376\377\371\372\374\366\371\372\371"
  "\372\374\371\371\374\370\371\371\364\365\371\372\373\375\371\372\374\372"
  "\372\374\366\367\373\357\362\365\374\375\376\377\377\377\377\377\377\375"
  "\376\377\375\376\377\375\376\377\370\371\374\366\371\371\371\371\374\371"
  "\372\374\370\371\372\365\366\372\373\374\376\372\373\375\373\373\375\367"
  "\370\374\357\362\365\373\374\376\376\377\377\375\376\377\374\375\376\373"
  "\375\376\374\375\376\367\370\373\365\370\370\370\370\373\370\371\373\367"
  "\370\371\364\365\371\372\373\375\371\372\374\373\372\374\367\370\374\366"
  "\366\370\377\377\377\246\257\271\255\265\276\377\377\377\362\364\365\357"
  "\357\362\356\357\361\355\356\361\355\356\361\355\356\361\355\356\361\355"
  "\356\361\355\357\361\356\357\362\361\362\363\363\364\365\364\365\366\364"
  "\365\365\363\364\365\361\362\363\356\357\362\356\357\361\355\356\361\355"
  "\356\361\355\356\361\355\356\361\355\356\361\355\356\361\356\357\361\357"
  "\360\362\356\361\362\351\355\362\352\354\362\352\354\363\352\354\363\352"
  "\354\363\352\356\363\352\354\363\351\355\364\355\361\366\356\361\366\363"
  "\365\366\364\366\366\363\366\366\363\364\366\363\364\366\362\365\366\362"
  "\363\365\363\364\366\365\366\366\363\366\366\362\364\365\362\363\363\357"
  "\360\363\357\360\362\357\360\363\357\360\363\360\361\362\361\363\363\364"
  "\365\363\366\366\364\364\365\364\362\363\365\361\362\364\361\364\364\362"
  "\363\365\363\365\366\364\365\366\364\365\366\364\365\365\362\363\366\363"
  "\364\366\363\364\366\362\363\366\361\362\364\360\363\363\357\360\362\356"
  "\357\362\356\357\362\356\357\361\355\356\361\356\357\361\356\357\362\357"
  "\361\362\357\361\362\357\362\362\357\362\362\357\360\362\357\360\362\357"
  "\360\363\357\360\363\360\361\363\364\365\367\376\377\376\246\257\271\255"
  "\265\276\377\377\377\370\370\371\365\366\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\365\365\366\365\366\366\365"
  "\366\366\365\366\366\365\366\366\366\367\367\366\367\367\336\335\335\324"
  "\326\330\350\352\352\350\350\350\350\350\352\347\350\352\350\350\351\340"
  "\343\345\330\327\333\343\346\350\355\356\356\337\340\342\345\346\350\340"
  "\341\343\346\350\353\367\370\370\365\366\367\365\366\366\365\366\366\365"
  "\366\366\366\367\366\372\372\367\351\354\365\342\350\365\356\356\357\350"
  "\347\346\357\361\363\366\366\367\360\361\363\354\354\355\357\360\362\364"
  "\365\365\363\364\366\356\357\357\342\345\345\356\360\362\363\364\364\363"
  "\363\365\367\370\370\365\366\367\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\365\366\367\367"
  "\370\371\377\377\377\246\257\271\255\265\276\377\377\377\371\372\372\366"
  "\367\370\366\367\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\366\367\367\365\366\367\365\366\367\365\366\367\366\367\367\367"
  "\370\370\366\365\365\322\324\330\313\312\314\275\277\301\267\272\276\304"
  "\310\312\302\301\303\264\267\271\307\313\317\274\272\276\270\273\277\337"
  "\340\342\270\265\267\262\267\273\277\277\305\334\336\342\367\370\371\367"
  "\370\370\366\367\370\366\367\370\367\370\370\371\371\370\367\371\370\206"
  "\256\350@\224\347\277\310\336\276\275\270\301\307\312\306\306\312\302\305"
  "\307\262\265\271\273\275\302\271\274\300\306\313\317\335\334\337\267\270"
  "\272\270\271\275\270\273\276\312\316\322\366\367\371\367\370\371\366\367"
  "\370\366\367\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\366\366\367\366\367\367\366\367"
  "\367\366\367\370\366\367\370\371\372\372\377\377\377\245\257\271\255\265"
  "\276\377\377\377\371\372\372\366\367\370\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\363\364\367\362\364\366\362\363"
  "\366\362\363\365\362\363\366\362\364\366\364\365\370\354\355\357\353\355"
  "\360\356\360\363\355\356\362\360\362\364\362\363\365\355\360\364\362\365"
  "\367\357\360\362\352\355\357\363\366\370\353\354\356\354\354\360\355\357"
  "\361\356\360\362\364\366\367\363\363\366\362\363\365\363\364\366\363\364"
  "\366\365\366\366\367\367\367\230\270\351Z\234\346\317\331\355\356\354\350"
  "\340\342\343\337\337\341\350\353\353\342\344\344\340\341\343\337\342\342"
  "\351\354\356\364\363\365\346\347\347\341\342\344\341\341\343\341\344\350"
  "\367\370\370\367\370\370\366\367\370\366\367\370\365\366\367\365\366\367"
  "\365\366\366\365\366\366\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\366\367\367\366\367\367\366\367\370\371\372\372"
  "\377\377\377\245\257\271\255\265\276\377\377\377\371\372\372\366\367\370"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\362\363\366\374\373\376\376\376\377\376\375\376\376\375\376\376\375\376"
  "\376\376\377\377\377\377\377\377\377\377\377\377\377\377\377\363\365\371"
  "\377\377\377\354\351\353\365\366\371\377\377\377\377\377\377\377\377\377"
  "\374\375\377\372\374\375\374\374\375\373\374\374\370\372\373\365\366\372"
  "\373\374\376\371\372\372\374\374\376\373\372\373\365\365\366\361\363\370"
  "\353\356\366\367\371\373\373\373\374\371\371\373\370\371\373\370\371\374"
  "\366\370\373\370\371\373\370\371\373\370\371\373\367\370\372\364\367\371"
  "\367\370\374\367\370\374\366\367\372\364\365\370\361\364\366\364\365\371"
  "\361\362\366\364\365\371\364\365\367\363\364\367\363\364\367\360\363\366"
  "\363\364\366\363\364\367\364\364\367\362\364\367\360\363\365\362\363\367"
  "\363\364\370\363\364\370\365\366\370\376\377\376\246\257\271\255\265\276"
  "\377\377\377\371\372\372\366\367\370\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\362\363\366\376\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\360\362\367\376\375\374\323\322\325\347\352\355"
  "\377\377\377\377\377\377\377\377\377\374\375\376\371\371\372\355\360\360"
  "\351\352\354\371\372\373\371\372\374\374\373\374\313\315\317\347\350\350"
  "\376\375\377\362\363\366\377\377\376\340\336\334\362\362\363\377\377\377"
  "\377\377\377\377\377\377\377\377\377\372\373\375\371\372\375\371\373\374"
  "\371\373\374\372\373\375\372\373\375\377\377\377\365\365\367\375\375\376"
  "\372\373\375\360\363\367\376\373\374\331\330\332\363\365\367\377\377\377"
  "\377\377\377\377\377\377\370\371\374\370\371\373\367\372\372\367\372\373"
  "\371\372\374\371\372\374\377\376\377\364\363\365\375\374\376\375\376\377"
  "\375\375\376\246\257\271\255\265\276\377\377\377\371\372\372\366\367\370"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\362\363\366\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\356\361\366"
  "\377\377\377\365\365\364\373\375\375\377\377\377\377\377\377\377\377\377"
  "\374\375\376\370\371\373\364\364\365\362\363\363\371\372\372\371\372\374"
  "\375\375\377\341\342\343\362\363\363\375\375\377\361\362\365\376\376\374"
  "\330\327\330\352\355\360\377\377\377\377\377\377\377\377\377\377\377\377"
  "\372\373\374\370\371\372\345\346\350\345\346\351\371\372\373\371\372\375"
  "\367\367\371\267\271\273\353\352\354\374\373\375\360\363\367\375\373\372"
  "\326\325\326\357\362\365\377\377\377\377\377\377\377\377\377\372\373\374"
  "\370\371\372\345\346\350\345\346\350\371\372\372\371\372\374\367\366\370"
  "\267\270\273\354\353\355\377\376\377\375\375\376\246\257\271\255\265\276"
  "\377\377\377\371\372\372\366\367\370\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\361\364\366\367\370\373\372\371\374"
  "\371\371\373\371\371\373\371\371\373\371\371\373\371\371\373\371\371\373"
  "\372\371\374\367\370\373\357\362\364\370\371\374\374\373\376\373\373\375"
  "\372\371\374\372\371\374\370\371\374\365\367\371\365\366\370\365\370\371"
  "\366\370\371\365\366\371\362\364\367\367\367\373\367\370\374\370\371\373"
  "\364\365\371\360\361\365\377\377\377\376\376\374\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\372\373\374\370\371\374\367\370\371"
  "\370\371\371\371\372\374\371\372\374\376\377\377\360\360\360\374\374\374"
  "\372\373\375\360\363\367\377\377\377\374\374\374\377\377\377\377\377\377"
  "\377\377\377\377\377\377\372\373\374\370\371\373\367\370\371\370\370\371"
  "\371\372\374\371\372\374\377\377\377\361\360\360\375\375\375\375\376\377"
  "\375\375\376\246\257\271\255\265\276\377\377\377\371\372\373\367\370\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\367\366\367\367\366\367\367"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\367\366\367\367\366\367\367\366\367\367"
  "\366\367\367\363\364\367\363\364\366\363\364\366\363\364\366\363\364\366"
  "\363\364\366\363\364\366\363\364\366\363\364\366\363\364\367\364\365\367"
  "\364\365\367\363\365\367\363\364\367\363\364\366\363\364\366\363\364\366"
  "\363\364\367\364\365\367\364\365\367\364\365\367\364\365\367\364\365\367"
  "\364\365\367\364\365\370\364\365\367\364\365\367\362\365\365\364\365\371"
  "\365\366\372\365\366\372\364\365\367\363\364\367\363\364\367\364\365\367"
  "\361\364\366\362\364\367\364\365\367\364\365\367\362\365\367\360\363\365"
  "\363\364\370\363\364\370\363\364\370\361\363\365\361\363\365\364\366\371"
  "\365\366\372\364\366\370\364\365\367\363\365\367\364\365\367\361\364\366"
  "\362\364\367\364\365\367\364\365\367\362\365\367\360\363\365\363\364\370"
  "\364\365\370\364\365\371\364\367\370\375\377\376\246\257\271\255\265\277"
  "\377\377\377\366\367\367\364\365\365\363\364\365\363\364\365\363\364\365"
  "\363\364\365\363\364\365\363\364\365\363\364\365\363\364\365\363\364\364"
  "\363\363\364\363\363\364\363\363\364\363\364\364\363\364\365\363\364\365"
  "\363\364\365\363\364\365\363\364\365\363\364\365\363\363\364\363\364\364"
  "\363\364\364\364\364\364\364\364\365\363\364\365\363\364\365\363\364\365"
  "\363\364\365\363\364\364\363\364\365\363\364\365\363\364\365\363\364\364"
  "\363\364\364\363\364\365\363\364\365\363\364\365\363\364\365\363\364\365"
  "\363\364\365\363\364\364\363\364\364\362\363\364\362\363\364\362\363\364"
  "\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364"
  "\362\363\364\362\363\364\360\361\364\360\361\364\360\361\363\360\361\363"
  "\360\361\363\360\361\363\360\361\363\360\361\364\362\363\364\362\363\364"
  "\362\363\364\362\363\364\361\362\364\361\362\364\361\362\364\361\362\364"
  "\361\362\364\363\364\364\361\361\364\360\361\364\360\361\364\360\361\363"
  "\360\361\363\360\361\363\360\361\364\362\363\364\362\363\364\362\363\364"
  "\362\363\364\361\362\364\361\362\364\361\362\365\362\363\365\366\367\367"
  "\377\377\376\246\257\271\255\265\277\377\377\377\367\367\370\365\366\366"
  "\365\366\367\365\366\371\363\366\367\363\366\366\363\366\366\363\366\366"
  "\363\366\366\363\365\366\362\364\365\361\364\364\363\364\366\363\364\364"
  "\362\364\365\364\365\366\365\366\370\365\366\366\363\366\366\363\365\366"
  "\362\365\365\361\364\365\364\364\364\367\367\367\371\371\367\371\371\370"
  "\370\371\371\370\370\371\367\370\371\367\370\370\366\370\370\367\370\371"
  "\367\370\371\367\370\371\367\370\370\366\367\370\366\367\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\366\367\370\366\367\367"
  "\365\366\367\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366"
  "\364\365\366\365\366\367\367\370\371\377\377\377\246\257\271\255\265\277"
  "\376\377\377\372\373\375\366\367\372\344\345\351\362\363\367\371\372\374"
  "\370\371\374\371\371\374\370\371\374\370\367\373\367\370\372\371\371\373"
  "\371\371\374\357\362\366\365\366\372\370\371\371\352\351\355\353\356\362"
  "\366\370\372\372\371\375\371\371\374\370\371\373\372\372\374\367\367\370"
  "\370\371\367\357\362\367\363\365\371\361\356\356\355\355\356\366\371\371"
  "\360\361\362\367\370\371\370\367\371\356\357\357\361\364\365\370\370\371"
  "\370\371\372\367\367\370\367\370\371\370\370\371\370\371\371\370\371\371"
  "\366\367\367\367\370\370\365\370\370\370\371\372\366\367\370\366\367\370"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\366\366\367\366\367\370\366\367\370\371\372\372"
  "\377\377\377\245\257\271\255\266\277\376\377\377\377\377\377\365\361\362"
  "\277\301\301\277\300\302\307\312\316\322\322\324\313\314\316\311\312\314"
  "\312\313\317\277\300\304\346\351\355\377\377\377\357\362\366\372\373\375"
  "\366\366\365\332\332\334\326\327\331\313\314\320\320\317\321\307\310\313"
  "\317\320\324\375\376\376\375\375\374\341\350\363\\\231\345\210\257\351\313"
  "\312\315\322\323\325\315\317\321\302\305\314\337\340\342\307\310\312\272"
  "\271\301\274\275\301\276\301\307\336\341\345\315\320\322\300\303\305\303"
  "\306\314\313\312\314\276\302\307\303\306\310\275\300\304\306\310\316\365"
  "\365\370\367\370\371\366\367\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366"
  "\367\367\366\367\370\371\371\372\377\377\377\245\257\271\256\266\277\377"
  "\377\377\377\377\377\375\373\373\354\354\354\336\337\337\340\343\345\352"
  "\351\353\331\330\332\340\342\343\351\350\352\332\333\333\357\362\364\377"
  "\377\377\360\362\366\372\374\375\375\373\374\345\344\345\347\347\351\343"
  "\342\342\340\341\341\332\333\334\337\340\343\377\377\377\376\376\375\337"
  "\347\363Y\233\347s\244\351\336\335\340\340\341\341\335\336\337\334\337\343"
  "\353\352\354\323\324\326\336\335\343\330\331\333\327\333\335\356\360\362"
  "\345\345\346\325\326\332\337\342\346\334\333\335\320\323\327\341\344\344"
  "\330\331\333\327\334\340\367\367\372\367\370\371\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370"
  "\366\367\370\366\367\370\366\367\370\367\370\371\371\372\373\377\377\377"
  "\246\257\272\261\271\301\377\377\377\374\375\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\375\374\377\362\365\370\371\372\374\377\376\377"
  "\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\372\372\374\370\370\372\347\355\367\352\357\370\377\376\375"
  "\376\376\375\376\377\377\376\376\376\375\376\376\374\375\375\376\377\377"
  "\376\377\377\376\376\377\375\375\376\375\376\376\374\375\377\376\377\377"
  "\376\377\377\375\375\376\376\377\377\376\376\377\374\375\375\372\373\373"
  "\371\372\372\371\371\372\371\371\372\371\371\372\370\371\372\370\371\372"
  "\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372"
  "\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372"
  "\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372"
  "\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372"
  "\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372\370\371\372"
  "\370\371\372\370\371\372\370\371\372\371\371\372\371\371\372\371\371\372"
  "\371\372\373\374\374\375\377\377\377\251\262\274\270\276\307\377\377\377"
  "\377\377\377\376\376\377\375\376\377\376\376\377\376\376\377\376\376\377"
  "\376\376\377\376\376\377\376\376\377\375\376\377\375\375\376\375\375\376"
  "\375\375\376\375\375\376\375\375\376\375\375\377\375\376\377\376\376\377"
  "\376\376\377\376\376\377\375\376\377\375\375\376\376\376\376\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\262\270\302l}\223\264\274\304\253\263\274\247\260\272\246\260\272\247\260"
  "\272\247\260\272\247\260\272\247\260\272\247\260\272\246\260\271\246\260"
  "\271\246\257\271\246\257\271\246\257\271\246\257\271\246\257\271\246\257"
  "\271\246\257\271\246\260\272\247\260\272\247\260\272\246\257\271\246\257"
  "\271\247\257\271\250\260\271\251\261\272\251\261\272\250\260\272\247\260"
  "\272\246\257\272\246\257\272\246\257\272\246\257\272\246\257\272\246\257"
  "\272\246\257\272\246\257\272\246\257\272\246\257\272\246\257\272\246\257"
  "\272\246\257\272\246\257\272\246\257\272\246\257\271\246\257\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256\271\245\256"
  "\271\245\256\271\245\256\271\245\256\271\245\256\271\245\257\271\246\257"
  "\272\251\262\274\262\272\302au\216",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Make icon from Icon struct.
 *
 * @param[in]  ic_name  Name of Icon struct
 * @return     Pixbuf with icon
 */
static GdkPixbuf *
make_icon (const Icon *ic_name)
{
    return gdk_pixbuf_new_from_data (
            ic_name->pixel_data,
            GDK_COLORSPACE_RGB,
            TRUE,
            8,
            ic_name->width,
            ic_name->height,
            ic_name->width * ic_name->bytes_per_pixel,
            NULL,
            NULL
            );
}
/*----------------------------------------------------------------------------*/
/**
 * @brief  Get image from stored data.
 */
GdkPixbuf *
get_image (const IconImg i_img)
{
    GdkPixbuf *gp_pbuf = NULL; /* Return pixbuf */

    switch (i_img) {

        case W_ICON_ADD:
            gp_pbuf = make_icon (&icon_add);
            break;

        case W_ICON_ADD_DIR:
            gp_pbuf = make_icon (&icon_add_dir);
            break;

        case W_ICON_REMOVE:
            gp_pbuf = make_icon (&icon_remove);
            break;

        case W_ICON_REVERT:
            gp_pbuf = make_icon (&icon_rev);
            break;

        case W_ICON_SORT:
            gp_pbuf = make_icon (&icon_srt);
            break;

        case W_ICON_SELECT:
            gp_pbuf = make_icon (&icon_select);
            break;

        case W_ICON_DUPL:
            gp_pbuf = make_icon (&icon_dupl);
            break;

        case W_ICON_INFO:
            gp_pbuf = make_icon (&icon_info);
            break;

        case W_ICON_ABOUT:
            gp_pbuf = gdk_pixbuf_new_from_data (
                image_about.pixel_data,
                GDK_COLORSPACE_RGB,
                FALSE,
                8,
                image_about.width,
                image_about.height,
                image_about.width * image_about.bytes_per_pixel,
                NULL,
                NULL
                );
            break;

        case W_ICON_COUNT:
            break;

        default:
            break;
    }
    return gp_pbuf;
}
/*----------------------------------------------------------------------------*/


