/*
    Copyright (C) 2004, 2005, 2006, 2007 Nikolas Zimmermann <zimmermann@kde.org>
                  2004, 2005 Rob Buis <buis@kde.org>
                  2005 Eric Seidel <eric@webkit.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    aint with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef SVGFEFlood_h
#define SVGFEFlood_h

#if ENABLE(SVG) && ENABLE(SVG_FILTERS)
#include "Color.h"
#include "FilterEffect.h"

namespace WebCore {

    class FEFlood : public FilterEffect {
    public:
        static PassRefPtr<FEFlood> create(const Color&, const float&);

        Color floodColor() const;
        void setFloodColor(const Color &);

        float floodOpacity() const;
        void setFloodOpacity(float);

        virtual void apply();
        virtual void dump();
        TextStream& externalRepresentation(TextStream& ts) const;

    private:
        FEFlood(const Color&, const float&);

        Color m_floodColor;
        float m_floodOpacity;
    };

} // namespace WebCore

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)

#endif // SVGFEFlood_h
