#!/usr/bin/env python

# examples.demogame.areas

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


from svs_demogame.clients import GameWorldClient


# create gameworld client
# set login name and password for client, and time interval for simulation clock
gameworld = GameWorldClient("gameworld", "g@m3w0rld", tickDuration=100) 

# load game data and custom classes
gameworld.loadWorld("game_data/areas.xml")

# start game
gameworld.startClock()

# comment out to see log messages in client console
gameworld.logging = False 

# connect to server
# set name or address of host and port
gameworld.connect("testgroup", "localhost", 9797)

