#!/usr/bin/env python

# devtools.coder

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Basic coder development tool.


@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# external imports


# svs imports
from svs_core.network.clientuser import GraphicalClient
from svs_core.dev.devlib import DevNode, DevManager
from svs_core.commands.scriptcommands import *
from svs_core.network.packets import *
from svs_core.utilities.constants import svs_const

# internal imports
from codergui import CoderGUI


class CoderClient(GraphicalClient):
	"""
	SVS client providing basic code development capabilities.
	"""
	def __init__(self, name, passwd):
		GraphicalClient.__init__(self, name, passwd, guiClass=CoderGUI)
		self.devManager = DevManager(self)
		self.sourceWriter = None
		self.sourceReader = None
		self.sourceComparator = None
		self.sourceMerger = None
		
	def createDevNode(self, nodeName):
		"""
		Creates node with specified name.
		"""
		self.devManager.addNode(DevNode(nodeName,
				sourceWriter=self.sourceWriter, 
				sourceReader=self.sourceReader, 
				sourceComparator=self.sourceComparator,
				sourceMerger=self.sourceMerger))
		
	#########################
	# PRIVATE SCRIPT COMMANDS
	#########################
	def cmdprivate_devnode(self, cmd):
		"""
		Create new development node.
		"""
		try:nodeName = cmd.args[0]
		except IndexError:return makeCommandResult(cmd, message="no node name specified", status=svs_const.ERROR)
		if not nodeName:return makeCommandResult(cmd, message="no node name specified", status=svs_const.ERROR)
		self.createDevNode(nodeName)
		return makeCommandResult(cmd, message="node '%s' created" % nodeName, status=svs_const.OK)

	def cmdprivate_devnodes(self, cmd):
		"""
		List development nodes.
		"""
		pass
		
	def cmdprivate_devline(self, cmd):
		"""
		Create new development line on specified node.
		"""
		pass
		
	
	def cmdprivate_devlines(self, cmd):
		"""
		List development lines on all nodes or specified node.
		"""
		pass
		
	def cmdprivate_deventry(self, cmd):
		"""
		Create new development entry.
		"""
		pass
		
	def cmdprivate_deventries(self, cmd):
		"""
		List development entries.
		"""
		pass
		



#########################
# MAIN
#########################
if __name__ == '__main__':
	import sys
	coderClient = CoderClient(sys.argv[1], sys.argv[2])
	coderClient.runLocally()
	#coderClient.connect("time_group", "localhost", 9797)