# devtools.codergui

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Graphical User Interface for devtool using wxPython toolkit.


@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# external imports
import wx

# internal imports
from svs_core.gui.clientgui_wx import ClientGUI


# wxPython events
ID_ENTER_BUTTON=110
ID_HISTORY_BUTTON=111
ID_RESET_BUTTON=112
ID_QUIT_BUTTON=113
ID_INPUTFIELD=120


class CoderGUI(ClientGUI):
	"""
	GUI derived from L{svs_core.gui.clientgui_wx.ClientGUI}.
	"""
	def __init__(self, client):
		ClientGUI.__init__(self, client)
		
	def buildStandardComponents(self):
		"""
		Creates interface components.
		"""
		### components ###
		self.mainSizer = wx.BoxSizer(wx.VERTICAL)
		#console
		self.consoleSizer = wx.BoxSizer(wx.VERTICAL)
		self.inputField = wx.TextCtrl(self.root, ID_INPUTFIELD)
		wx.EVT_CHAR(self.inputField, self.inputFieldAdjusted)
		self.console = wx.TextCtrl(self.root, -1, style=wx.TE_MULTILINE | wx.TE_READONLY)
		# input
		self.inputBuffer = []
		self.inputBufferMaxSize = 20
		self.inputBufferIndex = 0
		self.consoleSizer.Add(self.inputField, 0, wx.EXPAND)
		self.consoleSizer.Add(self.console, 1, wx.EXPAND)
		self.mainSizer.Add(self.consoleSizer, 1, wx.EXPAND)
		#Layout sizers
		self.root.SetSizer(self.mainSizer)
		self.root.SetAutoLayout(1)
		# show
		self.inputField.SetFocus()
		