# svs

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Installation script for SVS

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

from distutils.core import setup

setup(name='svs',
      version='0.4',
      description='Social Versioning System',
      author='Simon Yuill',
      author_email='simon@lipparosa.org',
      url='http://www.spring-alpha.org/svs',
      license='GNU GPL version 2 or any later version',
      packages=['svs_analysis',
		'svs_analysis.analysis',
		'svs_analysis.extraction',
		'svs_analysis.translation',
		'svs_analysis.visualisation',
		'svs_analysis.workers',
		'svs_core', 
		'svs_core.commands',
		'svs_core.filehandling',
		'svs_core.gui',
		'svs_core.network',
		'svs_core.time',
		'svs_core.utilities',
		'svs_demogame', 
		'svs_simulation', 
		'svs_simulation.actions',
		'svs_simulation.agents',
		'svs_simulation.agents.agentstates',
		'svs_simulation.agents.agentstates.movement',
		'svs_simulation.agents.agentstates.steering',
		'svs_simulation.ai_lib',
		'svs_simulation.behaviours',
		'svs_simulation.entities',
		'svs_simulation.events',
		'svs_simulation.network',
		'svs_simulation.numdata',
		'svs_simulation.simdata',
		'svs_simulation.simobjects',
		'svs_simulation.simtime',
		'svs_simulation.terrain',
		'svs_simulation.utilities',
		'svs_simulation.world',
		'svs_soya',
		'svs_soya.basic',
		'svs_soya.network'],
     )
