# svs_tracking.translation.vistranslator

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Classes and functions to translate CVS data into visualisation objects.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_tracking.translation.translator import *
from svs_tracking.visualisation.timeline import Timecode, TimeFrame, timecodeFromDateString
from svs_tracking.visualisation.events import CVSLogEvent


class CVSLogTranslator(Translator):
	def translate(self, sourceData):
		for entry in sourceData:
			logEvent = CVSLogEvent()
			logEvent.date = entry.get('date', None)
			logEvent.message = entry.get('message', None)
			logEvent.author = self.cvsDataSource.addContributer(entry.get('author', None))
			logEvent.revision = entry.get('revision', None)
			logEvent.state = entry.get('state', None)
			logEvent.lines = entry.get('lines', None)
			try:
				logEvent.timecode = timecodeFromDateString(logEvent.date)
			except:
				continue
			if logEvent.timecode:
				self.destination.addEvent(logEvent)
