# svs_tracking.visualisation.player

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Provides classes for controlling temporal 'playback' in visualisation.


@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# external imports
from datetime import timedelta

# internal imports
from svs_tracking.visualisation.timeline import *


#########################
# EXCEPTIONS
#########################
class PlayerException(Exception):
	"""
	Generic exception class for handling L{Player}.
	"""
	pass

class Player:
	def __init__(self):
		self.playing = False
		self.startTime = 0
		self.currentTime = 0
		self.looping = False
		self.playrate = 1
	
	def play(self):
		"""
		Start playback.
		"""
		self.playing = True

	def pause(self):
		"""
		Pause playback.
		"""
		self.playing = False

	def stop(self):
		"""
		Stop playback and rewind.
		"""
		self.playing = False
		self.reset()
		print "play stopped"

	def reset(self):
		"""
		Resets playback to start conditions.
		"""
		self.currentTime = self.startTime
	
	def nextFrame(self):
		"""
		Plays, or retrieves, next frame.
		"""
		return None


class TimelinePlayer(Player):
	"""
	Player for timeline data.
	"""
	def __init__(self, timeline=None, startTime=None, endTime=None):
		Player.__init__(self)
		self.timeline = timeline
		self.startTime = startTime
		self.endTime = endTime
		self.timeDelta = None
		self.currentFrame = None
		
	
	def setTimeDelta(self, days=0, hours=0, minutes=0, seconds=0):
		"""
		Sets the amount of time that is incremented each time
		the player moves forward one frame.
		"""
		self.timeDelta = timedelta(days=days, hours=hours, minutes=minutes, seconds=seconds)	
		self.reset()

	def play(self):
		"""
		Start playback, checks that there is timeline to play.

		@raise L{PlayerException}: if no timeline present.
		"""
		if not self.timeline:
			self.playing = False
			raise PlayerException("no timeline")
		self.playing = True

	def reset(self):
		"""
		Resets playback to start conditions.

		NOTE: to properly play in reverse, it needs to be possible
		to call total duration (or last frame) from timeline
		"""
		self.currentFrame = None
		self.currentTime = self.startTime
		print "reset"
		

	def incrementTime(self):
		"""
		Increments L{Player.currentTime}, according to a
		combination of L{Player.frameTime} and L{Player.playrate}
		
		@return : updated L{Player.currentTime}
		"""
		#return self.currentTime.add(self.timeDelta * self.frameDelta)
		self.currentTime = self.currentTime + self.timeDelta
		return self.currentTime

	def nextFrame(self):
		"""
		Returns next frame from timeline, storing an internal copy
		as L{Player.currentFrame}.

		If L{Player.playing} then increments L{Player.currentTime} before 
		doing so, otherwise returns existing value for L{self.currentFrame}.

		@return: Player.currentFrame
		"""
		if self.playing:
			print "self.currentTime:", self.currentTime
			self.currentFrame = self.timeline.getFrame(self.currentTime)
			if self.currentTime > self.endTime:
				if self.looping:
					self.reset()
					self.currentFrame = self.timeline.getFrame(self.currentTime)
				else: 
					self.stop()
			self.incrementTime()
			return self.currentFrame
		else:
			print "not playing"
			return None
