# svs_core.gui.utilities

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Utility functions and classes for GUIs.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

def printFormatCommandList(listData, tabSize=4, includeDocs=False):
	"""
	Prints out a formatted text list of commands from a
	dictionary.
	
	Note: does not currently support display of 
	documentation info for commands.
	"""
	tab = ' ' * tabSize
	text = ''
	if listData.has_key('owner'):text = "'%s' commands:\n" % listData['owner']
	text += "enter 'command ?' for help\n"
	if listData.has_key('public'):
		text += "__public__\n"
		listDataKeys = listData['public'].keys()
		listDataKeys.sort()
		for key in listDataKeys:
			text += "%s%s\n" % (tab, key)
	if listData.has_key('private'):
		text += "__private__\n"
		listDataKeys = listData['private'].keys()
		listDataKeys.sort()
		for key in listDataKeys:
			text += "%s%s\n" % (tab, key)
	return text


def printFormatProfile(profile, tabSize=4, includeDocs=False):
	"""
	Prints out a formatted text version of a client profile.
	
	Note: does not currently support display of 
	documentation info for commands.
	"""
	tab = ' ' * tabSize
	text = 'client profile:\nname: %s\n' % profile.name
	text += 'description: %s\n' % profile.description
	# services provided
	if len(profile.services_provided) > 0:
		text += 'services provided:\n'
		for key in profile.services_provided.keys():
			text += '%s%s\n' % (tab, key)
	else:text += 'services provided: none\n'
	# services sought
	if len(profile.services_sought) > 0:
		text += 'services sought:\n'
		for key in profile.services_sought.keys():
			text += '%s%s\n' % (tab, key)
	else:text += 'services sought: none\n'
	# remote methods
	if len(profile.remote_call_methods) > 0:
		text += 'remote methods:\n'
		for key in profile.remote_call_methods.keys():
			text += '%s%s\n' % (tab, key)
	else:text += 'remote methods: none\n'
	# script methods
	if len(profile.script_methods) > 0:
		text += 'script methods:\n'
		for key in profile.script_methods.keys():
			text += '%s%s\n' % (tab, key)
	else:text += 'script methods: none\n'
	return text

	
	