# svs_core.network.services

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Tools for handling service lookup and connection.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
#############################
# EXCEPTIONS
#############################
class ServiceBrokerException(Exception):pass



#############################
# CLASSES
#############################
class ServiceBroker:
	"""
	Facilitates linkups between clients seeking, 
	or offering services on the network.
	"""
	def __init__(self, host):
		self.host = host
		self.services_sought = {}
		self.services_offered = {}
		
	def purgeExpiredAdverts(self):
		"""
		Cleans out any adverts that have passed their
		expiry date.
		"""
		pass
		
		
	def placeAdvert(self, advert):
		"""
		Received new advert and checks if any existing respondents.
		"""
		pass
		
	def notifyAdvertiser(self, advertiser, response):
		"""
		Provides response to advert for specified client.
		"""
		pass
	