# svs_core.utilities.constants

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Constants for SVS modules.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_core.utilities.lib import Constants



svs_const = Constants()

# message labels
svs_const.NEW_CLIENT = 'new_client'
svs_const.CLIENT_NAME = 'client_name'
svs_const.CLIENT_GROUP = 'client_group'
svs_const.CLIENT_JOINED = 'client_joined'
svs_const.CLIENT_DEPARTED = 'client_departed'
svs_const.SERVER_MESSAGE = 'server_message'
svs_const.GROUP_LIST = 'group_list'
# chat messages
svs_const.CHAT_MESSAGE = 'chat_message'
svs_const.RECIPIENTS_ALL = 'recipients_all'
# data labels
svs_const.ALL_DATA = '_all_'
svs_const.CURRENT_DATA = "_current_data_"
# notification
svs_const.COLLECT_AND_DESTROY = 100
svs_const.START_LISTEN = 200
svs_const.STOP_LISTEN = 201
svs_const.DATA_UPDATED = 'data_updated'
# command results
svs_const.OK = 0
svs_const.ERROR = 1
# development
svs_const.ROOT_DEVLINE = '/'
