# svs_core.utilities.idbroker

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Module for handling unique identifier tags within a project. The idbroker
is implemented as a singleton.

The idbroker is based on an 'object manager' example by Matthew Walker in I{Massive Multiplayer Game Development}, Charles River Media, 2004.

@author:        Simon Yuill
@copyright:     2005 Simon Yuill
@license:       GNU GPL version 2 or any later version
@contact:       simon@lipparosa.org
"""

import string
import types

def __ModuleInit__():
  """
  Set up module-level attributes
  """
  global g_objects_by_id
  global g_objects_by_type
  global g_ids


  g_objects_by_id = {}
  g_objects_by_type = {}
  g_ids = 0


__ModuleInit__()  # at first import


def newObject(obj):
    """
    Creates unique id for object and adds it to
    lists.
    
    @type 	obj: object
    @param 	obj: object to be given id and added to lists
    """
    obj._uid = nextId()
    g_objects_by_id[obj._uid] = obj
    if g_objects_by_type.has_key(obj.__class__):
        g_objects_by_type[obj.__class__].append(obj)
    else:
        g_objects_by_type[obj.__class__] = []
        g_objects_by_type[obj.__class__].append(obj)
    
def removeObject(obj):
    """
    Removes object from lists.
    
    @type 	obj: object
    @param 	obj: object to be removed
    @rtype: 	integer
    @return: 	id of removed object
    """
    try:
        del g_objects_by_id[obj._uid]
        if g_objects_by_type.has_key(obj.__class__):
            try:
                g_objects_by_type[obj.__class__].remove(obj)
            except ValueError:
                return None
        else:
            return None
        return obj._uid
    except KeyError:
        return None
    
def nextId():
    """
    Generate a new object id.
  
    @rtype: integer
    @return: new unique id
    """
    global g_ids
    g_ids = g_ids + 1
    return g_ids

 

def getObjectFromID(id):
    """
    Returns the object with the requested id, or None 
    if it doesn't exist.
    
    @type 	id: integer
    @param 	id: id for requested object
    @rtype: 	object
    @return: 	requested object
    """
    try:
        return g_objects_by_id[id]
    except KeyError:
        return None


def getObjectsOfType(type):
    """
    Returns a list of objects of specified class type, or None 
    if it doesn't exist.
    
    @type 	type: classobj
    @param 	type: class object type for requested list
    @rtype: list
    @return: list of requested object types
    """
    try:
        return g_objects_by_type[type]
    except KeyError:
        return None

