# svs_core.utilities.notification

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Provides classes for data and event notification.

@author:        Simon Yuill
@copyright:     2005 Simon Yuill
@license:       GNU GPL version 2 or any later version
@contact:       simon@lipparosa.org
"""

# internal imports
from svs_core.utilities.constants import svs_const
from svs_core.commands.scriptcommands import makeCommandResult



class Listenable:
	"""
	Provides methods for a class providing data for other listener classes.
	"""
	def __init__(self):
		self.listeners = {}

	def handleListenRequest(self, listenRequest):
		"""
		Deals with listen request from another client.
		"""
		if not self.listeners:self.listeners = {}
		if listenRequest.action == svs_const.START_LISTEN:
			self.addListener(listenRequest.sender, listenRequest.label)
			return makeCommandResult(message="registered as listener", status=svs_const.OK)
		else:
			self.removeListener(listenRequest.sender, listenRequest.label)
			return makeCommandResult(message="de-registered as listener", status=svs_const.OK)

	def addListener(self, listener, listenFor=svs_const.ALL_DATA):
		"""
		Adds new listener to avatar.
		"""
		if not listenFor:listenFor=svs_const.ALL_DATA
		if not self.listeners.has_key(listenFor):
			self.listeners[listenFor] = []
		if listener not in self.listeners[listenFor]:
			self.listeners[listenFor].append(listener)
	
	def removeListener(self, listener, listenFor=svs_const.ALL_DATA):
		"""
		Removes listener from avatar.
		"""
		if not listenFor:listenFor=svs_const.ALL_DATA
		if not self.listeners.has_key(listenFor):return
		if listener in self.listeners[listenFor]:
			self.listeners[listenFor].remove(listener)

	def notifyListeners(self, listenFor, dataPacket):
		"""
		Forward data to listeners.

		This should be overridden by implementing classes.
		"""
		if not self.listeners.has_key(listenFor):return
		for listener in self.listeners[listenFor]:listener.notify(dataPacket)
