# svs_demogame.base_entities

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Basic entities for demo game.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_demogame.scripts import ScriptHandler, makeScriptFromCode
from svs_core.utilities.idbroker import nextId
#from svs_core.commands.scriptcommands import CommandHandler


#############################
# SCRIPTABLE ENTITY
#############################
class ScriptableEntity:
	def __init__(self):
		self.idNum = nextId()
		self.scriptHandler = ScriptHandler(self)

	def getScriptIdentifier(self):
		"""
		Returns a string name for the object that can be 
		used by the L{ScriptHandler}.

		Overridden by extending class.
		"""
		return "no_identifier"
		
	def setScript(self, script):
		"""
		Sets current script associated with entity.
		"""
		if type(script)is str:script = makeScriptFromCode(script)
		if not script: return None
		return self.scriptHandler.appendScript(script)

	def clearScripts(self):
		"""
		Clears scripts associated with entity.
		"""
		self.scriptHandler.clearScripts()

	def getScript(self, revNum=-1):
		"""
		Returns script associated with entity.
		"""
		if self.scriptHandler:return self.scriptHandler.getScriptRevision(revNum)

	def getScriptCode(self, revNum=-1):
		"""
		Returns source code for script associated with entity.
		"""
		return self.getScript(revNum).code

	def getScriptRevisionLog(self):
		"""
		Returns revisions log for script associated with entity.
		"""
		if self.scriptHandler:return self.scriptHandler.getRevisionLog()

	def executeScriptOnSelf(self):
		"""
		Executes the current script on the entity itself.
		"""
		self.scriptHandler.executeCurrentScript()
