# svs_demogame.gamecode

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Provides a set of utility functions that can be called by game scripts.

This modules is imported into the scripts attached to entities
within the game, such as agents and terrain areas.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

def report(gameData):
	GAME_CLIENT.reportToClient(CALLING_CLIENT, gameData)

def allareas(density):
	for area in GAME_CLIENT.gameworld.terrain.getAllAreas():area.setDensity(density)

def set(name, data):
	return STORE.set(name, data)

def get(name):
	return STORE.get(name)

