# svs_demogame.gamelogic_clients

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Clients for handling game logic.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_demogame.clients import PlayerClient
from svs_demogame.utils import demo_const
from svs_core.commands.scriptcommands import *
from svs_core.network.packets import *
from svs_core.utilities.constants import svs_const


class GameLogicClient(PlayerClient):
	"""
	The C{GameLogicClient} evaluates activities in the game world and evaluates
	them in relation to the logic or rules of the game being played.
	"""
	def __init__(self, name, passwd):
		PlayerClient.__init__(self, name, passwd)

	#######################
	# DATA HANDLING
	#######################
	def handleDataPacket(self, dataPacket):
		"""
		Handles data packet received from network.

		This should be overidden by extending classes.
		""" 
		if not dataPacket:return
		dataLabel = dataPacket.label
		if not dataLabel:return
		# world model
		if dataLabel == demo_const.WORLD_MODEL_LABEL:
			self.setupGameWorld(dataPacket.content)
		elif dataLabel == demo_const.WORLD_UPDATE_LABEL:
			self.updateGameWorld(dataPacket.content)
		else:self.logMessage("data packet received: <%s>" % dataPacket.content)

	#######################
	# GAME WORLD
	#######################
	def setupGameWorld(self, gameWorldData):
		"""
		Sets up internal representation of gameworld.
		"""
		print "setupGameWorld"
		pass

	def updateGameWorld(self, gameWorldData):
		"""
		Updates and evaluates internal representation of gameworld.
		"""
		print "updateGameWorld"
		pass

