# svs_demogame.utils

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Utilities for demo game classes.

This module includes the constants for various values within
the demo game, such as data labels, and display colours.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_core.utilities.lib import Constants


#############################
# CONSTANTS
#############################
demo_const = Constants()

##### labels for data communications
# world
demo_const.WORLD_NAME = 'world_name'
demo_const.WORLD_MODEL_LABEL = 'world_model'
demo_const.WORLD_UPDATE_LABEL = 'world_update'
demo_const.WORLD_MESSAGE_LABEL = 'world_message'
demo_const.WORLD_RUNNING = 'world_running'
# terrain and areas
demo_const.TERRAIN_AREA_LABEL = 'terrain_area'
demo_const.AREA_SCRIPT_LABEL = 'area_script'
demo_const.AREA_ID_LABEL = 'area_id'
demo_const.TERRAIN_LABEL = 'terrain'
demo_const.AGENTS_LABEL = 'agents'
demo_const.AREAS_LABEL = 'areas'
demo_const.AREAS_X_LABEL = 'areas_x'
demo_const.AREAS_Y_LABEL = 'areas_y'
demo_const.AREA_DATA_LABEL = 'area_data'
demo_const.DENSITY_LABEL = 'density'
demo_const.COMPASS_POINTS = ['E', 'SE', 'S', 'SW', 'W', 'NW', 'N', 'NE']
# scripts
demo_const.NEW_AREA_SCRIPT_LABEL = 'new_area_script'
demo_const.NEW_AGENT_SCRIPT_LABEL = 'new_agent_script'
demo_const.SCRIPT_CODE_LABEL = 'script_code'
demo_const.SCRIPT_REVISION_LABEL = 'script_revision'
demo_const.REVISION_NUMBER_LABEL = 'revision_number'
demo_const.AREA_REVISION_LOG_LABEL = 'area_revision_log'
demo_const.AGENT_REVISION_LOG_LABEL = 'agent_revision_log'
demo_const.GET_SCRIPT_REVISION_LABEL = 'get_script_revision'
# agents
demo_const.AGENT_SCRIPT_LABEL = 'agent_script'
demo_const.AGENT_ID_LABEL = 'agent_id' 
demo_const.LOC_X_LABEL = 'loc_x' 
demo_const.LOC_Y_LABEL = 'loc_y'
demo_const.DIM_X_LABEL = 'dim_x' 
demo_const.DIM_Y_LABEL = 'dim_y'
demo_const.FACING_LABEL = 'facing'
# generic
demo_const.NAME_LABEL = 'name'
# view colours
demo_const.BG_COLOUR = 'white'
demo_const.DFT_COLOUR = '#5b5a59' #'#999999'
demo_const.SPRITE_SELECTED_COLOUR = 'red'
demo_const.SPRITE_HILIGHT_COLOUR = '#666666' #'#009999'
demo_const.VIEW_AREA_COLOUR_01 = '#dfddd5' #'#CCCCEE' #'#fff9bb'
demo_const.VIEW_AREA_COLOUR_02 = '#eee8aa'
demo_const.TIME_CURSOR_COLOUR = 'red'

##### client types
demo_const.CODE_PLAYER_CLIENT = 1000 
demo_const.GAME_WORLD_CLIENT = 1001 
demo_const.TRACKING_CLIENT = 1002 

#############################
# XML TAGS
#############################
xml_tags = Constants()
xml_tags.GAMEWORLD_TAG = 'GAMEWORLD'
xml_tags.NAME_TAG = 'NAME'
xml_tags.DIM_X_TAG = 'DIM_X' 
xml_tags.DIM_Y_TAG = 'DIM_Y' 
xml_tags.AREAS_X_TAG = 'AREAS_X' 
xml_tags.AREAS_Y_TAG = 'AREAS_Y'
xml_tags.AGENTS_TAG = 'AGENTS'
xml_tags.AGENT_TAG = 'AGENT' 
xml_tags.LOC_X_TAG = 'LOC_X'
xml_tags.LOC_Y_TAG = 'LOC_Y'
xml_tags.RADIUS_TAG = 'RADIUS'
xml_tags.FACING_TAG = 'FACING'
xml_tags.AREAS_TAG = 'AREAS'
xml_tags.AREA_TAG = 'AREA'
xml_tags.INDEX_X_TAG = 'INDEX_X'
xml_tags.INDEX_Y_TAG = 'INDEX_Y' 
xml_tags.DENSITY_TAG = 'DENSITY' 
xml_tags.SPEED_TAG = 'SPEED'
xml_tags.SCRIPTS_TAG = 'SCRIPTS'
xml_tags.SCRIPT_TAG = 'SCRIPT'
xml_tags.GROUPS_TAG = 'GROUPS'
xml_tags.GROUP_TAG = 'GROUP'
xml_tags.COLOUR_TAG = 'COLOUR'
