# svs_simulation.ai_lib.pathfinding

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Classes for finding with paths in terrain.

This module is based on examples in:
Mat Buckland, 2005, Programming Game AI by Example, Wordware:Plano, 
see U{http://www.wordware.com/files/ai}, and U{http://www.ai-junkie.com}.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

# internal imports
from svs_core.utilities.constants import Constants


#######################
# CONSTANTS
#######################
path_const = Constants()

path_const.NO_CLOSEST_NODE_FOUND = -1


#############################
# CLASSES
#############################
class PathPlanner:
	"""
	This class is used by an entity to determine which 
	paths it should use when travelling.
	"""
	def __init__(self, entity):
		self.entity = entity
		self.navgraph = None
		self.destinationPoint = None
		self.currentSearch = None


	#############################
	# 'PRIVATE' METHODS
	#############################
	def getClosestNodeToPosition(self, pos):
		"""
		Returns the index of the closest visible and 
		unobstructed graph node to the given position.
		"""
		return None
		

	def smoothPathEdgesQuick(self, path):
		"""
		Smooths a path by removing extraneous edges. 
		Note: this may not remove all extraneous edges.
		"""
		pass


	def smoothPathEdgesPrecise(self, path):
		"""
		Smooths a path by removing extraneous edges. 
		This removes *all* extraneous edges.
		"""
		pass

	def prepareForNewSearch():
		"""
		Called at the commencement of a new search request. 
		It clears up the appropriate lists and memory in 
		preparation for a new search request.
		"""
		pass


	#############################
	# 'PUBLIC' METHODS
	#############################
	def requestPathToItem(self, item):
		"""
		Creates an instance of the A* time-sliced search and 
		registers it with the path manager.
		"""
		pass


	def requestPathToPosition(self, targetPos):
		"""
		Creates an instance of the Dijkstra's time-sliced 
		search and registers it with the path manager.
		"""
		pass

	def getPath(self):
		"""
		Called by an agent after it has been notified that a 
		search has terminated successfully. The method extracts 
		the path from L{PathPlanner.currentSearch}, adds additional edges 
		appropriate to the search type and returns it as a list of
		PathEdges.
		"""
		pass


	def getCostToNode(self, node):
		"""
		Returns the cost to travel from the entity's current position 
		to a specific graph node. This method makes use of the 
		pre-calculated lookup table created by Raven_Game.
		"""
		pass


	def getCostToClosestItem(self, GiverType):
		"""
		Returns the cost to the closest instance of the GiverType. 
		This method also makes use of the pre-calculated lookup table. 
		Returns -1 if no active trigger found.
		"""
		pass

  

	def cycleOnce(self):
		"""
		The path manager calls this to iterate once though the 
		search cycle of the currently assigned search algorithm. 
		When a search is terminated the method messages the owner 
		with either the msg_NoPathAvailable or msg_PathReady messages.
		"""
		pass

	def getDestination(self):
		return self.destinationPoint

	def setDestination(self, newPos):
		self.destinationPoint = newPos

	def getNodePosition(self, idx):
		"""
		Used to retrieve the position of a graph node from its index.
		Takes into account the enumerations 'non_graph_source_node' and 
		'non_graph_target_node'
		"""
		pass
