# svs_simulation.network.packets

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Creates and handles packets for exchanging simulation data over network.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_simulation.utilities.constants import sim_const
from svs_core.network.packets import makeDataPacket, DataPacket


def createSimDataPacket(sender, simdata):
	return makeDataPacket(sender, content=simdata, label=sim_const.LABEL_SIMDATA)

def createSimEventPacket(sender, event):
	packet = DataPacket()
	packet.created = event.timestamp
	packet.sender = sender
	packet.recipient = None
	packet.content = event
	packet.label = sim_const.LABEL_SIMEVENT
	packet.timeToLive = None
	return packet
