# svs_simulation.network.processclients

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Clients for handling simulation processes.


@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
#from svs_simulation.worlds.processes import ProcessHandler


class ProcessClient:
	"""
	Base class for client that handles simulation process from world.
	"""
	def __init__(self, processHandler=None, worldName=None):
		self.processHandler = processHandler
		self.worldName = worldName

	def connectAsProcessHandler(self):
		"""
		Connects to world and registers itself as a process handler.
		"""
		pass

	#############################
	# PROCESS FUNCTIONS
	#############################
	def handleUpdateWorld(self, simTime):
		"""
		Handles C{update} from world.
		"""
		pass
		
	def handleStartWorld(self, simTime):
		"""
		Handles C{startWorld} from world.
		"""
		pass
		
	def handleStopWorld(self, simTime):
		"""
		Handles C{stopWorld} from world.
		"""
		pass

	#############################
	# EVENT FUNCTIONS
	#############################
	def handleNotifyOfEvents(self, eventdata):
		"""
		Receives events from world.
		"""
		pass


	#######################
	# DATA HANDLING
	#######################
	def handleDataPacket(self, dataPacket):
		"""
		Handles data packet received from network.

		This should be overidden by extending classes.
		""" 
		if not dataPacket:return
		dataLabel = dataPacket.label
		if not dataLabel:return
		# process messages
		# update world
		if dataLabel == sim_const.LABEL_UPDATEWORLD:
			self.handleUpdateWorld(dataPacket.content)
		# start world
		elif dataLabel == sim_const.LABEL_STARTWORLD:
			self.handleStartWorld(dataPacket.content)
		# stop world
		elif dataLabel == sim_const.LABEL_STOPWORLD:
			self.handleStopWorld(dataPacket.content)
		# events
		elif dataLabel == sim_const.LABEL_NOTIFYOFEVENTS:
			self.handleNotifyOfEvents(dataPacket.content)
		else:self.logMessage("data packet received: <%s>" % dataPacket.content)

	def getDataForLabel(self, dataRequest):
		"""
		Provides custom handling of data requests.

		This should be overridden by extending classes.
		"""
		if not dataRequest.label:return ScriptableClient.getDataForLabel(dataRequest)
		# add methods here
		return ScriptableClient.getDataForLabel(self, dataRequest)
