# svs_simulation.network.simproxies

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Proxies for handling simulation processes over network.


@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_simulation.worlds.processes import ProcessHandler


class ProcessHandlerProxy(ProcessHandler):
	"""
	Represents remote process handling localClient to world.
	"""
	def __init__(self, world, localClient, remoteClient):
		ProcessHandler.__init__(self, world)
		self.localClient = localClient
		self.remoteClient = remoteClient
	
	#############################
	# PROCESS FUNCTIONS
	#############################
	def updateWorld(self, simTime):
		"""
		Forwards C{update} call from world.
		"""
		self.localClient.sendUpdateWorld(self.remoteClient, simTime)

	def startWorld(self, simTime):
		"""
		Forwards C{start} call from world.
		"""
		self.localClient.sendStartWorld(self.remoteClient, simTime)

	def stopWorld(self, simTime):
		"""
		Forwards C{stop} call from world.
		"""
		self.localClient.sendStopWorld(self.remoteClient, simTime)

	#############################
	# EVENT FUNCTIONS
	#############################
	def notifyOfEvents(self, events):
		"""
		Forwards event messages.
		"""
		self.localClient.sendNotifyOfEvents(self.remoteClient, events)




class SimWorldProxy:
	"""
	Represents world to remote process.
	"""
	def __init__(self, name, localClient, worldClient):
		self.name = name
		self.localClient = localClient
		self.worldClient = worldClient

