# svs_simulation.network.terrainproxies

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Classes for creating client-side proxies of terrain classes.


@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_simulation.utilities.constants import sim_const
from svs_simulation.terrain.base_classes import Terrain, Partition



#############################
# TERRAIN PROXY
#############################
class TerrainProxy(Terrain):
	"""
	Client-side proxy for terrain.
	"""
	def __init__(self):
		Terrain.__init__(self)

	#############################
	# ARCHIVING
	#############################
	def encode(self):
		"""
		Returns encoded model of self.

		@rtype: dict
		"""
		encoded = {}
		encoded[sim_const.LABEL_NAME] = self.name
		encoded[sim_const.LABEL_SPACEX] = self.spaceX
		encoded[sim_const.LABEL_SPACEY] = self.spaceY
		encoded[sim_const.LABEL_MARGIN] = self.margin
		encoded[sim_const.LABEL_BOUNDS] = self.bounds.encode()
		if partitions:encoded[sim_const.LABEL_PARTITIONS] = self.encodePartitions(structures, objects, agents)
		return encoded

	def decode(self, data, lod=0):
		"""
		Creates terrain from encoded data.
		
		@type data:dict
		"""
		from svs_simulation.numdata.geomlib import AxialBounds2D
		bounds = AxialBounds2D()
		bounds.decode(data[sim_const.LABEL_BOUNDS])
		self.setup(data.get(sim_const.LABEL_NAME, 'terrain'),
			bounds,
			data[sim_const.LABEL_SPACEX], 
			data[sim_const.LABEL_SPACEY],
			data[sim_const.LABEL_MARGIN])
		if data.has_key(sim_const.LABEL_PARTITIONS):
			if not lod:
				for entry in data[sim_const.LABEL_PARTITIONS]:self.partitions[entry] = None
			else:self.decodePartitions(data[sim_const.LABEL_PARTITIONS])
		return self.partitions

	def decodePartition(self, data):
		"""
		Creates partition from encoded data.

		@type data:dict
		"""
		partition = Partition()
		partition.decode(data, self)
		self.addPartition(partition)
		return partition

