#!/usr/bin/env python

# tutorials.creating_clients.timeservice

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


"""
'Creating Clients' tutorial source code.

Provide current date and time to reuesting clients and keeps
log of how many times each client has made request.

@author:	Simon Yuill
@copyright:	Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

# svs imports
from svs_core.commands.scriptcommands import *
from svs_core.network.clientuser import GenericClient
from svs_core.network.packets import *
from svs_core.utilities.constants import svs_const

# external imports
import time


class TimeService(GenericClient):
	"""
	Client providing time service.
	"""
	def __init__(self, name, passwd):
		GenericClient.__init__(self, name, passwd)
		self.requests = {}

	def getTime(self, requester):
		"""
		Returns current time.

		The time is presented as a tuple in the form:
		(year, month, day, hour, minute, second, weekday, yearday, daylightSavingAdjustment)
		"""
		if self.requests.has_key(requester):
			self.requests[requester] += 1
		else:self.requests[requester] = 1
		timenow = time.localtime()[:-2]
		return makeDataPacket(self.profile.name, content=timenow, label='time')

	def getTimeLog(self):
		"""
		Returns log of those who have asked for the time.
		"""
		return makeDataPacket(self.profile.name, content=self.requests, label='time_log')

	#############################
	# DATA HANDLING
	#############################
	def getDataForLabel(self, dataRequest):
		"""
		Provides custom handling of data requests.

		This should be overidden by extending classes.
		"""
		if not dataRequest.label:return GenericClient.getDataForLabel(dataRequest)
		# get time
		if dataRequest.label == 'time':
			return self.getTime(dataRequest.sender)
		# get time log
		if dataRequest.label == 'time_log':
			return self.getTimeLog()
		# pass to parent method
		GenericClient.getDataForLabel(dataRequest)

		
#########################
# MAIN
#########################
if __name__ == '__main__':
	timeservice = TimeService("time_service", "p@ssw0rd")
	timeservice.connect("time_group", "localhost", 9797)
