#!/usr/bin/env python

# tutorials.creating_clients.timeservicenotify

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


"""
'Creating Clients' tutorial source code.

Time service with notification system.

@author:	Simon Yuill
@copyright:	Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

from timeservice import TimeService


class TimeServiceNotify(TimeService):
	"""
	Client providing time service with listener function.
	"""
	def __init__(self, name, passwd):
		TimeService.__init__(self, name, passwd)

	def getTime(self, requester):
		"""
		Returns current time.

		The time is presented as a tuple in the form:
		(year, month, day, hour, minute, second, weekday, yearday, daylightSavingAdjustment)
		"""
		dataPacket = TimeService.getTime(self, requester)
		# notify listeners of time request
		self.notifyListeners(self.getTimeLog())
		# return time to requester
		return dataPacket


#########################
# MAIN
#########################
if __name__ == '__main__':
	timeservice = TimeServiceNotify("time_service", "p@ssw0rd")
	timeservice.connect("time_group", "localhost", 9797)
